/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionSearcher
implements QueryExecutor<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    public boolean execute(final @NotNull FunctionalExpressionSearch.SearchParameters queryParameters, @NotNull Processor<PsiFunctionalExpression> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "execute"));
        }
        final PsiClass aClass = queryParameters.getElementToSearch();
        if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return LambdaUtil.isFunctionalClass((PsiClass)aClass);
            }
        })).booleanValue() || !PsiUtil.isLanguageLevel8OrHigher((PsiElement)aClass)) {
            return true;
        }
        return JavaFunctionalExpressionSearcher.collectFunctionalExpressions(aClass, (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return queryParameters.getEffectiveSearchScope();
            }
        }), consumer);
    }

    public static boolean collectFunctionalExpressions(final PsiClass aClass, SearchScope searchScope, final Processor<PsiFunctionalExpression> consumer) {
        final SearchScope classScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return aClass.getUseScope();
            }
        });
        SearchScope useScope = searchScope.intersectWith(classScope);
        final Project project = aClass.getProject();
        final GlobalSearchScope scope = useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : new EverythingGlobalScope(project);
        Collection lambdaCandidates = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiMethod>>(){

            public Collection<PsiMethod> compute() {
                String functionalInterfaceName = aClass.getName();
                GlobalSearchScope useClassScope = classScope instanceof GlobalSearchScope ? (GlobalSearchScope)classScope : scope;
                return JavaMethodParameterTypesIndex.getInstance().get(functionalInterfaceName, project, useClassScope);
            }
        });
        for (PsiMethod psiMethod : lambdaCandidates) {
            for (PsiReference ref : MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)scope, (boolean)false)) {
                Boolean accepted;
                PsiExpressionList argumentList;
                PsiElement candidateElement;
                PsiElement refElement = ref.getElement();
                if (refElement == null || !((candidateElement = refElement.getParent()) instanceof PsiCallExpression) || (argumentList = ((PsiCallExpression)candidateElement).getArgumentList()) == null || (accepted = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        PsiExpression[] args;
                        for (PsiExpression arg : args = argumentList.getExpressions()) {
                            PsiFunctionalExpression functionalExpression;
                            PsiType functionalType;
                            if (!(arg instanceof PsiFunctionalExpression) || PsiUtil.resolveClassInType((PsiType)(functionalType = (functionalExpression = (PsiFunctionalExpression)arg).getFunctionalInterfaceType())) != aClass || consumer.process((Object)functionalExpression)) continue;
                            return false;
                        }
                        return true;
                    }
                })).booleanValue()) continue;
                return false;
            }
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)scope)) {
            PsiReturnStatement[] returnStatements;
            PsiElement parent;
            PsiElement element = reference.getElement();
            if (element == null || !((parent = element.getParent()) instanceof PsiTypeElement)) continue;
            final PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiVariable) {
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)gParent).getInitializer());
                if (initializer instanceof PsiFunctionalExpression && !consumer.process((Object)((PsiFunctionalExpression)initializer))) {
                    return false;
                }
                for (PsiReference varRef : ReferencesSearch.search((PsiElement)parent, (SearchScope)scope)) {
                    PsiExpression rExpression;
                    PsiElement varElementParent;
                    PsiElement varElement = varRef.getElement();
                    if (varElement == null || !((varElementParent = varElement.getParent()) instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)varElementParent).getLExpression() != varElement || !((rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)varElementParent).getRExpression())) instanceof PsiFunctionalExpression) || consumer.process((Object)((PsiFunctionalExpression)rExpression))) continue;
                    return false;
                }
                continue;
            }
            if (!(gParent instanceof PsiMethod)) continue;
            for (PsiReturnStatement returnStatement : returnStatements = (PsiReturnStatement[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiReturnStatement[]>(){

                public PsiReturnStatement[] compute() {
                    return PsiUtil.findReturnStatements((PsiMethod)((PsiMethod)gParent));
                }
            })) {
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (!(returnValue instanceof PsiFunctionalExpression) || consumer.process((Object)((PsiFunctionalExpression)returnValue))) continue;
                return false;
            }
        }
        return true;
    }
}

