/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters p, final @NotNull Processor<PsiClass> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        final PsiClass aClass = p.getClassToProcess();
        final PsiManagerImpl psiManager = (PsiManagerImpl)aClass.getManager();
        SearchScope useScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                return aClass.getUseScope();
            }
        });
        String qualifiedName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return aClass.getQualifiedName();
            }
        });
        if ("java.lang.Object".equals(qualifiedName)) {
            SearchScope scope = useScope;
            return AllClassesSearch.search((SearchScope)scope, (Project)aClass.getProject()).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    if (psiClass.isInterface()) {
                        return consumer.process((Object)psiClass);
                    }
                    final PsiClass superClass = psiClass.getSuperClass();
                    if (superClass != null && "java.lang.Object".equals(ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                        public String compute() {
                            return superClass.getQualifiedName();
                        }
                    }))) {
                        return consumer.process((Object)psiClass);
                    }
                    return true;
                }
            });
        }
        final GlobalSearchScope scope = useScope instanceof GlobalSearchScope ? (GlobalSearchScope)useScope : new EverythingGlobalScope(psiManager.getProject());
        final String searchKey = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return aClass.getName();
            }
        });
        if (StringUtil.isEmpty((String)searchKey)) {
            return true;
        }
        Collection candidates = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiReferenceList>>(){

            public Collection<PsiReferenceList> compute() {
                return JavaSuperClassNameOccurenceIndex.getInstance().get(searchKey, psiManager.getProject(), scope);
            }
        });
        HashMap classes = new HashMap();
        for (PsiReferenceList referenceList : candidates) {
            ProgressIndicatorProvider.checkCanceled();
            final PsiClass candidate = (PsiClass)referenceList.getParent();
            if (!JavaDirectInheritorsSearcher.checkInheritance(p, aClass, candidate)) continue;
            String fqn = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return candidate.getQualifiedName();
                }
            });
            ArrayList<PsiClass> list = (ArrayList<PsiClass>)classes.get(fqn);
            if (list == null) {
                list = new ArrayList<PsiClass>();
                classes.put(fqn, list);
            }
            list.add(candidate);
        }
        for (List sameNamedClasses : classes.values()) {
            if (JavaDirectInheritorsSearcher.processSameNamedClasses(consumer, aClass, sameNamedClasses)) continue;
            return false;
        }
        if (p.includeAnonymous()) {
            Collection anonymousCandidates = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiAnonymousClass>>(){

                public Collection<PsiAnonymousClass> compute() {
                    return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(searchKey, psiManager.getProject(), scope);
                }
            });
            for (final PsiClass candidate : anonymousCandidates) {
                ProgressIndicatorProvider.checkCanceled();
                if (!JavaDirectInheritorsSearcher.checkInheritance(p, aClass, candidate) || consumer.process((Object)candidate)) continue;
                return false;
            }
            if (aClass.isEnum()) {
                PsiField[] fields;
                for (final PsiField field : fields = (PsiField[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiField[]>(){

                    public PsiField[] compute() {
                        return aClass.getFields();
                    }
                })) {
                    PsiEnumConstantInitializer initializingClass;
                    if (!(field instanceof PsiEnumConstant) || (initializingClass = (PsiEnumConstantInitializer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiEnumConstantInitializer>(){

                        public PsiEnumConstantInitializer compute() {
                            return ((PsiEnumConstant)field).getInitializingClass();
                        }
                    })) == null || consumer.process((Object)initializingClass)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkInheritance(final DirectClassInheritorsSearch.SearchParameters p, final PsiClass aClass, final PsiClass candidate) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return !p.isCheckInheritance() || candidate.isInheritor(aClass, false);
            }
        });
    }

    private static boolean processSameNamedClasses(Processor<PsiClass> consumer, PsiClass aClass, List<PsiClass> sameNamedClasses) {
        boolean sameJarClassFound = false;
        VirtualFile jarFile = PsiUtil.getJarFile((PsiElement)aClass);
        if (jarFile != null) {
            for (PsiClass sameNamedClass : sameNamedClasses) {
                boolean fromSameJar = Comparing.equal((Object)PsiUtil.getJarFile((PsiElement)sameNamedClass), (Object)jarFile);
                if (!fromSameJar) continue;
                sameJarClassFound = true;
                if (consumer.process((Object)sameNamedClass)) continue;
                return false;
            }
        }
        return sameJarClassFound || ContainerUtil.process(sameNamedClasses, consumer);
    }
}

