/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, final @NotNull Processor<Pair<PsiMethod, PsiMethod>> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        final PsiClass psiClass = p.getPsiClass();
        PsiMethod[] methodsArray = psiClass.getMethods();
        final ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(methodsArray.length);
        for (PsiMethod method : methodsArray) {
            if (!PsiUtil.canBeOverriden((PsiMethod)method)) continue;
            methods.add(method);
        }
        SearchScope scope = p.getScope();
        Processor<PsiClass> inheritorsProcessor = new Processor<PsiClass>(){

            public boolean process(PsiClass inheritor) {
                PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)psiClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                if (substitutor == null) {
                    return true;
                }
                for (PsiMethod method : methods) {
                    PsiClass superClass;
                    MethodSignature signature;
                    PsiMethod inInheritor;
                    if (method.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)inheritor.getProject()).arePackagesTheSame((PsiElement)psiClass, (PsiElement)inheritor) || !((inInheritor = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)(signature = method.getSignature(substitutor)), (boolean)false)) == null || inInheritor.hasModifierProperty("static") ? psiClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(psiClass, true) && (inInheritor = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)signature, (boolean)true)) != null && !inInheritor.hasModifierProperty("static") && !consumer.process((Object)new Pair((Object)method, (Object)inInheritor)) : !consumer.process((Object)new Pair((Object)method, (Object)inInheritor)))) continue;
                    return false;
                }
                return true;
            }
        };
        return ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)scope, (boolean)true).forEach((Processor)inheritorsProcessor);
    }
}

