/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.ConstructorReferencesSearchHelper;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ConstructorReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/ConstructorReferencesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/ConstructorReferencesSearcher", "processQuery"));
        }
        PsiElement element = p.getElementToSearch();
        if (!(element instanceof PsiMethod)) {
            return;
        }
        final PsiMethod method = (PsiMethod)element;
        final PsiManager[] manager = new PsiManager[1];
        PsiClass aClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                if (!method.isConstructor()) {
                    return null;
                }
                PsiClass aClass = method.getContainingClass();
                manager[0] = aClass == null ? null : aClass.getManager();
                return aClass;
            }
        });
        if (manager[0] == null) {
            return;
        }
        new ConstructorReferencesSearchHelper(manager[0]).processConstructorReferences(consumer, method, aClass, p.getScope(), p.isIgnoreAccessScope(), true, p.getOptimizer());
    }
}

