/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    public boolean execute(@NotNull AllClassesSearch.SearchParameters queryParameters, @NotNull Processor<PsiClass> consumer) {
        PsiElement[] scopeRoots;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "execute"));
        }
        SearchScope scope = queryParameters.getScope();
        if (scope instanceof GlobalSearchScope) {
            return AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, queryParameters, consumer);
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(final @NotNull GlobalSearchScope scope, final @NotNull AllClassesSearch.SearchParameters parameters, @NotNull Processor<PsiClass> processor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processAllClassesInGlobalScope"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processAllClassesInGlobalScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processAllClassesInGlobalScope"));
        }
        Project project = parameters.getProject();
        final PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        THashSet names = new THashSet(10000);
        cache.processAllClassNames((Processor)new Processor<String>((Set)names){
            int i = 0;
            final /* synthetic */ Set val$names;
            {
                this.val$names = set;
            }

            public boolean process(String s) {
                if (indicator != null && this.i++ % 512 == 0) {
                    indicator.checkCanceled();
                }
                if (parameters.nameMatches(s)) {
                    this.val$names.add(s);
                }
                return true;
            }
        }, scope, IdFilter.getProjectIdFilter((Project)project, (boolean)true));
        if (indicator != null) {
            indicator.checkCanceled();
        }
        ArrayList sorted = new ArrayList(names);
        Collections.sort(sorted, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (final String name : sorted) {
            PsiClass[] classes;
            ProgressIndicatorProvider.checkCanceled();
            for (PsiClass psiClass : classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                public PsiClass[] compute() {
                    return cache.getClassesByName(name, scope);
                }
            })) {
                ProgressIndicatorProvider.checkCanceled();
                if (processor.process((Object)psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processScopeRootForAllClasses(final @NotNull PsiElement scopeRoot, final @NotNull Processor<PsiClass> processor) {
        if (scopeRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processScopeRootForAllClasses"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/search/AllClassesSearchExecutor", "processScopeRootForAllClasses"));
        }
        final boolean[] stopped = new boolean[]{false};
        Object visitor = scopeRoot instanceof PsiCompiledElement ? new JavaRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor.process((Object)aClass);
                super.visitClass(aClass);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor.process((Object)aClass);
                super.visitClass(aClass);
            }
        };
        ApplicationManager.getApplication().runReadAction(new Runnable((JavaElementVisitor)visitor){
            final /* synthetic */ JavaElementVisitor val$visitor;
            {
                this.val$visitor = javaElementVisitor;
            }

            @Override
            public void run() {
                scopeRoot.accept((PsiElementVisitor)this.val$visitor);
            }
        });
        return !stopped[0];
    }
}

