/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightParameterListBuilder
extends LightElement
implements PsiParameterList {
    private final List<PsiParameter> myParameters = new ArrayList<PsiParameter>();
    private PsiParameter[] myCachedParameters;

    public LightParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    public void addParameter(PsiParameter parameter) {
        this.myParameters.add(parameter);
        this.myCachedParameters = null;
    }

    @Override
    public String toString() {
        return "Light parameter lsit";
    }

    @NotNull
    public PsiParameter[] getParameters() {
        if (this.myCachedParameters == null) {
            this.myCachedParameters = this.myParameters.isEmpty() ? PsiParameter.EMPTY_ARRAY : this.myParameters.toArray(new PsiParameter[this.myParameters.size()]);
        }
        if (this.myCachedParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightParameterListBuilder", "getParameters"));
        }
        return this.myCachedParameters;
    }

    public int getParameterIndex(PsiParameter parameter) {
        return this.myParameters.indexOf(parameter);
    }

    public int getParametersCount() {
        return this.myParameters.size();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/light/LightParameterListBuilder", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameterList((PsiParameterList)this);
        }
    }
}

