/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.IconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.SourceRootPresentation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DirectoryIconProvider
extends IconProvider
implements DumbAware {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/DirectoryIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            VirtualFile vFile = psiDirectory.getVirtualFile();
            SourceFolder sourceFolder = ProjectRootsUtil.getModuleSourceRoot(vFile, psiDirectory.getProject());
            if (sourceFolder != null) {
                return SourceRootPresentation.getSourceRootIcon(sourceFolder);
            }
            return PlatformIcons.DIRECTORY_CLOSED_ICON;
        }
        return null;
    }
}

