/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClsAnnotationValueImpl
extends ClsElementImpl
implements PsiAnnotation,
Navigatable {
    private final ClsElementImpl myParent;
    private final ClsJavaCodeReferenceElementImpl myReferenceElement;
    private final ClsAnnotationParameterListImpl myParameterList;

    public ClsAnnotationValueImpl(@NotNull ClsElementImpl parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "<init>"));
        }
        this.myParent = parent;
        this.myReferenceElement = this.createReference();
        this.myParameterList = this.createParameterList();
    }

    protected abstract ClsAnnotationParameterListImpl createParameterList();

    protected abstract ClsJavaCodeReferenceElementImpl createReference();

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "appendMirrorText"));
        }
        buffer.append("@").append(this.myReferenceElement.getCanonicalText());
        this.myParameterList.appendMirrorText(indentLevel, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsAnnotationValueImpl.setMirror(this.getNameReferenceElement(), mirror.getNameReferenceElement());
        ClsAnnotationValueImpl.setMirror(this.getParameterList(), mirror.getParameterList());
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myReferenceElement, this.myParameterList};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "getChildren"));
        }
        return psiElementArray;
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotation((PsiAnnotation)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        ClsAnnotationParameterListImpl clsAnnotationParameterListImpl = this.myParameterList;
        if (clsAnnotationParameterListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsAnnotationValueImpl", "getParameterList"));
        }
        return clsAnnotationParameterListImpl;
    }

    @Nullable
    public String getQualifiedName() {
        return this.myReferenceElement != null ? this.myReferenceElement.getCanonicalText() : null;
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        return this.myReferenceElement;
    }

    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, T value) {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        this.appendMirrorText(0, buffer);
        return buffer.toString();
    }

    public PsiMetaData getMetaData() {
        return MetaRegistry.getMetaBase((PsiElement)this);
    }
}

