/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileDecompiler
implements BinaryFileDecompiler {
    @NotNull
    public CharSequence decompile(@NotNull VirtualFile file) {
        CharSequence result;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
        }
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file);
        if (decompiler instanceof ClassFileDecompilers.Full) {
            PsiManager manager = PsiManager.getInstance((Project)DefaultProjectFactory.getInstance().getDefaultProject());
            CharSequence charSequence = ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file, manager, true).getContents();
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
            }
            return charSequence;
        }
        PlatformDecompiler platformDecompiler = (PlatformDecompiler)ServiceManager.getService(PlatformDecompiler.class);
        if (platformDecompiler != null && (result = platformDecompiler.decompile(file)) != null) {
            CharSequence charSequence = result;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
            }
            return charSequence;
        }
        CharSequence charSequence = ClassFileDecompiler.decompileText(file);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompile"));
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence decompileText(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompileText"));
        }
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file);
        if (decompiler instanceof ClassFileDecompilers.Light) {
            CharSequence charSequence = ((ClassFileDecompilers.Light)decompiler).getText(file);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompileText"));
            }
            return charSequence;
        }
        CharSequence charSequence = ClsFileImpl.decompile(file);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClassFileDecompiler", "decompileText"));
        }
        return charSequence;
    }

    public static interface PlatformDecompiler {
        @Nullable
        public CharSequence decompile(@NotNull VirtualFile var1);
    }
}

