/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Queue;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentCommitThread
extends DocumentCommitProcessor
implements Runnable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.DocumentCommitThread");
    private final Queue<DocumentCommitProcessor.CommitTask> documentsToCommit = new Queue(10);
    private final List<DocumentCommitProcessor.CommitTask> documentsToApplyInEDT = new ArrayList<DocumentCommitProcessor.CommitTask>(10);
    private volatile boolean isDisposed;
    private DocumentCommitProcessor.CommitTask currentTask;
    private volatile boolean threadFinished;
    private volatile boolean myEnabled = true;
    private final StringBuilder log = new StringBuilder();

    public static DocumentCommitThread getInstance() {
        return (DocumentCommitThread)ServiceManager.getService(DocumentCommitThread.class);
    }

    public DocumentCommitThread() {
        this.log("Starting thread", null, false, new Object[0]);
        new Thread((Runnable)this, "Document commit thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isDisposed = true;
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            this.documentsToCommit.clear();
        }
        this.cancel("Stop thread");
        this.wakeUpQueue();
        while (!this.threadFinished) {
            this.wakeUpQueue();
            queue = this.documentsToCommit;
            synchronized (queue) {
                try {
                    this.documentsToCommit.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void disable(@NonNls Object reason) {
        this.cancel(reason);
        this.myEnabled = false;
        this.log("Disabled", null, false, reason);
    }

    public void enable(Object reason) {
        this.myEnabled = true;
        this.wakeUpQueue();
        this.log("Enabled", null, false, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpQueue() {
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            this.documentsToCommit.notifyAll();
        }
    }

    private void cancel(@NonNls Object reason) {
        this.startNewTask(null, reason);
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        this.queueCommit(project, document, reason);
    }

    public void queueCommit(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitThread", "queueCommit"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/DocumentCommitThread", "queueCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/DocumentCommitThread", "queueCommit"));
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
        if (psiFile == null) {
            return;
        }
        this.doQueue(project, document, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(Project project, Document document, Object reason) {
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            DaemonProgressIndicator indicator = new DaemonProgressIndicator();
            DocumentCommitProcessor.CommitTask newTask = new DocumentCommitProcessor.CommitTask(document, project, indicator, reason);
            this.markRemovedFromDocsToCommit(newTask);
            this.markRemovedCurrentTask(newTask);
            this.removeFromDocsToApplyInEDT(newTask);
            this.documentsToCommit.addLast((Object)newTask);
            this.log("Queued", newTask, false, reason);
            this.wakeUpQueue();
        }
    }

    @Override
    public void log(@NonNls String msg, @Nullable DocumentCommitProcessor.CommitTask task, boolean synchronously, Object ... args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            this.cancel("cancel all in tests");
            this.markRemovedFromDocsToCommit(null);
            this.documentsToCommit.clear();
            this.removeFromDocsToApplyInEDT(null);
            this.markRemovedCurrentTask(null);
        }
    }

    public void clearQueue() {
        this.cancelAll();
        this.log.setLength(0);
        this.disable("end of test");
        this.wakeUpQueue();
    }

    private void markRemovedCurrentTask(@Nullable DocumentCommitProcessor.CommitTask newTask) {
        DocumentCommitProcessor.CommitTask task = this.currentTask;
        if (task != null && (newTask == null || task.equals(newTask))) {
            task.removed = true;
            this.cancel("Sync commit intervened");
        }
    }

    private void removeFromDocsToApplyInEDT(@Nullable(value="null means all") DocumentCommitProcessor.CommitTask newTask) {
        for (int i = this.documentsToApplyInEDT.size() - 1; i >= 0; --i) {
            DocumentCommitProcessor.CommitTask task = this.documentsToApplyInEDT.get(i);
            if (newTask != null && !task.equals(newTask)) continue;
            task.removed = true;
            this.documentsToApplyInEDT.remove(i);
            this.log("Marked and Removed from EDT apply queue (sync commit called)", task, true, new Object[0]);
        }
    }

    private void markRemovedFromDocsToCommit(final @Nullable(value="null means all") DocumentCommitProcessor.CommitTask newTask) {
        this.processAll(new Processor<DocumentCommitProcessor.CommitTask>(){

            public boolean process(DocumentCommitProcessor.CommitTask task) {
                if (newTask == null || task.equals(newTask)) {
                    task.removed = true;
                    DocumentCommitThread.this.log("marker as Removed in background queue", task, true, new Object[0]);
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.threadFinished = false;
        try {
            while (!this.isDisposed) {
                try {
                    this.pollQueue();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        finally {
            this.threadFinished = true;
        }
        this.wakeUpQueue();
        this.log("Good bye", null, false, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollQueue() {
        boolean success = false;
        Document document = null;
        Project project = null;
        DocumentCommitProcessor.CommitTask task = null;
        try {
            ProgressIndicator indicator;
            Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
            synchronized (queue) {
                if (!this.myEnabled || this.documentsToCommit.isEmpty()) {
                    this.documentsToCommit.wait();
                    return;
                }
                task = (DocumentCommitProcessor.CommitTask)this.documentsToCommit.pullFirst();
                document = task.document;
                indicator = task.indicator;
                project = task.project;
                this.log("Pulled", task, false, indicator);
                if (project.isDisposed() || !((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project)).isInUncommittedSet(document)) {
                    this.log("Abandon and proceed to next", task, false, new Object[0]);
                    return;
                }
                if (task.removed) {
                    return;
                }
                this.startNewTask(task, "Pulled new task");
                this.documentsToApplyInEDT.add(task);
            }
            Runnable finishRunnable = null;
            if (indicator.isCanceled()) {
                success = false;
            } else {
                final DocumentCommitProcessor.CommitTask commitTask = task;
                final Runnable[] result = new Runnable[1];
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = DocumentCommitThread.this.commitUnderProgress(commitTask, false);
                    }
                }, commitTask.indicator);
                finishRunnable = result[0];
                success = finishRunnable != null;
                this.log("commit returned", task, false, finishRunnable, indicator);
            }
            if (success) {
                assert (!ApplicationManager.getApplication().isDispatchThread());
                UIUtil.invokeLaterIfNeeded(finishRunnable);
                this.log("Invoked later finishRunnable", task, false, success, finishRunnable, indicator);
            }
        }
        catch (ProcessCanceledException e) {
            this.cancel((Object)e);
            this.log("PCE", task, false, new Object[]{e});
            success = false;
        }
        catch (InterruptedException e) {
            this.log("IE", task, false, e);
            this.cancel(e);
        }
        catch (Throwable e) {
            LOG.error(e);
            this.cancel(e);
        }
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            if (!success && !task.removed) {
                this.doQueue(project, document, "re-added on failure");
            }
            this.currentTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        assert (!this.isDisposed);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!project.isInitialized() && !project.isDefault()) {
            String s = project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            s = s + "; SA Passed: ";
            try {
                s = s + ((StartupManagerImpl)StartupManager.getInstance((Project)project)).startupActivityPassed();
            }
            catch (Exception e) {
                s = s + e;
            }
            try {
                Disposer.dispose((Disposable)project);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        ProgressIndicator indicator = this.createProgressIndicator();
        DocumentCommitProcessor.CommitTask task = new DocumentCommitProcessor.CommitTask(document, project, indicator, "Sync commit");
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            this.markRemovedFromDocsToCommit(task);
            this.markRemovedCurrentTask(task);
            this.removeFromDocsToApplyInEDT(task);
        }
        this.log("About to commit sync", task, true, indicator);
        Runnable finish = this.commitUnderProgress(task, true);
        this.log("Committed sync", task, true, finish, indicator);
        assert (finish != null);
        finish.run();
        this.wakeUpQueue();
    }

    @Override
    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        ProgressIndicatorBase progressIndicatorBase = new ProgressIndicatorBase();
        if (progressIndicatorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createProgressIndicator"));
        }
        return progressIndicatorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(DocumentCommitProcessor.CommitTask task, Object reason) {
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            DocumentCommitProcessor.CommitTask cur = this.currentTask;
            if (cur != null) {
                cur.indicator.cancel();
            }
            this.currentTask = task;
        }
    }

    @Nullable
    private Runnable commitUnderProgress(final @NotNull DocumentCommitProcessor.CommitTask task, boolean synchronously) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        final Project project = task.project;
        final Document document = task.document;
        SmartList finishProcessors = new SmartList();
        Runnable runnable = new Runnable((List)finishProcessors, task, synchronously){
            final /* synthetic */ List val$finishProcessors;
            final /* synthetic */ DocumentCommitProcessor.CommitTask val$task;
            final /* synthetic */ boolean val$synchronously;
            {
                this.val$finishProcessors = list;
                this.val$task = commitTask;
                this.val$synchronously = bl;
            }

            @Override
            public void run() {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                if (project.isDisposed()) {
                    return;
                }
                PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project);
                if (documentManager.isCommitted(document)) {
                    return;
                }
                FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
                if (viewProvider == null) {
                    this.val$finishProcessors.add(DocumentCommitThread.this.handleCommitWithoutPsi(documentManager, document, this.val$task, this.val$synchronously));
                    return;
                }
                List psiFiles = viewProvider.getAllFiles();
                for (PsiFile file : psiFiles) {
                    Processor<Document> finishProcessor;
                    if (!file.isValid() || (finishProcessor = DocumentCommitThread.this.doCommit(this.val$task, file, this.val$synchronously)) == null) continue;
                    this.val$finishProcessors.add(finishProcessor);
                }
            }
        };
        if (synchronously) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            runnable.run();
        } else if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(runnable)) {
            this.log("Could not start read action", task, synchronously, ApplicationManager.getApplication().isReadAccessAllowed(), Thread.currentThread());
            return null;
        }
        boolean canceled = task.indicator.isCanceled();
        assert (!synchronously || !canceled);
        if (canceled || task.removed) {
            return null;
        }
        Runnable finishRunnable = new Runnable((List)finishProcessors, synchronously){
            final /* synthetic */ List val$finishProcessors;
            final /* synthetic */ boolean val$synchronously;
            {
                this.val$finishProcessors = list;
                this.val$synchronously = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                Project project = task.project;
                if (project.isDisposed()) {
                    return;
                }
                Document document = task.document;
                Queue queue = DocumentCommitThread.this.documentsToCommit;
                synchronized (queue) {
                    boolean isValid = !task.removed;
                    for (int i = DocumentCommitThread.this.documentsToApplyInEDT.size() - 1; i >= 0; --i) {
                        boolean taskIsValid;
                        DocumentCommitProcessor.CommitTask queuedTask = (DocumentCommitProcessor.CommitTask)DocumentCommitThread.this.documentsToApplyInEDT.get(i);
                        boolean bl = taskIsValid = !queuedTask.removed;
                        if (task == queuedTask) {
                            DocumentCommitThread.this.documentsToApplyInEDT.remove(i);
                            isValid &= taskIsValid;
                            DocumentCommitThread.this.log("Task matched, removed from documentsToApplyInEDT", queuedTask, false, task);
                            continue;
                        }
                        if (taskIsValid) continue;
                        DocumentCommitThread.this.documentsToApplyInEDT.remove(i);
                        DocumentCommitThread.this.log("Task invalid, removed from documentsToApplyInEDT", queuedTask, false, new Object[0]);
                    }
                    if (!isValid) {
                        DocumentCommitThread.this.log("Marked as already committed in EDT apply queue, return", task, true, new Object[0]);
                        return;
                    }
                }
                PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project);
                DocumentCommitThread.this.log("Executing later finishCommit", task, false, new Object[0]);
                boolean success = documentManager.finishCommit(document, this.val$finishProcessors, this.val$synchronously, task.reason);
                if (this.val$synchronously) assert (success);
                DocumentCommitThread.this.log("after call finishCommit", task, this.val$synchronously, success);
                if (this.val$synchronously || success) assert (!documentManager.isInUncommittedSet(document));
                if (!success) {
                    DocumentCommitThread.this.queueCommit(project, document, "Re-added back");
                }
            }
        };
        return finishRunnable;
    }

    private Processor<Document> handleCommitWithoutPsi(final PsiDocumentManagerImpl documentManager, Document document, final DocumentCommitProcessor.CommitTask task, final boolean synchronously) {
        final long startDocModificationTimeStamp = document.getModificationStamp();
        return new Processor<Document>(){

            public boolean process(Document document) {
                DocumentCommitThread.this.log("Finishing without PSI", task, synchronously, document.getModificationStamp(), startDocModificationTimeStamp);
                if (document.getModificationStamp() != startDocModificationTimeStamp || documentManager.getCachedViewProvider(document) != null) {
                    return false;
                }
                documentManager.handleCommitWithoutPsi(document);
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAll(final Processor<DocumentCommitProcessor.CommitTask> processor) {
        final boolean[] result = new boolean[]{true};
        Queue<DocumentCommitProcessor.CommitTask> queue = this.documentsToCommit;
        synchronized (queue) {
            this.documentsToCommit.process((Processor)new Processor<DocumentCommitProcessor.CommitTask>(){

                public boolean process(DocumentCommitProcessor.CommitTask commitTask) {
                    result[0] = result[0] & processor.process((Object)commitTask);
                    return true;
                }
            });
        }
        return result[0];
    }
}

