/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InjectedLanguageBlockBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.xml.XmlInjectedLanguageBlockBuilder");

    public Block createInjectedBlock(ASTNode node, Block originalBlock, Indent indent, int offset, TextRange range, @Nullable Language language) {
        return new InjectedLanguageBlockWrapper(originalBlock, offset, range, indent, language);
    }

    public abstract CodeStyleSettings getSettings();

    public abstract boolean canProcessFragment(String var1, ASTNode var2);

    public abstract Block createBlockBeforeInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public abstract Block createBlockAfterInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public boolean addInjectedBlocks(List<Block> result, final ASTNode injectionHost, Wrap wrap, Alignment alignment, Indent indent) {
        Language childLanguage;
        FormattingModelBuilder builder;
        final PsiFile[] injectedFile = new PsiFile[1];
        final Ref injectedRangeInsideHost = new Ref();
        final Ref prefixLength = new Ref();
        final Ref suffixLength = new Ref();
        Ref injectionHostToUse = new Ref((Object)injectionHost);
        PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                String childText;
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/common/InjectedLanguageBlockBuilder$1", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/formatter/common/InjectedLanguageBlockBuilder$1", "visit"));
                }
                if (places.size() != 1) {
                    return;
                }
                PsiLanguageInjectionHost.Shred shred = places.get(0);
                TextRange textRange = shred.getRangeInsideHost();
                PsiLanguageInjectionHost shredHost = shred.getHost();
                if (shredHost == null) {
                    return;
                }
                ASTNode node = shredHost.getNode();
                if (node == null) {
                    return;
                }
                if (node != injectionHost) {
                    int shift = 0;
                    boolean canProcess = false;
                    ASTNode prev = injectionHost;
                    for (ASTNode n = injectionHost.getTreeParent(); n != null; n = n.getTreeParent()) {
                        shift += n.getStartOffset() - prev.getStartOffset();
                        if (n == node) {
                            textRange = textRange.shiftRight(shift);
                            canProcess = true;
                            break;
                        }
                        prev = n;
                    }
                    if (!canProcess) {
                        return;
                    }
                }
                if (injectionHost.getTextLength() == textRange.getEndOffset() && textRange.getStartOffset() == 0 || InjectedLanguageBlockBuilder.this.canProcessFragment((childText = injectionHost.getText()).substring(0, textRange.getStartOffset()), injectionHost) && InjectedLanguageBlockBuilder.this.canProcessFragment(childText.substring(textRange.getEndOffset()), injectionHost)) {
                    injectedFile[0] = injectedPsi;
                    injectedRangeInsideHost.set((Object)textRange);
                    prefixLength.set((Object)shred.getPrefix().length());
                    suffixLength.set((Object)shred.getSuffix().length());
                }
            }
        };
        PsiElement injectionHostPsi = injectionHost.getPsi();
        InjectedLanguageUtil.enumerate(injectionHostPsi, injectionHostPsi.getContainingFile(), false, injectedPsiVisitor);
        if (injectedFile[0] != null && (builder = LanguageFormatting.INSTANCE.forContext(childLanguage = injectedFile[0].getLanguage(), injectionHostPsi)) != null) {
            ASTNode leaf;
            int startOffset = ((TextRange)injectedRangeInsideHost.get()).getStartOffset();
            int endOffset = ((TextRange)injectedRangeInsideHost.get()).getEndOffset();
            TextRange range = ((ASTNode)injectionHostToUse.get()).getTextRange();
            int childOffset = range.getStartOffset();
            if (startOffset != 0) {
                leaf = ((ASTNode)injectionHostToUse.get()).findLeafElementAt(startOffset - 1);
                result.add(this.createBlockBeforeInjection(leaf, wrap, alignment, indent, new TextRange(childOffset, childOffset + startOffset)));
            }
            this.addInjectedLanguageBlockWrapper(result, (ASTNode)injectedFile[0].getNode(), indent, childOffset + startOffset, new TextRange(((Integer)prefixLength.get()).intValue(), injectedFile[0].getTextLength() - (Integer)suffixLength.get()));
            if (endOffset != ((ASTNode)injectionHostToUse.get()).getTextLength()) {
                leaf = ((ASTNode)injectionHostToUse.get()).findLeafElementAt(endOffset);
                result.add(this.createBlockAfterInjection(leaf, wrap, alignment, indent, new TextRange(childOffset + endOffset, range.getEndOffset())));
            }
            return true;
        }
        return false;
    }

    public void addInjectedLanguageBlockWrapper(List<Block> result, ASTNode injectedNode, Indent indent, int offset, @Nullable TextRange range) {
        PsiElement childPsi;
        Language childLanguage;
        FormattingModelBuilder builder;
        if (range != null) {
            if (range.getLength() == 0) {
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)range.substring(injectedNode.getText()))) {
                return;
            }
        }
        LOG.assertTrue((builder = LanguageFormatting.INSTANCE.forContext(childLanguage = (childPsi = injectedNode.getPsi()).getLanguage(), childPsi)) != null);
        FormattingModel childModel = builder.createModel(childPsi, this.getSettings());
        Block original = childModel.getRootBlock();
        if (original.isLeaf() && !injectedNode.getText().trim().isEmpty() || !original.getSubBlocks().isEmpty()) {
            result.add(this.createInjectedBlock(injectedNode, original, indent, offset, range, childLanguage));
        }
    }
}

