/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeWhiteSpaceFormattingStrategy
implements WhiteSpaceFormattingStrategy {
    private final List<WhiteSpaceFormattingStrategy> myStrategies;
    private boolean myReplaceDefaultStrategy;

    public CompositeWhiteSpaceFormattingStrategy(@NotNull Collection<WhiteSpaceFormattingStrategy> strategies) throws IllegalArgumentException {
        if (strategies == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "<init>"));
        }
        this.myStrategies = new ArrayList<WhiteSpaceFormattingStrategy>();
        for (WhiteSpaceFormattingStrategy strategy : strategies) {
            this.addStrategy(strategy);
        }
    }

    @Override
    public int check(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "check"));
        }
        int offset = start;
        while (offset < end) {
            WhiteSpaceFormattingStrategy strategy;
            int oldOffset = offset;
            Iterator<WhiteSpaceFormattingStrategy> i$ = this.myStrategies.iterator();
            while (i$.hasNext() && (offset = (strategy = i$.next()).check(text, offset, end)) <= oldOffset) {
            }
            if (offset != oldOffset) continue;
            return start;
        }
        return offset;
    }

    @Override
    public boolean replaceDefaultStrategy() {
        return this.myReplaceDefaultStrategy;
    }

    public void addStrategy(@NotNull WhiteSpaceFormattingStrategy strategy) throws IllegalArgumentException {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "addStrategy"));
        }
        if (this.myReplaceDefaultStrategy && strategy.replaceDefaultStrategy()) {
            throw new IllegalArgumentException(String.format("Can't combine strategy '%s' with already registered strategies (%s). Reason: given strategy is marked to replace all existing strategies but strategy with such characteristics is already registered", strategy, this.myStrategies));
        }
        this.myStrategies.add(strategy);
        this.myReplaceDefaultStrategy |= strategy.replaceDefaultStrategy();
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        CharSequence result = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result = strategy.adjustWhiteSpaceIfNecessary(result, text, startOffset, endOffset, codeStyleSettings, nodeAfter);
        }
        CharSequence charSequence = result;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        return charSequence;
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        if (whiteSpaceText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "adjustWhiteSpaceIfNecessary"));
        }
        CharSequence result = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result = strategy.adjustWhiteSpaceIfNecessary(result, startElement, startOffset, endOffset, codeStyleSettings);
        }
        return result;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "containsWhitespacesOnly"));
        }
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            if (!strategy.containsWhitespacesOnly(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (treePrev == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "addWhitespace"));
        }
        if (whiteSpaceElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy", "addWhitespace"));
        }
        return false;
    }
}

