/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMembersGetter
extends MembersGetter {
    private final PsiType myExpectedType;

    public JavaMembersGetter(@NotNull PsiType expectedType, CompletionParameters parameters) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/filters/getters/JavaMembersGetter", "<init>"));
        }
        super(new JavaStaticMemberProcessor(parameters), parameters.getPosition());
        this.myExpectedType = JavaCompletionUtil.originalize(expectedType);
    }

    public void addMembers(boolean searchInheritors, Consumer<LookupElement> results) {
        if (this.myExpectedType instanceof PsiPrimitiveType && PsiType.DOUBLE.isAssignableFrom(this.myExpectedType)) {
            this.addConstantsFromTargetClass(results, searchInheritors);
            this.addConstantsFromReferencedClassesInSwitch(results);
        }
        if (this.myPlace.getParent().getParent() instanceof PsiSwitchLabelStatement) {
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)this.myExpectedType);
        this.processMembers(results, psiClass, PsiTreeUtil.getParentOfType((PsiElement)this.myPlace, PsiAnnotation.class) == null, searchInheritors);
    }

    private void addConstantsFromReferencedClassesInSwitch(final Consumer<LookupElement> results) {
        final Set<PsiField> fields = ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(this.myPlace);
        HashSet classes = new HashSet();
        for (PsiField field : fields) {
            ContainerUtil.addIfNotNull(classes, (Object)field.getContainingClass());
        }
        for (PsiClass aClass : classes) {
            this.processMembers(new Consumer<LookupElement>(){

                public void consume(LookupElement element) {
                    if (!fields.contains(element.getObject())) {
                        results.consume(TailTypeDecorator.withTail(element, TailType.CASE_COLON));
                    }
                }
            }, aClass, true, false);
        }
    }

    private void addConstantsFromTargetClass(Consumer<LookupElement> results, boolean searchInheritors) {
        PsiElement parent = this.myPlace.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement prev = parent;
        parent = parent.getParent();
        while (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            IElementType op = binaryExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ == op || JavaTokenType.NE == op) {
                if (prev == binaryExpression.getROperand()) {
                    this.processMembers(results, JavaMembersGetter.getCalledClass((PsiElement)binaryExpression.getLOperand()), true, searchInheritors);
                }
                return;
            }
            prev = parent;
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            this.processMembers(results, JavaMembersGetter.getCalledClass(parent.getParent()), true, searchInheritors);
        }
    }

    @Nullable
    private static PsiClass getCalledClass(@Nullable PsiElement call) {
        PsiJavaCodeReferenceElement reference;
        if (call instanceof PsiMethodCallExpression) {
            for (JavaResolveResult result : ((PsiMethodCallExpression)call).getMethodExpression().multiResolve(true)) {
                PsiClass aClass;
                PsiElement element = result.getElement();
                if (!(element instanceof PsiMethod) || (aClass = ((PsiMethod)element).getContainingClass()) == null || "java.lang.Math".equals(aClass.getQualifiedName())) continue;
                return aClass;
            }
        }
        if (call instanceof PsiNewExpression && (reference = ((PsiNewExpression)call).getClassReference()) != null) {
            for (JavaResolveResult result : reference.multiResolve(true)) {
                PsiElement element = result.getElement();
                if (!(element instanceof PsiClass)) continue;
                return (PsiClass)element;
            }
        }
        return null;
    }

    @Override
    @Nullable
    protected LookupElement createFieldElement(PsiField field) {
        if (!this.myExpectedType.isAssignableFrom(field.getType())) {
            return null;
        }
        return new VariableLookupItem(field, false);
    }

    @Override
    @Nullable
    protected LookupElement createMethodElement(PsiMethod method) {
        PsiSubstitutor substitutor = SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, this.myExpectedType);
        PsiType type = substitutor.substitute(method.getReturnType());
        if (type == null || !this.myExpectedType.isAssignableFrom(type)) {
            return null;
        }
        JavaMethodCallElement item = new JavaMethodCallElement(method, false, false);
        item.setInferenceSubstitutor(substitutor, this.myPlace);
        return item;
    }
}

