/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.InitializableFilter;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;

public class XmlTextFilter
implements ElementFilter,
InitializableFilter {
    protected String[] myValue;
    private boolean myCaseInsensitiveFlag = false;

    public XmlTextFilter() {
        this.myValue = ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public XmlTextFilter(@NonNls String value, boolean incensetiveFlag) {
        this.myCaseInsensitiveFlag = incensetiveFlag;
        this.myValue = new String[1];
        this.myValue[0] = value;
    }

    public XmlTextFilter(@NonNls String value) {
        this.myValue = new String[1];
        this.myValue[0] = value;
    }

    public XmlTextFilter(String ... values) {
        this.myValue = values;
    }

    public XmlTextFilter(@NonNls String value1, @NonNls String value2) {
        this.myValue = new String[2];
        this.myValue[0] = value1;
        this.myValue[1] = value2;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return true;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element != null) {
            for (String value : this.myValue) {
                if (value == null) {
                    return true;
                }
                String elementText = this.getTextByElement(element);
                if (!(this.myCaseInsensitiveFlag ? value.equalsIgnoreCase(elementText) : value.equals(elementText))) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String ret = "(";
        for (int i = 0; i < this.myValue.length; ++i) {
            ret = ret + this.myValue[i];
            if (i >= this.myValue.length - 1) continue;
            ret = ret + " | ";
        }
        ret = ret + ")";
        return ret;
    }

    @Override
    public void init(Object[] fromGetter) {
        try {
            this.myValue = new String[fromGetter.length];
            System.arraycopy(fromGetter, 0, this.myValue, 0, fromGetter.length);
        }
        catch (ClassCastException cce) {
            this.myValue = ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }

    protected String getTextByElement(Object element) {
        String elementValue = null;
        if (element instanceof PsiNamedElement) {
            elementValue = element instanceof XmlTag ? ((XmlTag)element).getLocalName() : ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiElement) {
            elementValue = ((PsiElement)element).getText();
        }
        return elementValue;
    }
}

