/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntryDependencyInfo;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementOverriddenMethodsInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementParseInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementPropertyInfo;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementVisitor;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementColorsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.codeStyle.arrangement.std.StdRulePriorityAwareSettings;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRearranger
implements Rearranger<JavaElementArrangementEntry>,
ArrangementStandardSettingsAware,
ArrangementColorsAware {
    @NotNull
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES;
    @NotNull
    private static final Set<ArrangementSettingsToken> SUPPORTED_MODIFIERS;
    @NotNull
    private static final List<ArrangementSettingsToken> SUPPORTED_ORDERS;
    @NotNull
    private static final ArrangementSettingsToken NO_TYPE;
    @NotNull
    private static final Map<ArrangementSettingsToken, Set<ArrangementSettingsToken>> MODIFIERS_BY_TYPE;
    @NotNull
    private static final Collection<Set<ArrangementSettingsToken>> MUTEXES;
    private static final Map<ArrangementSettingsToken, List<ArrangementSettingsToken>> GROUPING_RULES;
    private static final StdArrangementSettings DEFAULT_SETTINGS;
    private static final DefaultArrangementSettingsSerializer SETTINGS_SERIALIZER;

    @NotNull
    private static Set<ArrangementSettingsToken> concat(@NotNull Set<ArrangementSettingsToken> base, ArrangementSettingsToken ... modifiers) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "concat"));
        }
        HashSet result = ContainerUtilRt.newHashSet(base);
        Collections.addAll(result, modifiers);
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "concat"));
        }
        return hashSet;
    }

    private static void setupGettersAndSetters(@NotNull JavaArrangementParseInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "setupGettersAndSetters"));
        }
        Collection<JavaArrangementPropertyInfo> properties = info.getProperties();
        for (JavaArrangementPropertyInfo propertyInfo : properties) {
            JavaElementArrangementEntry getter = propertyInfo.getGetter();
            JavaElementArrangementEntry setter = propertyInfo.getSetter();
            if (getter == null || setter == null || setter.getDependencies() != null) continue;
            setter.addDependency((ArrangementEntry)getter);
        }
    }

    private static void setupUtilityMethods(@NotNull JavaArrangementParseInfo info, @NotNull ArrangementSettingsToken orderType) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "setupUtilityMethods"));
        }
        if (orderType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "setupUtilityMethods"));
        }
        if (StdArrangementTokens.Order.DEPTH_FIRST.equals((Object)orderType)) {
            for (ArrangementEntryDependencyInfo rootInfo : info.getMethodDependencyRoots()) {
                JavaRearranger.setupDepthFirstDependency(rootInfo);
            }
        } else if (StdArrangementTokens.Order.BREADTH_FIRST.equals((Object)orderType)) {
            for (ArrangementEntryDependencyInfo rootInfo : info.getMethodDependencyRoots()) {
                JavaRearranger.setupBreadthFirstDependency(rootInfo);
            }
        } else assert (false) : orderType;
    }

    private static void setupDepthFirstDependency(@NotNull ArrangementEntryDependencyInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "setupDepthFirstDependency"));
        }
        for (ArrangementEntryDependencyInfo dependencyInfo : info.getDependentEntriesInfos()) {
            JavaRearranger.setupDepthFirstDependency(dependencyInfo);
            JavaElementArrangementEntry dependentEntry = dependencyInfo.getAnchorEntry();
            if (dependentEntry.getDependencies() != null) continue;
            dependentEntry.addDependency((ArrangementEntry)info.getAnchorEntry());
        }
    }

    private static void setupBreadthFirstDependency(@NotNull ArrangementEntryDependencyInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "setupBreadthFirstDependency"));
        }
        ArrayDeque<ArrangementEntryDependencyInfo> toProcess = new ArrayDeque<ArrangementEntryDependencyInfo>();
        toProcess.add(info);
        JavaElementArrangementEntry prev = info.getAnchorEntry();
        while (!toProcess.isEmpty()) {
            ArrangementEntryDependencyInfo current = (ArrangementEntryDependencyInfo)toProcess.removeFirst();
            for (ArrangementEntryDependencyInfo dependencyInfo : current.getDependentEntriesInfos()) {
                JavaElementArrangementEntry dependencyMethod = dependencyInfo.getAnchorEntry();
                if (dependencyMethod.getDependencies() == null) {
                    dependencyMethod.addDependency((ArrangementEntry)prev);
                    prev = dependencyMethod;
                }
                toProcess.addLast(dependencyInfo);
            }
        }
    }

    private static void setupOverriddenMethods(JavaArrangementParseInfo info) {
        for (JavaArrangementOverriddenMethodsInfo methodsInfo : info.getOverriddenMethods()) {
            JavaElementArrangementEntry previous = null;
            for (JavaElementArrangementEntry entry : methodsInfo.getMethodEntries()) {
                if (previous != null && entry.getDependencies() == null) {
                    entry.addDependency((ArrangementEntry)previous);
                }
                previous = entry;
            }
        }
    }

    @Nullable
    public Pair<JavaElementArrangementEntry, List<JavaElementArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull PsiElement element, @Nullable ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "parseWithNew"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "parseWithNew"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "parseWithNew"));
        }
        Set<ArrangementSettingsToken> groupingRules = JavaRearranger.getGroupingRules(settings);
        JavaArrangementParseInfo existingEntriesInfo = new JavaArrangementParseInfo();
        root.accept((PsiElementVisitor)new JavaArrangementVisitor(existingEntriesInfo, document, ranges, groupingRules));
        JavaArrangementParseInfo newEntryInfo = new JavaArrangementParseInfo();
        element.accept((PsiElementVisitor)new JavaArrangementVisitor(newEntryInfo, document, Collections.singleton(element.getTextRange()), groupingRules));
        if (newEntryInfo.getEntries().size() != 1) {
            return null;
        }
        return Pair.create((Object)((Object)newEntryInfo.getEntries().get(0)), existingEntriesInfo.getEntries());
    }

    @NotNull
    public List<JavaElementArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @Nullable ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "parse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "parse"));
        }
        JavaArrangementParseInfo parseInfo = new JavaArrangementParseInfo();
        root.accept((PsiElementVisitor)new JavaArrangementVisitor(parseInfo, document, ranges, JavaRearranger.getGroupingRules(settings)));
        if (settings != null) {
            for (ArrangementGroupingRule rule : settings.getGroupings()) {
                if (StdArrangementTokens.Grouping.GETTERS_AND_SETTERS.equals((Object)rule.getGroupingType())) {
                    JavaRearranger.setupGettersAndSetters(parseInfo);
                    continue;
                }
                if (StdArrangementTokens.Grouping.DEPENDENT_METHODS.equals((Object)rule.getGroupingType())) {
                    JavaRearranger.setupUtilityMethods(parseInfo, rule.getOrderType());
                    continue;
                }
                if (!StdArrangementTokens.Grouping.OVERRIDDEN_METHODS.equals((Object)rule.getGroupingType())) continue;
                JavaRearranger.setupOverriddenMethods(parseInfo);
            }
        }
        this.setupFieldInitializationDependencies(parseInfo.getFieldDependencyRoots());
        List<JavaElementArrangementEntry> list = parseInfo.getEntries();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "parse"));
        }
        return list;
    }

    public void setupFieldInitializationDependencies(@NotNull List<ArrangementEntryDependencyInfo> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "setupFieldInitializationDependencies"));
        }
        for (ArrangementEntryDependencyInfo info : list) {
            JavaElementArrangementEntry anchorField = info.getAnchorEntry();
            for (ArrangementEntryDependencyInfo fieldUsedInInitialization : info.getDependentEntriesInfos()) {
                anchorField.addDependency((ArrangementEntry)fieldUsedInInitialization.getAnchorEntry());
            }
        }
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable JavaElementArrangementEntry parent, @Nullable JavaElementArrangementEntry previous, @NotNull JavaElementArrangementEntry target) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getBlankLines"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getBlankLines"));
        }
        if (previous == null) {
            return -1;
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        if (StdArrangementTokens.EntryType.FIELD.equals((Object)target.getType())) {
            if (parent != null && parent.getType() == StdArrangementTokens.EntryType.INTERFACE) {
                return commonSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE;
            }
            return commonSettings.BLANK_LINES_AROUND_FIELD;
        }
        if (StdArrangementTokens.EntryType.METHOD.equals((Object)target.getType())) {
            if (parent != null && parent.getType() == StdArrangementTokens.EntryType.INTERFACE) {
                return commonSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE;
            }
            return commonSettings.BLANK_LINES_AROUND_METHOD;
        }
        if (StdArrangementTokens.EntryType.CLASS.equals((Object)target.getType())) {
            return commonSettings.BLANK_LINES_AROUND_CLASS;
        }
        return -1;
    }

    @NotNull
    private static Set<ArrangementSettingsToken> getGroupingRules(@Nullable ArrangementSettings settings) {
        HashSet groupingRules = ContainerUtilRt.newHashSet();
        if (settings != null) {
            for (ArrangementGroupingRule rule : settings.getGroupings()) {
                groupingRules.add(rule.getGroupingType());
            }
        }
        HashSet hashSet = groupingRules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getGroupingRules"));
        }
        return hashSet;
    }

    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = SETTINGS_SERIALIZER;
        if (defaultArrangementSettingsSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getSerializer"));
        }
        return defaultArrangementSettingsSerializer;
    }

    @NotNull
    public StdArrangementSettings getDefaultSettings() {
        StdArrangementSettings stdArrangementSettings = DEFAULT_SETTINGS;
        if (stdArrangementSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getDefaultSettings"));
        }
        return stdArrangementSettings;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return ContainerUtilRt.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS), new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.OVERRIDDEN_METHODS, new ArrangementSettingsToken[]{StdArrangementTokens.Order.BY_NAME, StdArrangementTokens.Order.KEEP}), new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.DEPENDENT_METHODS, new ArrangementSettingsToken[]{StdArrangementTokens.Order.BREADTH_FIRST, StdArrangementTokens.Order.DEPTH_FIRST})});
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return ContainerUtilRt.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, SUPPORTED_TYPES), new CompositeArrangementSettingsToken(StdArrangementTokens.General.MODIFIER, SUPPORTED_MODIFIERS), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})});
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        Set<ArrangementSettingsToken> modifiers;
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "isEnabled"));
        }
        if (SUPPORTED_TYPES.contains(token) || SUPPORTED_ORDERS.contains(token) || StdArrangementTokens.Regexp.NAME.equals((Object)token)) {
            return true;
        }
        ArrangementSettingsToken type = null;
        if (current != null) {
            type = ArrangementUtil.parseType((ArrangementMatchCondition)current);
        }
        if (type == null) {
            type = NO_TYPE;
        }
        return (modifiers = MODIFIERS_BY_TYPE.get(type)) != null && modifiers.contains(token);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "buildMatcher"));
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition);
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        Collection<Set<ArrangementSettingsToken>> collection = MUTEXES;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getMutexes"));
        }
        return collection;
    }

    private static void and(@NotNull List<StdArrangementMatchRule> matchRules, ArrangementSettingsToken ... conditions) {
        if (matchRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "and"));
        }
        if (conditions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "and"));
        }
        if (conditions.length == 1) {
            matchRules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition(conditions[0], (Object)conditions[0]))));
            return;
        }
        ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        for (ArrangementSettingsToken condition : conditions) {
            composite.addOperand((ArrangementMatchCondition)new ArrangementAtomMatchCondition(condition, (Object)condition));
        }
        matchRules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)composite)));
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme, @NotNull ArrangementSettingsToken token, boolean selected) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getTextAttributes"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getTextAttributes"));
        }
        if (selected) {
            TextAttributes attributes = new TextAttributes();
            attributes.setForegroundColor(scheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
            attributes.setBackgroundColor(scheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            return attributes;
        }
        if (SUPPORTED_TYPES.contains(token)) {
            return JavaRearranger.getAttributes(scheme, JavaHighlightingColors.KEYWORD);
        }
        if (SUPPORTED_MODIFIERS.contains(token)) {
            JavaRearranger.getAttributes(scheme, JavaHighlightingColors.KEYWORD);
        }
        return null;
    }

    @Nullable
    private static TextAttributes getAttributes(@NotNull EditorColorsScheme scheme, TextAttributesKey ... keys) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getAttributes"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getAttributes"));
        }
        TextAttributes result = null;
        for (TextAttributesKey key : keys) {
            Color currentBackgroundColor;
            Color currentForegroundColor;
            TextAttributes attributes = scheme.getAttributes(key);
            if (attributes == null) continue;
            if (result == null) {
                result = attributes;
            }
            if ((currentForegroundColor = result.getForegroundColor()) == null) {
                result.setForegroundColor(attributes.getForegroundColor());
            }
            if ((currentBackgroundColor = result.getBackgroundColor()) == null) {
                result.setBackgroundColor(attributes.getBackgroundColor());
            }
            if (result.getForegroundColor() == null || result.getBackgroundColor() == null) continue;
            return result;
        }
        if (result != null && result.getForegroundColor() == null) {
            return null;
        }
        if (result != null && result.getBackgroundColor() == null) {
            result.setBackgroundColor(scheme.getDefaultBackground());
        }
        return result;
    }

    @Nullable
    public Color getBorderColor(@NotNull EditorColorsScheme scheme, boolean selected) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaRearranger", "getBorderColor"));
        }
        return null;
    }

    static {
        ArrangementSettingsToken[] visibility;
        SUPPORTED_TYPES = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.EntryType.CONSTRUCTOR, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.EntryType.CLASS, StdArrangementTokens.EntryType.INTERFACE, StdArrangementTokens.EntryType.ENUM});
        SUPPORTED_MODIFIERS = ContainerUtilRt.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL, StdArrangementTokens.Modifier.ABSTRACT, StdArrangementTokens.Modifier.SYNCHRONIZED, StdArrangementTokens.Modifier.TRANSIENT, StdArrangementTokens.Modifier.VOLATILE});
        SUPPORTED_ORDERS = ContainerUtilRt.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME});
        NO_TYPE = new ArrangementSettingsToken("NO_TYPE", "NO_TYPE");
        MODIFIERS_BY_TYPE = ContainerUtilRt.newHashMap();
        MUTEXES = ContainerUtilRt.newArrayList();
        HashSet visibilityModifiers = ContainerUtilRt.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE});
        MUTEXES.add(visibilityModifiers);
        MUTEXES.add(SUPPORTED_TYPES);
        Set<ArrangementSettingsToken> commonModifiers = JavaRearranger.concat(visibilityModifiers, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL);
        MODIFIERS_BY_TYPE.put(NO_TYPE, commonModifiers);
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.ENUM, visibilityModifiers);
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.INTERFACE, visibilityModifiers);
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.CLASS, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.ABSTRACT));
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.METHOD, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.SYNCHRONIZED, StdArrangementTokens.Modifier.ABSTRACT));
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.CONSTRUCTOR, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.SYNCHRONIZED));
        MODIFIERS_BY_TYPE.put(StdArrangementTokens.EntryType.FIELD, JavaRearranger.concat(commonModifiers, StdArrangementTokens.Modifier.TRANSIENT, StdArrangementTokens.Modifier.VOLATILE));
        GROUPING_RULES = ContainerUtilRt.newLinkedHashMap();
        GROUPING_RULES.put(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS, Collections.emptyList());
        GROUPING_RULES.put(StdArrangementTokens.Grouping.OVERRIDDEN_METHODS, ContainerUtilRt.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.BY_NAME, StdArrangementTokens.Order.KEEP}));
        GROUPING_RULES.put(StdArrangementTokens.Grouping.DEPENDENT_METHODS, ContainerUtilRt.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.BREADTH_FIRST, StdArrangementTokens.Order.DEPTH_FIRST}));
        ArrayList groupingRules = ContainerUtilRt.newArrayList((Object[])new ArrangementGroupingRule[]{new ArrangementGroupingRule(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS)});
        ArrayList matchRules = ContainerUtilRt.newArrayList();
        for (ArrangementSettingsToken modifier : visibility = new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC, StdArrangementTokens.Modifier.PROTECTED, StdArrangementTokens.Modifier.PACKAGE_PRIVATE, StdArrangementTokens.Modifier.PRIVATE}) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.Modifier.STATIC, StdArrangementTokens.Modifier.FINAL, modifier);
        }
        for (ArrangementSettingsToken modifier : visibility) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.Modifier.STATIC, modifier);
        }
        for (ArrangementSettingsToken modifier : visibility) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.Modifier.FINAL, modifier);
        }
        for (ArrangementSettingsToken modifier : visibility) {
            JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD, modifier);
        }
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.FIELD);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.CONSTRUCTOR);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.Modifier.STATIC);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.METHOD);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.ENUM);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.INTERFACE);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.CLASS, StdArrangementTokens.Modifier.STATIC);
        JavaRearranger.and(matchRules, StdArrangementTokens.EntryType.CLASS);
        DEFAULT_SETTINGS = new StdRulePriorityAwareSettings((List)groupingRules, (List)matchRules);
        SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(DEFAULT_SETTINGS);
    }
}

