/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementParseInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaArrangementVisitor
extends JavaElementVisitor {
    private static final String NULL_CONTENT = "no content";
    private static final Map<String, ArrangementSettingsToken> MODIFIERS = ContainerUtilRt.newHashMap();
    @NotNull
    private final Stack<JavaElementArrangementEntry> myStack;
    @NotNull
    private final Map<PsiElement, JavaElementArrangementEntry> myEntries;
    @NotNull
    private final JavaArrangementParseInfo myInfo;
    @NotNull
    private final Collection<TextRange> myRanges;
    @NotNull
    private final Set<ArrangementSettingsToken> myGroupingRules;
    @NotNull
    private final MethodBodyProcessor myMethodBodyProcessor;
    @Nullable
    private final Document myDocument;
    @Nullable
    private Set<PsiField> classFields;

    public JavaArrangementVisitor(@NotNull JavaArrangementParseInfo infoHolder, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull Set<ArrangementSettingsToken> groupingRules) {
        if (infoHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "<init>"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "<init>"));
        }
        if (groupingRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "<init>"));
        }
        this.myStack = new Stack();
        this.myEntries = new HashMap<PsiElement, JavaElementArrangementEntry>();
        this.myInfo = infoHolder;
        this.myDocument = document;
        this.myRanges = ranges;
        this.myGroupingRules = groupingRules;
        this.myMethodBodyProcessor = new MethodBodyProcessor(infoHolder);
    }

    public void visitClass(PsiClass aClass) {
        ArrangementSettingsToken type = StdArrangementTokens.EntryType.CLASS;
        if (aClass.isEnum()) {
            type = StdArrangementTokens.EntryType.ENUM;
        } else if (aClass.isInterface()) {
            type = StdArrangementTokens.EntryType.INTERFACE;
        }
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)aClass, aClass.getTextRange(), type, aClass.getName(), true);
        this.processEntry(entry, (PsiModifierListOwner)aClass, (PsiElement)aClass);
    }

    public void visitAnonymousClass(PsiAnonymousClass aClass) {
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)aClass, aClass.getTextRange(), StdArrangementTokens.EntryType.ANONYMOUS_CLASS, aClass.getName(), false);
        this.processEntry(entry, null, (PsiElement)aClass);
    }

    public void visitJavaFile(PsiJavaFile file) {
        for (PsiClass psiClass : file.getClasses()) {
            this.visitClass(psiClass);
        }
    }

    public void visitField(PsiField field) {
        JavaElementArrangementEntry entry;
        PsiElement fieldPrev = JavaArrangementVisitor.getPreviousNonWsComment(field.getPrevSibling(), 0);
        if (fieldPrev instanceof PsiJavaToken && ((PsiJavaToken)fieldPrev).getTokenType() == JavaTokenType.COMMA) {
            return;
        }
        TextRange range = field.getTextRange();
        PsiElement child = field.getLastChild();
        boolean needSpecialProcessing = true;
        if (JavaArrangementVisitor.isSemicolon(child)) {
            needSpecialProcessing = false;
        } else if (child instanceof PsiComment) {
            PsiElement prev = JavaArrangementVisitor.getPreviousNonWsComment(child, range.getStartOffset());
            boolean bl = needSpecialProcessing = prev != null && !JavaArrangementVisitor.isSemicolon(prev);
        }
        if (needSpecialProcessing) {
            for (PsiElement e = field.getNextSibling(); e != null; e = e.getNextSibling()) {
                if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
                if (e instanceof PsiJavaToken) {
                    if (((PsiJavaToken)e).getTokenType() != JavaTokenType.COMMA) break;
                    continue;
                }
                if (!(e instanceof PsiField)) break;
                PsiElement c = e.getLastChild();
                if (c != null) {
                    c = JavaArrangementVisitor.getPreviousNonWsComment(c, range.getStartOffset());
                }
                if (!(c instanceof PsiErrorElement) && (!(c instanceof PsiJavaToken) || ((PsiJavaToken)c).getTokenType() != JavaTokenType.SEMICOLON)) continue;
                range = TextRange.create((int)range.getStartOffset(), (int)this.expandToCommentIfPossible(c));
                break;
            }
        }
        if ((entry = this.createNewEntry((PsiElement)field, range, StdArrangementTokens.EntryType.FIELD, field.getName(), true)) == null) {
            return;
        }
        this.processEntry(entry, (PsiModifierListOwner)field, (PsiElement)field.getInitializer());
        this.myInfo.onFieldEntryCreated(field, entry);
        List<PsiField> referencedFields = this.getReferencedFields(field);
        for (PsiField referencedField : referencedFields) {
            this.myInfo.registerFieldInitializationDependency(field, referencedField);
        }
    }

    @NotNull
    private List<PsiField> getReferencedFields(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "getReferencedFields"));
        }
        final ArrayList<PsiField> referencedElements = new ArrayList<PsiField>();
        PsiExpression fieldInitializer = field.getInitializer();
        PsiClass containingClass = field.getContainingClass();
        if (fieldInitializer == null || containingClass == null) {
            ArrayList<PsiField> arrayList = referencedElements;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "getReferencedFields"));
            }
            return arrayList;
        }
        if (this.classFields == null) {
            this.classFields = ContainerUtil.map2Set((Object[])containingClass.getFields(), (Function)new Function.Self());
        }
        fieldInitializer.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement ref = expression.resolve();
                if (ref instanceof PsiField && JavaArrangementVisitor.this.classFields.contains(ref)) {
                    referencedElements.add((PsiField)ref);
                }
            }
        });
        ArrayList<PsiField> arrayList = referencedElements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "getReferencedFields"));
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement getPreviousNonWsComment(@Nullable PsiElement element, int minOffset) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element; e != null && e.getTextRange().getStartOffset() >= minOffset; e = e.getPrevSibling()) {
            if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
            return e;
        }
        return null;
    }

    private int expandToCommentIfPossible(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "expandToCommentIfPossible"));
        }
        if (this.myDocument == null) {
            return element.getTextRange().getEndOffset();
        }
        CharSequence text = this.myDocument.getCharsSequence();
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiWhiteSpace) {
                if (!JavaArrangementVisitor.hasLineBreak(text, e.getTextRange())) continue;
                return element.getTextRange().getEndOffset();
            }
            if (e instanceof PsiComment) {
                if (JavaArrangementVisitor.hasLineBreak(text, e.getTextRange())) continue;
                return e.getTextRange().getEndOffset();
            }
            return element.getTextRange().getEndOffset();
        }
        return element.getTextRange().getEndOffset();
    }

    private static boolean hasLineBreak(@NotNull CharSequence text, @NotNull TextRange range) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "hasLineBreak"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "hasLineBreak"));
        }
        int end = range.getEndOffset();
        for (int i = range.getStartOffset(); i < end; ++i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    private static boolean isSemicolon(@Nullable PsiElement e) {
        return e instanceof PsiJavaToken && ((PsiJavaToken)e).getTokenType() == JavaTokenType.SEMICOLON;
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)initializer, initializer.getTextRange(), StdArrangementTokens.EntryType.FIELD, null, true);
        if (entry == null) {
            return;
        }
        PsiElement classLBrace = null;
        PsiClass clazz = initializer.getContainingClass();
        if (clazz != null) {
            classLBrace = clazz.getLBrace();
        }
        for (PsiElement e = initializer.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            JavaElementArrangementEntry prevEntry = e == classLBrace ? this.myEntries.get(clazz) : this.myEntries.get(e);
            if (prevEntry != null) {
                entry.addDependency((ArrangementEntry)prevEntry);
            }
            if (!(e instanceof PsiWhiteSpace)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(PsiMethod method) {
        ArrangementSettingsToken type = method.isConstructor() ? StdArrangementTokens.EntryType.CONSTRUCTOR : StdArrangementTokens.EntryType.METHOD;
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)method, method.getTextRange(), type, method.getName(), true);
        if (entry == null) {
            return;
        }
        this.processEntry(entry, (PsiModifierListOwner)method, (PsiElement)method.getBody());
        this.parseProperties(method, entry);
        this.myInfo.onMethodEntryCreated(method, entry);
        MethodSignatureBackedByPsiMethod overridden = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
        if (overridden != null) {
            this.myInfo.onOverriddenMethod(overridden.getMethod(), method);
        }
        boolean reset = this.myMethodBodyProcessor.setBaseMethod(method);
        try {
            method.accept((PsiElementVisitor)this.myMethodBodyProcessor);
        }
        finally {
            if (reset) {
                this.myMethodBodyProcessor.setBaseMethod(null);
            }
        }
    }

    private void parseProperties(PsiMethod method, JavaElementArrangementEntry entry) {
        if (!this.myGroupingRules.contains(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS)) {
            return;
        }
        String propertyName = null;
        boolean getter = true;
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
            propertyName = PropertyUtil.getPropertyNameByGetter((PsiMethod)method);
        } else if (PropertyUtil.isSimplePropertySetter((PsiMethod)method)) {
            propertyName = PropertyUtil.getPropertyNameBySetter((PsiMethod)method);
            getter = false;
        }
        if (propertyName == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        String className = null;
        if (containingClass != null) {
            className = containingClass.getQualifiedName();
        }
        if (className == null) {
            className = NULL_CONTENT;
        }
        if (getter) {
            this.myInfo.registerGetter(propertyName, className, entry);
        } else {
            this.myInfo.registerSetter(propertyName, className, entry);
        }
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        statement.getExpression().acceptChildren((PsiElementVisitor)this);
    }

    public void visitNewExpression(PsiNewExpression expression) {
        PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
        if (anonymousClass == null) {
            return;
        }
        JavaElementArrangementEntry entry = this.createNewEntry((PsiElement)anonymousClass, anonymousClass.getTextRange(), StdArrangementTokens.EntryType.CLASS, anonymousClass.getName(), false);
        this.processEntry(entry, null, (PsiElement)anonymousClass);
    }

    public void visitExpressionList(PsiExpressionList list) {
        for (PsiExpression expression : list.getExpressions()) {
            expression.acceptChildren((PsiElementVisitor)this);
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        for (PsiElement element : statement.getDeclaredElements()) {
            element.acceptChildren((PsiElementVisitor)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntry(@Nullable JavaElementArrangementEntry entry, @Nullable PsiModifierListOwner modifier, @Nullable PsiElement nextPsiRoot) {
        if (entry == null) {
            return;
        }
        if (modifier != null) {
            JavaArrangementVisitor.parseModifiers(modifier.getModifierList(), entry);
        }
        if (nextPsiRoot == null) {
            return;
        }
        this.myStack.push((Object)entry);
        try {
            nextPsiRoot.acceptChildren((PsiElementVisitor)this);
        }
        finally {
            this.myStack.pop();
        }
    }

    @Nullable
    private JavaElementArrangementEntry createNewEntry(@NotNull PsiElement element, @NotNull TextRange range, @NotNull ArrangementSettingsToken type, @Nullable String name, boolean canArrange) {
        JavaElementArrangementEntry entry;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "createNewEntry"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "createNewEntry"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "createNewEntry"));
        }
        if (!this.isWithinBounds(range)) {
            return null;
        }
        DefaultArrangementEntry current = this.getCurrent();
        if (canArrange) {
            TextRange expandedRange = this.myDocument == null ? null : ArrangementUtil.expandToLineIfPossible((TextRange)range, (Document)this.myDocument);
            TextRange rangeToUse = expandedRange == null ? range : expandedRange;
            entry = new JavaElementArrangementEntry((ArrangementEntry)current, rangeToUse, type, name, true);
        } else {
            entry = new JavaElementArrangementEntry((ArrangementEntry)current, range, type, name, false);
        }
        this.myEntries.put(element, entry);
        if (current == null) {
            this.myInfo.addEntry(entry);
        } else {
            current.addChild((ArrangementEntry)entry);
        }
        return entry;
    }

    private boolean isWithinBounds(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "isWithinBounds"));
        }
        for (TextRange textRange : this.myRanges) {
            if (!textRange.intersects(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private DefaultArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (JavaElementArrangementEntry)((Object)this.myStack.peek());
    }

    private static void parseModifiers(@Nullable PsiModifierList modifierList, @NotNull JavaElementArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor", "parseModifiers"));
        }
        if (modifierList == null) {
            return;
        }
        for (String modifier : PsiModifier.MODIFIERS) {
            ArrangementSettingsToken arrangementModifier;
            if (!modifierList.hasModifierProperty(modifier) || (arrangementModifier = MODIFIERS.get(modifier)) == null) continue;
            entry.addModifier(arrangementModifier);
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            entry.addModifier(StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
        }
    }

    static {
        MODIFIERS.put("public", StdArrangementTokens.Modifier.PUBLIC);
        MODIFIERS.put("protected", StdArrangementTokens.Modifier.PROTECTED);
        MODIFIERS.put("private", StdArrangementTokens.Modifier.PRIVATE);
        MODIFIERS.put("packageLocal", StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
        MODIFIERS.put("static", StdArrangementTokens.Modifier.STATIC);
        MODIFIERS.put("final", StdArrangementTokens.Modifier.FINAL);
        MODIFIERS.put("transient", StdArrangementTokens.Modifier.TRANSIENT);
        MODIFIERS.put("volatile", StdArrangementTokens.Modifier.VOLATILE);
        MODIFIERS.put("synchronized", StdArrangementTokens.Modifier.SYNCHRONIZED);
        MODIFIERS.put("abstract", StdArrangementTokens.Modifier.ABSTRACT);
    }

    private static class MethodBodyProcessor
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final JavaArrangementParseInfo myInfo;
        @Nullable
        private PsiMethod myBaseMethod;

        MethodBodyProcessor(@NotNull JavaArrangementParseInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor$MethodBodyProcessor", "<init>"));
            }
            this.myInfo = info;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression psiMethodCallExpression) {
            PsiReference reference = psiMethodCallExpression.getMethodExpression().getReference();
            if (reference == null) {
                return;
            }
            PsiElement e = reference.resolve();
            if (e instanceof PsiMethod) {
                assert (this.myBaseMethod != null);
                PsiMethod m = (PsiMethod)e;
                if (m.getContainingClass() == this.myBaseMethod.getContainingClass()) {
                    this.myInfo.registerMethodCallDependency(this.myBaseMethod, m);
                }
            }
            super.visitMethodCallExpression(psiMethodCallExpression);
        }

        public boolean setBaseMethod(@Nullable PsiMethod baseMethod) {
            if (baseMethod == null || this.myBaseMethod == null) {
                this.myBaseMethod = baseMethod;
                return true;
            }
            return false;
        }
    }
}

