/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.annotations.NotNull;

public class ClassFileViewProviderFactory
implements FileViewProviderFactory {
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/ClassFileViewProviderFactory", "createFileViewProvider"));
        }
        ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find((VirtualFile)file);
        if (decompiler instanceof ClassFileDecompilers.Full) {
            return ((ClassFileDecompilers.Full)decompiler).createFileViewProvider(file, manager, eventSystemEnabled);
        }
        for (ContentBasedFileSubstitutor processor : (ContentBasedFileSubstitutor[])Extensions.getExtensions((ExtensionPointName)ContentBasedFileSubstitutor.EP_NAME)) {
            Language lang = processor.obtainLanguageForFile(file);
            if (lang == null) continue;
            FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
            return factory.createFileViewProvider(file, language, manager, eventSystemEnabled);
        }
        return new ClassFileViewProvider(manager, file, eventSystemEnabled);
    }
}

