/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.actions;

import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.ui.treeStructure.Tree;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class MoveScopeAction
extends AnAction {
    private final Tree myTree;
    private final int myDir;

    public MoveScopeAction(Tree tree, String text, Icon icon, int dir) {
        super(text, text, icon);
        this.myTree = tree;
        this.myDir = dir;
    }

    protected abstract boolean isEnabledFor(int var1, InspectionConfigTreeNode var2);

    public void update(AnActionEvent e) {
        InspectionConfigTreeNode treeNode;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (this.getSelectedProfile() == null) {
            return;
        }
        InspectionConfigTreeNode[] nodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null);
        if (nodes.length > 0 && (treeNode = nodes[0]).getScope(MoveScopeAction.getEventProject((AnActionEvent)e)) != null && !treeNode.isByDefault()) {
            TreeNode parent = treeNode.getParent();
            int index = parent.getIndex((TreeNode)((Object)treeNode));
            presentation.setEnabled(this.isEnabledFor(index, (InspectionConfigTreeNode)((Object)parent)));
        }
    }

    public void actionPerformed(AnActionEvent e) {
        InspectionConfigTreeNode[] nodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null);
        InspectionConfigTreeNode node = nodes[0];
        Descriptor descriptor = node.getDescriptor();
        TreeNode parent = node.getParent();
        int index = parent.getIndex((TreeNode)((Object)node));
        this.getSelectedProfile().moveScope(descriptor.getKey().toString(), index, this.myDir, e.getProject());
        node.removeFromParent();
        ((InspectionConfigTreeNode)((Object)parent)).insert((MutableTreeNode)((Object)node), index + this.myDir);
        ((DefaultTreeModel)this.myTree.getModel()).reload(parent);
        this.myTree.setSelectionPath(new TreePath(node.getPath()));
        this.myTree.revalidate();
    }

    protected abstract InspectionProfileImpl getSelectedProfile();
}

