/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.actions;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AddScopeAction
extends AnAction {
    private final Tree myTree;
    private static final Logger LOG = Logger.getInstance((String)("#" + AddScopeAction.class.getName()));

    public AddScopeAction(Tree tree) {
        super("Add Scope", "Add Scope", IconUtil.getAddIcon());
        this.myTree = tree;
        this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)this.myTree);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (this.getSelectedProfile() == null) {
            return;
        }
        Project project = AddScopeAction.getProject(e);
        InspectionConfigTreeNode[] selectedNodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null);
        if (selectedNodes == null) {
            return;
        }
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (InspectionConfigTreeNode node : selectedNodes) {
            AddScopeAction.collect(descriptors, new ArrayList<InspectionConfigTreeNode>(), node);
        }
        presentation.setEnabled(!this.getAvailableScopes(project, descriptors).isEmpty());
    }

    private static Project getProject(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return project;
    }

    public void actionPerformed(AnActionEvent e) {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        InspectionConfigTreeNode[] selectedNodes = (InspectionConfigTreeNode[])this.myTree.getSelectedNodes(InspectionConfigTreeNode.class, null);
        LOG.assertTrue(selectedNodes != null);
        ArrayList<InspectionConfigTreeNode> nodes = new ArrayList<InspectionConfigTreeNode>(Arrays.asList(selectedNodes));
        for (InspectionConfigTreeNode node : selectedNodes) {
            AddScopeAction.collect(descriptors, nodes, node);
        }
        Project project = AddScopeAction.getProject(e);
        List<String> availableScopes = this.getAvailableScopes(project, descriptors);
        int idx = Messages.showChooseDialog((Component)this.myTree, (String)"Scope:", (String)"Choose Scope", (String[])ArrayUtil.toStringArray(availableScopes), (String)availableScopes.get(0), (Icon)Messages.getQuestionIcon());
        if (idx == -1) {
            return;
        }
        NamedScope chosenScope = NamedScopesHolder.getScope((Project)project, (String)availableScopes.get(idx));
        for (InspectionConfigTreeNode node : nodes) {
            Descriptor descriptor = node.getDescriptor();
            if (node.getScopeName() != null || descriptor == null) continue;
            InspectionToolWrapper toolWrapper = descriptor.getToolWrapper();
            InspectionProfileImpl selectedProfile = this.getSelectedProfile();
            HighlightDisplayLevel level = selectedProfile.getErrorLevel(descriptor.getKey(), chosenScope, project);
            boolean enabled = selectedProfile.isToolEnabled(descriptor.getKey());
            ScopeToolState scopeToolState = selectedProfile.addScope(toolWrapper, chosenScope, level, enabled, project);
            Descriptor addedDescriptor = new Descriptor(scopeToolState, selectedProfile, project);
            if (node.getChildCount() == 0) {
                node.add((MutableTreeNode)((Object)new InspectionConfigTreeNode(descriptor, selectedProfile.getToolDefaultState(descriptor.getKey().toString(), project), true, true, false)));
            }
            node.insert((MutableTreeNode)((Object)new InspectionConfigTreeNode(addedDescriptor, scopeToolState, false, false)), 0);
            node.setInspectionNode(false);
            node.dropCache();
            ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)((Object)node));
            this.myTree.expandPath(new TreePath(node.getPath()));
        }
        this.myTree.revalidate();
    }

    private static void collect(List<Descriptor> descriptors, List<InspectionConfigTreeNode> nodes, InspectionConfigTreeNode node) {
        Descriptor descriptor = node.getDescriptor();
        if (descriptor != null) {
            if (node.getScopeName() == null) {
                descriptors.add(descriptor);
            }
        } else if (node.getUserObject() instanceof String) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                InspectionConfigTreeNode childNode = (InspectionConfigTreeNode)((Object)node.getChildAt(i));
                nodes.add(childNode);
                AddScopeAction.collect(descriptors, nodes, childNode);
            }
        }
    }

    private List<String> getAvailableScopes(Project project, List<Descriptor> descriptors) {
        ArrayList scopes = new ArrayList();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            Collections.addAll(scopes, holder.getScopes());
        }
        scopes.remove(CustomScopesProviderEx.getAllScope());
        CustomScopesProviderEx.filterNoSettingsScopes((Project)project, scopes);
        HashSet<NamedScope> used = new HashSet<NamedScope>();
        for (Descriptor descriptor : descriptors) {
            List<ScopeToolState> nonDefaultTools = this.getSelectedProfile().getNonDefaultTools(descriptor.getKey().toString(), project);
            if (nonDefaultTools == null) continue;
            for (ScopeToolState state : nonDefaultTools) {
                used.add(state.getScope(project));
            }
        }
        scopes.removeAll(used);
        ArrayList<String> availableScopes = new ArrayList<String>();
        for (NamedScope scope : scopes) {
            availableScopes.add(scope.getName());
        }
        return availableScopes;
    }

    protected abstract InspectionProfileImpl getSelectedProfile();
}

