/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.AppInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProjectInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.VisibleTreeState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.DefaultProjectProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManagerImpl;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.LevelChooser;
import com.intellij.profile.codeInspection.ui.actions.AddScopeAction;
import com.intellij.profile.codeInspection.ui.actions.DeleteScopeAction;
import com.intellij.profile.codeInspection.ui.actions.MoveScopeAction;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.IconUtil;
import com.intellij.util.config.StorageAccessors;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleInspectionProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolsPanel");
    @NonNls
    private static final String INSPECTION_FILTER_HISTORY = "INSPECTION_FILTER_HISTORY";
    private static final String UNDER_CONSTRUCTION = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
    private final Map<Descriptor, List<Descriptor>> myDescriptors;
    private InspectionProfileImpl mySelectedProfile;
    private JEditorPane myBrowser;
    private JPanel myOptionsPanel;
    private JPanel myInspectionProfilePanel;
    private FilterComponent myProfileFilter;
    private final InspectionConfigTreeNode myRoot;
    private final Alarm myAlarm;
    private boolean myModified;
    private Tree myTree;
    private TreeExpander myTreeExpander;
    @NotNull
    private String myInitialProfile;
    @NonNls
    private static final String EMPTY_HTML = "<html><body></body></html>";
    private boolean myIsInRestore;
    @NonNls
    private static final String VERTICAL_DIVIDER_PROPORTION = "VERTICAL_DIVIDER_PROPORTION";
    @NonNls
    private static final String HORIZONTAL_DIVIDER_PROPORTION = "HORIZONTAL_DIVIDER_PROPORTION";
    private final StorageAccessors myProperties;
    private boolean myShareProfile;
    private final InspectionProjectProfileManager myProjectProfileManager;
    private Splitter myRightSplitter;
    private Splitter myMainSplitter;

    public SingleInspectionProfilePanel(@NotNull InspectionProjectProfileManager projectProfileManager, @NotNull String inspectionProfileName, @NotNull ModifiableModel profile) {
        if (projectProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        if (inspectionProfileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "<init>"));
        }
        super(new BorderLayout());
        this.myDescriptors = new HashMap<Descriptor, List<Descriptor>>();
        this.myInspectionProfilePanel = null;
        this.myRoot = new InspectionConfigTreeNode(InspectionsBundle.message((String)"inspection.root.node.title", (Object[])new Object[0]), null, false, false);
        this.myAlarm = new Alarm();
        this.myModified = false;
        this.myIsInRestore = false;
        this.myProperties = StorageAccessors.createGlobal((String)"SingleInspectionProfilePanel");
        this.myProjectProfileManager = projectProfileManager;
        this.mySelectedProfile = (InspectionProfileImpl)profile;
        this.myInitialProfile = inspectionProfileName;
        this.myShareProfile = profile.getProfileManager() == projectProfileManager;
    }

    private static VisibleTreeState getExpandedNodes(InspectionProfileImpl profile) {
        if (profile.getProfileManager() instanceof ApplicationProfileManager) {
            return AppInspectionProfilesVisibleTreeState.getInstance().getVisibleTreeState(profile);
        }
        DefaultProjectProfileManager projectProfileManager = (DefaultProjectProfileManager)profile.getProfileManager();
        return ProjectInspectionProfilesVisibleTreeState.getInstance(projectProfileManager.getProject()).getVisibleTreeState(profile);
    }

    private void initUI() {
        this.myInspectionProfilePanel = this.createInspectionProfileSettingsPanel();
        this.add((Component)this.myInspectionProfilePanel, "Center");
        UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
        userActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SingleInspectionProfilePanel.this.mySelectedProfile == null) {
                            return;
                        }
                        SingleInspectionProfilePanel.this.updateProperSettingsForSelection();
                        SingleInspectionProfilePanel.this.wereToolSettingsModified();
                    }
                });
            }
        });
        userActivityWatcher.register((Component)this.myOptionsPanel);
        this.updateSelectedProfileState();
        this.reset();
    }

    private void updateSelectedProfileState() {
        if (this.mySelectedProfile == null) {
            return;
        }
        this.restoreTreeState();
        this.repaintTableData();
        this.updateSelection();
    }

    public void updateSelection() {
        TreePath selectionPath;
        if (this.myTree != null && (selectionPath = this.myTree.getSelectionPath()) != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)((TreeNode)selectionPath.getLastPathComponent()));
            TreeUtil.showRowCentered((JTree)this.myTree, (int)this.myTree.getRowForPath(selectionPath), (boolean)false);
        }
    }

    private void wereToolSettingsModified() {
        for (Map.Entry<Descriptor, List<Descriptor>> entry : this.myDescriptors.entrySet()) {
            Descriptor desc = entry.getKey();
            if (this.wereToolSettingsModified(desc)) {
                return;
            }
            List<Descriptor> descriptors = entry.getValue();
            for (Descriptor descriptor : descriptors) {
                if (!this.wereToolSettingsModified(descriptor)) continue;
                return;
            }
        }
        this.myModified = false;
    }

    private boolean wereToolSettingsModified(Descriptor descriptor) {
        InspectionToolWrapper toolWrapper = descriptor.getToolWrapper();
        if (!this.mySelectedProfile.isToolEnabled(descriptor.getKey(), descriptor.getScope(), this.myProjectProfileManager.getProject())) {
            return false;
        }
        Element oldConfig = descriptor.getConfig();
        if (oldConfig == null) {
            return false;
        }
        Element newConfig = Descriptor.createConfigElement(toolWrapper);
        if (!JDOMUtil.areElementsEqual((Element)oldConfig, (Element)newConfig)) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    SingleInspectionProfilePanel.this.myTree.repaint();
                }
            }, 300);
            this.myModified = true;
            return true;
        }
        return false;
    }

    private void updateProperSettingsForSelection() {
        InspectionConfigTreeNode node;
        Descriptor descriptor;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && (descriptor = (node = (InspectionConfigTreeNode)((Object)selectionPath.getLastPathComponent())).getDescriptor()) != null) {
            boolean properSetting = this.mySelectedProfile.isProperSetting(descriptor.getKey().toString());
            if (node.isProperSetting() != properSetting) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        SingleInspectionProfilePanel.this.myTree.repaint();
                    }
                }, 300);
                node.dropCache();
                SingleInspectionProfilePanel.updateUpHierarchy(node, (InspectionConfigTreeNode)((Object)node.getParent()));
            }
        }
    }

    private void initDescriptors() {
        InspectionProfileImpl profile = this.mySelectedProfile;
        if (profile == null) {
            return;
        }
        this.myDescriptors.clear();
        List<ScopeToolState> tools = profile.getDefaultStates(this.myProjectProfileManager.getProject());
        for (ScopeToolState state : tools) {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            if (state.getLevel() == HighlightDisplayLevel.NON_SWITCHABLE_ERROR) continue;
            Project project = this.myProjectProfileManager.getProject();
            this.myDescriptors.put(new Descriptor(state, profile, project), descriptors);
            InspectionToolWrapper toolWrapper = state.getTool();
            List<ScopeToolState> nonDefaultTools = profile.getNonDefaultTools(toolWrapper.getShortName(), project);
            for (ScopeToolState nonDefaultToolState : nonDefaultTools) {
                descriptors.add(new Descriptor(nonDefaultToolState, profile, project));
            }
        }
    }

    private void postProcessModification() {
        this.wereToolSettingsModified();
        for (ScopeToolState state : this.mySelectedProfile.getAllTools(this.myProjectProfileManager.getProject())) {
            state.resetConfigPanel();
        }
        this.fillTreeData(this.myProfileFilter.getFilter(), true);
        this.repaintTableData();
        this.updateOptionsAndDescriptionPanel(this.myTree.getSelectionPath());
    }

    @Nullable
    public static ModifiableModel createNewProfile(int initValue, ModifiableModel selectedProfile, JPanel parent, String profileName, Set<String> existingProfileNames, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "createNewProfile"));
        }
        if ((profileName = Messages.showInputDialog((Component)parent, (String)profileName, (String)"Create New Inspection Profile", (Icon)Messages.getQuestionIcon())) == null) {
            return null;
        }
        ProfileManager profileManager = selectedProfile.getProfileManager();
        if (existingProfileNames.contains(profileName)) {
            Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.unable.to.create.profile.message", (Object[])new Object[]{profileName}), (String)InspectionsBundle.message((String)"inspection.unable.to.create.profile.dialog.title", (Object[])new Object[0]));
            return null;
        }
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(profileName, InspectionToolRegistrar.getInstance(), profileManager);
        if (initValue == -1) {
            InspectionToolWrapper[] profileEntries;
            inspectionProfile.initInspectionTools(project);
            ModifiableModel profileModifiableModel = inspectionProfile.getModifiableModel();
            for (InspectionToolWrapper toolWrapper : profileEntries = profileModifiableModel.getInspectionTools(null)) {
                profileModifiableModel.disableTool(toolWrapper.getShortName(), (NamedScope)null, project);
            }
            profileModifiableModel.setLocal(true);
            profileModifiableModel.setModified(true);
            return profileModifiableModel;
        }
        if (initValue == 0) {
            inspectionProfile.copyFrom((Profile)selectedProfile);
            inspectionProfile.setName(profileName);
            inspectionProfile.initInspectionTools(project);
            inspectionProfile.setModified(true);
            return inspectionProfile;
        }
        return null;
    }

    public void setFilter(String filter) {
        this.myProfileFilter.setFilter(filter);
    }

    public void filterTree(String filter) {
        if (this.myTree != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.mySelectedProfile).saveVisibleState(this.myTree);
            this.fillTreeData(filter, true);
            this.reloadModel();
            this.restoreTreeState();
            if (this.myTree.getSelectionPath() == null) {
                TreeUtil.selectFirstNode((JTree)this.myTree);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadModel() {
        try {
            this.myIsInRestore = true;
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTreeState() {
        try {
            this.myIsInRestore = true;
            SingleInspectionProfilePanel.getExpandedNodes(this.mySelectedProfile).restoreVisibleState(this.myTree);
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)this.myTree));
        actions.add(actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)this.myTree));
        actions.add(new AnAction(CommonBundle.message((String)"button.reset.to.default", (Object[])new Object[0]), CommonBundle.message((String)"button.reset.to.default", (Object[])new Object[0]), AllIcons.General.Reset){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 2)), (JComponent)SingleInspectionProfilePanel.this.myTree);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(SingleInspectionProfilePanel.this.myRoot.isProperSetting());
            }

            public void actionPerformed(AnActionEvent e) {
                SingleInspectionProfilePanel.this.mySelectedProfile.resetToBase(SingleInspectionProfilePanel.this.myProjectProfileManager.getProject());
                SingleInspectionProfilePanel.this.postProcessModification();
            }
        });
        actions.add(new AnAction("Reset to Empty", "Reset to empty", AllIcons.Actions.Reset_to_empty){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(SingleInspectionProfilePanel.this.mySelectedProfile != null && SingleInspectionProfilePanel.this.mySelectedProfile.isExecutable(SingleInspectionProfilePanel.this.myProjectProfileManager.getProject()));
            }

            public void actionPerformed(AnActionEvent e) {
                SingleInspectionProfilePanel.this.mySelectedProfile.resetToEmpty(e.getProject());
                SingleInspectionProfilePanel.this.postProcessModification();
            }
        });
        actions.add((AnAction)new ToggleAction("Lock Profile", "Lock profile", AllIcons.Nodes.Padlock){

            public boolean isSelected(AnActionEvent e) {
                return SingleInspectionProfilePanel.this.mySelectedProfile != null && SingleInspectionProfilePanel.this.mySelectedProfile.isProfileLocked();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SingleInspectionProfilePanel.this.mySelectedProfile.lockProfile(state);
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new MyAddScopeAction());
        actions.add((AnAction)new MyDeleteScopeAction());
        actions.add((AnAction)new MoveScopeAction(this.myTree, "Move Scope Up", IconUtil.getMoveUpIcon(), -1){

            @Override
            protected boolean isEnabledFor(int idx, InspectionConfigTreeNode parent) {
                return idx > 0;
            }

            @Override
            protected InspectionProfileImpl getSelectedProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }
        });
        actions.add((AnAction)new MoveScopeAction(this.myTree, "Move Scope Down", IconUtil.getMoveDownIcon(), 1){

            @Override
            protected boolean isEnabledFor(int idx, InspectionConfigTreeNode parent) {
                return idx < parent.getChildCount() - 2;
            }

            @Override
            protected InspectionProfileImpl getSelectedProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }
        });
        actions.addSeparator();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions, true);
        actionToolbar.setTargetComponent((JComponent)this);
        return actionToolbar;
    }

    private void repaintTableData() {
        if (this.myTree != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.mySelectedProfile).saveVisibleState(this.myTree);
            this.reloadModel();
            this.restoreTreeState();
        }
    }

    public void selectInspectionTool(String name) {
        InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, this.myRoot);
        if (node != null) {
            TreeUtil.showRowCentered((JTree)this.myTree, (int)(this.myTree.getRowForPath(new TreePath(node.getPath())) - 1), (boolean)true);
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)((Object)node));
        }
    }

    @Nullable
    private static InspectionConfigTreeNode findNodeByKey(String name, InspectionConfigTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)((Object)root.getChildAt(i));
            Descriptor descriptor = child.getDescriptor();
            if (descriptor != null) {
                if (!descriptor.getKey().toString().equals(name)) continue;
                return child;
            }
            InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, child);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private JScrollPane initTreeScrollPane() {
        this.fillTreeData(null, true);
        InspectionsConfigTreeRenderer renderer = new InspectionsConfigTreeRenderer(this.myProjectProfileManager.getProject()){

            @Override
            protected String getFilter() {
                return SingleInspectionProfilePanel.this.myProfileFilter != null ? SingleInspectionProfilePanel.this.myProfileFilter.getFilter() : null;
            }
        };
        this.myTree = new CheckboxTree(renderer, this.myRoot){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                size = new Dimension(size.width + 10, size.height);
                return size;
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                SingleInspectionProfilePanel.this.toggleToolNode((InspectionConfigTreeNode)node);
            }
        };
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)renderer));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InspectionProfileImpl selected;
                if (SingleInspectionProfilePanel.this.myTree.getSelectionPaths() != null && SingleInspectionProfilePanel.this.myTree.getSelectionPaths().length == 1) {
                    SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(SingleInspectionProfilePanel.this.myTree.getSelectionPaths()[0]);
                } else {
                    SingleInspectionProfilePanel.this.initOptionsAndDescriptionPanel();
                }
                if (!SingleInspectionProfilePanel.this.myIsInRestore && (selected = SingleInspectionProfilePanel.this.mySelectedProfile) != null) {
                    InspectionProfileImpl baseProfile = (InspectionProfileImpl)selected.getParentProfile();
                    if (baseProfile != null) {
                        SingleInspectionProfilePanel.getExpandedNodes(baseProfile).setSelectionPaths(SingleInspectionProfilePanel.this.myTree.getSelectionPaths());
                    }
                    SingleInspectionProfilePanel.getExpandedNodes(selected).setSelectionPaths(SingleInspectionProfilePanel.this.myTree.getSelectionPaths());
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int[] selectionRows = SingleInspectionProfilePanel.this.myTree.getSelectionRows();
                if (selectionRows != null && SingleInspectionProfilePanel.this.myTree.getPathForLocation(x, y) != null && Arrays.binarySearch(selectionRows, SingleInspectionProfilePanel.this.myTree.getRowForLocation(x, y)) > -1) {
                    SingleInspectionProfilePanel.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)o.getLastPathComponent());
                Descriptor descriptor = node.getDescriptor();
                return descriptor != null ? InspectionsConfigTreeComparator.getDisplayTextToSort(descriptor.getText()) : InspectionsConfigTreeComparator.getDisplayTextToSort(node.getGroupName());
            }
        });
        this.myTree.setSelectionModel((TreeSelectionModel)new DefaultTreeSelectionModel());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setHorizontalScrollBarPolicy(30);
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                InspectionProfileImpl selected = SingleInspectionProfilePanel.this.mySelectedProfile;
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)event.getPath().getLastPathComponent());
                InspectionProfileImpl parentProfile = (InspectionProfileImpl)selected.getParentProfile();
                if (parentProfile != null) {
                    SingleInspectionProfilePanel.getExpandedNodes(parentProfile).saveVisibleState(SingleInspectionProfilePanel.this.myTree);
                }
                SingleInspectionProfilePanel.getExpandedNodes(selected).saveVisibleState(SingleInspectionProfilePanel.this.myTree);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                InspectionProfileImpl selected = SingleInspectionProfilePanel.this.mySelectedProfile;
                if (selected != null) {
                    InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)event.getPath().getLastPathComponent());
                    InspectionProfileImpl parentProfile = (InspectionProfileImpl)selected.getParentProfile();
                    if (parentProfile != null) {
                        SingleInspectionProfilePanel.getExpandedNodes(parentProfile).expandNode(node);
                    }
                    SingleInspectionProfilePanel.getExpandedNodes(selected).expandNode(node);
                }
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myProfileFilter = new MyFilterComponent();
        return scrollPane;
    }

    private JPopupMenu compoundPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        SeverityRegistrar severityRegistrar = ((SeverityProvider)this.mySelectedProfile.getProfileManager()).getOwnSeverityRegistrar();
        TreeSet<HighlightSeverity> severities = new TreeSet<HighlightSeverity>(severityRegistrar);
        severities.add(HighlightSeverity.ERROR);
        severities.add(HighlightSeverity.WARNING);
        severities.add(HighlightSeverity.WEAK_WARNING);
        Collection<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar);
        for (SeverityRegistrar.SeverityBasedTextAttributes info : infoTypes) {
            severities.add(info.getSeverity());
        }
        for (HighlightSeverity severity : severities) {
            final HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            group.add(new AnAction(SingleInspectionProfilePanel.renderSeverity(severity), SingleInspectionProfilePanel.renderSeverity(severity), level.getIcon()){

                public void actionPerformed(AnActionEvent e) {
                    SingleInspectionProfilePanel.this.setNewHighlightingLevel(level);
                }
            });
        }
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyAddScopeAction());
        group.add((AnAction)new MyDeleteScopeAction());
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
        return menu.getComponent();
    }

    static String renderSeverity(HighlightSeverity severity) {
        return StringUtil.capitalizeWords((String)severity.getName().toLowerCase(), (boolean)true);
    }

    private void toggleToolNode(InspectionConfigTreeNode toolNode) {
        Descriptor descriptor = toolNode.getDescriptor();
        Project project = this.myProjectProfileManager.getProject();
        if (descriptor != null) {
            HighlightDisplayKey key = descriptor.getKey();
            String toolShortName = key.toString();
            if (toolNode.isChecked()) {
                if (toolNode.getScope(project) != null) {
                    if (toolNode.isByDefault()) {
                        this.mySelectedProfile.enableToolByDefault(toolShortName, project);
                    } else {
                        this.mySelectedProfile.enableTool(toolShortName, toolNode.getScope(project), project);
                    }
                } else {
                    this.mySelectedProfile.enableTool(toolShortName, project);
                }
            } else if (toolNode.getScope(project) != null) {
                if (toolNode.isByDefault()) {
                    this.mySelectedProfile.disableToolByDefault(toolShortName, project);
                } else {
                    this.mySelectedProfile.disableTool(toolShortName, toolNode.getScope(project), project);
                }
            } else if (toolNode.getChildCount() == 0) {
                this.mySelectedProfile.disableTool(toolShortName, project);
            }
            toolNode.dropCache();
            SingleInspectionProfilePanel.updateUpHierarchy(toolNode, (InspectionConfigTreeNode)((Object)toolNode.getParent()));
        }
        TreePath path = new TreePath(toolNode.getPath());
        if (Comparing.equal((Object)this.myTree.getSelectionPath(), (Object)path)) {
            this.updateOptionsAndDescriptionPanel(path);
        }
    }

    private static void updateUpHierarchy(InspectionConfigTreeNode node, InspectionConfigTreeNode parent) {
        if (parent != null) {
            parent.dropCache();
            SingleInspectionProfilePanel.updateUpHierarchy(parent, (InspectionConfigTreeNode)((Object)parent.getParent()));
        }
    }

    private static boolean isDescriptorAccepted(Descriptor descriptor, @NonNls String filter, boolean forceInclude, List<Set<String>> keySetList, Set<String> quoted) {
        String[] groupPath;
        filter = filter.toLowerCase();
        if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)filter)) {
            return true;
        }
        for (String group : groupPath = descriptor.getGroup()) {
            if (!StringUtil.containsIgnoreCase((String)group, (String)filter)) continue;
            return true;
        }
        for (String string : quoted) {
            if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)string)) {
                return true;
            }
            for (String group : groupPath) {
                if (!StringUtil.containsIgnoreCase((String)group, (String)string)) continue;
                return true;
            }
            String description = descriptor.getToolWrapper().loadDescription();
            if (description != null && StringUtil.containsIgnoreCase((String)description.toLowerCase(), (String)string)) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        for (Set set : keySetList) {
            if (set.contains(descriptor.getKey().toString())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    private void fillTreeData(String filter, boolean forceInclude) {
        Set filters;
        if (this.mySelectedProfile == null) {
            return;
        }
        this.myRoot.removeAllChildren();
        this.myRoot.setChecked(false);
        this.myRoot.dropCache();
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        HashSet<String> quoted = new HashSet<String>();
        if (filter != null && !filter.isEmpty()) {
            keySetList.addAll(SearchUtil.findKeys(filter, quoted));
        }
        Project project = this.myProjectProfileManager.getProject();
        for (Descriptor descriptor : this.myDescriptors.keySet()) {
            if (filter != null && !filter.isEmpty() && !SingleInspectionProfilePanel.isDescriptorAccepted(descriptor, filter, forceInclude, keySetList, quoted)) continue;
            List<ScopeToolState> nonDefaultTools = this.mySelectedProfile.getNonDefaultTools(descriptor.getKey().toString(), project);
            HighlightDisplayKey key = descriptor.getKey();
            boolean enabled = this.mySelectedProfile.isToolEnabled(key);
            boolean hasNonDefaultScope = !nonDefaultTools.isEmpty();
            InspectionConfigTreeNode node = new InspectionConfigTreeNode(descriptor, null, !hasNonDefaultScope, enabled, !hasNonDefaultScope);
            SingleInspectionProfilePanel.getGroupNode(this.myRoot, descriptor.getGroup()).add((MutableTreeNode)((Object)node));
            if (hasNonDefaultScope) {
                for (Descriptor desc : this.myDescriptors.get(descriptor)) {
                    node.add((MutableTreeNode)((Object)new InspectionConfigTreeNode(desc, desc.getState(), false, false)));
                }
                node.add((MutableTreeNode)((Object)new InspectionConfigTreeNode(descriptor, descriptor.getState(), true, false)));
            }
            this.myRoot.setEnabled(this.myRoot.isEnabled() || enabled);
            this.myRoot.dropCache();
        }
        if (filter != null && forceInclude && this.myRoot.getChildCount() == 0 && ((filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter)).size() > 1 || !quoted.isEmpty())) {
            this.fillTreeData(filter, false);
        }
        TreeUtil.sort((DefaultMutableTreeNode)((Object)this.myRoot), (Comparator)new InspectionsConfigTreeComparator());
    }

    private void updateOptionsAndDescriptionPanel(TreePath path) {
        if (path == null) {
            return;
        }
        final InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)path.getLastPathComponent());
        Descriptor descriptor = node.getDescriptor();
        if (descriptor != null) {
            String description = descriptor.loadDescription();
            if (description != null) {
                try {
                    HintHint hintHint = new HintHint(this.myBrowser, new Point(0, 0));
                    hintHint.setFont(this.myBrowser.getFont());
                    this.myBrowser.read(new StringReader(SearchUtil.markup(HintUtil.prepareHintText(description, hintHint), this.myProfileFilter.getFilter())), null);
                }
                catch (IOException e2) {
                    try {
                        this.myBrowser.read(new StringReader(XmlStringUtil.wrapInHtml((CharSequence)("<b>" + UNDER_CONSTRUCTION + "</b>"))), null);
                    }
                    catch (IOException e1) {}
                }
            } else {
                try {
                    this.myBrowser.read(new StringReader(EMPTY_HTML), null);
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            this.myOptionsPanel.removeAll();
            final NamedScope scope = node.getScope(this.myProjectProfileManager.getProject());
            if (scope != null || node.isInspectionNode()) {
                final HighlightDisplayKey key = descriptor.getKey();
                final LevelChooser chooser = new LevelChooser(((SeverityProvider)this.mySelectedProfile.getProfileManager()).getOwnSeverityRegistrar()){

                    public Dimension getPreferredSize() {
                        Dimension preferredSize = super.getPreferredSize();
                        return new Dimension(Math.min(300, preferredSize.width), preferredSize.height);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                chooser.getComboBox().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Project project = SingleInspectionProfilePanel.this.myProjectProfileManager.getProject();
                        boolean toUpdate = SingleInspectionProfilePanel.this.mySelectedProfile.getErrorLevel(key, scope, project) != chooser.getLevel();
                        SingleInspectionProfilePanel.this.mySelectedProfile.setErrorLevel(key, chooser.getLevel(), node.isInspectionNode() || node.isByDefault() ? -1 : node.getParent().getIndex((TreeNode)((Object)node)), project);
                        if (toUpdate) {
                            node.dropCache();
                        }
                    }
                });
                chooser.setLevel(this.mySelectedProfile.getErrorLevel(key, scope, this.myProjectProfileManager.getProject()));
                JPanel withSeverity = new JPanel(new GridBagLayout());
                withSeverity.add((Component)new JLabel(InspectionsBundle.message((String)"inspection.severity", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
                withSeverity.add((Component)((Object)chooser), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
                JComponent comp = descriptor.getState().getAdditionalConfigPanel();
                withSeverity.add((Component)comp, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.myOptionsPanel.add((Component)withSeverity, "Center");
            }
            this.myOptionsPanel.revalidate();
            GuiUtils.enableChildren((Component)this.myOptionsPanel, (boolean)node.isChecked(), (JComponent[])new JComponent[0]);
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.myOptionsPanel.repaint();
    }

    private void initOptionsAndDescriptionPanel() {
        this.myOptionsPanel.removeAll();
        try {
            this.myBrowser.read(new StringReader(EMPTY_HTML), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myOptionsPanel.validate();
        this.myOptionsPanel.repaint();
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String[] groupPath) {
        InspectionConfigTreeNode currentRoot = root;
        for (String group : groupPath) {
            currentRoot = SingleInspectionProfilePanel.getGroupNode(currentRoot, group);
        }
        return currentRoot;
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String group) {
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)((Object)root.getChildAt(i));
            if (!group.equals(child.getUserObject())) continue;
            return child;
        }
        InspectionConfigTreeNode child = new InspectionConfigTreeNode(group, null, false, false);
        root.add((MutableTreeNode)((Object)child));
        return child;
    }

    public boolean setSelectedProfileModified(boolean modified) {
        this.mySelectedProfile.setModified(modified);
        return modified;
    }

    ModifiableModel getSelectedProfile() {
        return this.mySelectedProfile;
    }

    private void setSelectedProfile(ModifiableModel modifiableModel) {
        if (this.mySelectedProfile == modifiableModel) {
            return;
        }
        this.mySelectedProfile = (InspectionProfileImpl)modifiableModel;
        if (this.mySelectedProfile != null) {
            this.myInitialProfile = this.mySelectedProfile.getName();
        }
        this.initDescriptors();
        this.filterTree(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    public void disposeUI() {
        if (this.myInspectionProfilePanel == null) {
            return;
        }
        this.myProperties.setFloat(VERTICAL_DIVIDER_PROPORTION, this.myMainSplitter.getProportion());
        this.myProperties.setFloat(HORIZONTAL_DIVIDER_PROPORTION, this.myRightSplitter.getProportion());
        this.myAlarm.cancelAllRequests();
        this.myProfileFilter.dispose();
        if (this.mySelectedProfile != null) {
            for (ScopeToolState state : this.mySelectedProfile.getAllTools(this.myProjectProfileManager.getProject())) {
                state.resetConfigPanel();
            }
        }
        this.mySelectedProfile = null;
    }

    private JPanel createInspectionProfileSettingsPanel() {
        this.myBrowser = new JEditorPane("text/html", EMPTY_HTML);
        this.myBrowser.setEditable(false);
        this.myBrowser.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
        this.myBrowser.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        this.initDescriptors();
        this.fillTreeData(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null, true);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.description.title", (Object[])new Object[0]), (boolean)false, (Insets)new Insets(13, 0, 0, 0)));
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myBrowser), "Center");
        this.myRightSplitter = new Splitter(true);
        this.myRightSplitter.setFirstComponent((JComponent)descriptionPanel);
        this.myRightSplitter.setProportion(this.myProperties.getFloat(HORIZONTAL_DIVIDER_PROPORTION, 0.5f));
        this.myOptionsPanel = new JPanel(new BorderLayout());
        this.myOptionsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Options", (boolean)false, (Insets)new Insets(0, 0, 0, 0)));
        this.initOptionsAndDescriptionPanel();
        this.myRightSplitter.setSecondComponent((JComponent)this.myOptionsPanel);
        this.myRightSplitter.setHonorComponentsMinimumSize(true);
        JPanel treePanel = new JPanel(new BorderLayout());
        JScrollPane tree = this.initTreeScrollPane();
        treePanel.add((Component)tree, "Center");
        JPanel northPanel = new JPanel(new GridBagLayout());
        northPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)0, (int)2, (int)0));
        northPanel.add((Component)this.createTreeToolbarPanel().getComponent(), new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 512, 2, new Insets(0, 0, 0, 0), 0, 0));
        northPanel.add((Component)this.myProfileFilter, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 768, 2, new Insets(0, 0, 0, 0), 0, 0));
        treePanel.add((Component)northPanel, "North");
        this.myMainSplitter = new Splitter(false);
        this.myMainSplitter.setFirstComponent((JComponent)treePanel);
        this.myMainSplitter.setSecondComponent((JComponent)this.myRightSplitter);
        this.myMainSplitter.setHonorComponentsMinimumSize(false);
        this.myMainSplitter.setProportion(this.myProperties.getFloat(VERTICAL_DIVIDER_PROPORTION, 0.5f));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myMainSplitter, "Center");
        return panel;
    }

    public boolean isModified() {
        if (this.myModified) {
            return true;
        }
        if (this.mySelectedProfile.isChanged()) {
            return true;
        }
        if (this.myShareProfile != (this.mySelectedProfile.getProfileManager() == this.myProjectProfileManager)) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myInitialProfile, (String)this.mySelectedProfile.getName())) {
            return true;
        }
        return this.descriptorsAreChanged();
    }

    public void reset() {
        this.myModified = false;
        this.setSelectedProfile(this.mySelectedProfile);
        String filter = this.myProfileFilter.getFilter();
        this.myProfileFilter.reset();
        this.myProfileFilter.setSelectedItem(filter);
        this.myShareProfile = this.mySelectedProfile.getProfileManager() == this.myProjectProfileManager;
    }

    public void apply() throws ConfigurationException {
        boolean modified = this.isModified();
        if (!modified) {
            return;
        }
        ModifiableModel selectedProfile = this.getSelectedProfile();
        ProfileManager profileManager = (ProfileManager)(this.myShareProfile ? this.myProjectProfileManager : InspectionProfileManager.getInstance());
        selectedProfile.setLocal(!this.myShareProfile);
        if (selectedProfile.getProfileManager() != profileManager) {
            if (selectedProfile.getProfileManager().getProfile(selectedProfile.getName(), false) != null) {
                selectedProfile.getProfileManager().deleteProfile(selectedProfile.getName());
            }
            SingleInspectionProfilePanel.copyUsedSeveritiesIfUndefined(selectedProfile, profileManager);
            selectedProfile.setProfileManager(profileManager);
        }
        InspectionProfile parentProfile = selectedProfile.getParentProfile();
        if (((InspectionProfileManagerImpl)InspectionProfileManager.getInstance()).getSchemesManager().isShared((Scheme)selectedProfile) && this.descriptorsAreChanged()) {
            throw new ConfigurationException("Shared profile cannot be modified. Please do \"Save As...\" first.");
        }
        try {
            selectedProfile.commit();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        this.setSelectedProfile(parentProfile.getModifiableModel());
        this.setSelectedProfileModified(false);
        this.myModified = false;
    }

    private static void copyUsedSeveritiesIfUndefined(ModifiableModel selectedProfile, ProfileManager profileManager) {
        SeverityRegistrar registrar = ((SeverityProvider)profileManager).getSeverityRegistrar();
        Set<HighlightSeverity> severities = ((InspectionProfileImpl)selectedProfile).getUsedSeverities();
        Iterator<HighlightSeverity> iterator = severities.iterator();
        while (iterator.hasNext()) {
            HighlightSeverity severity = iterator.next();
            if (!registrar.isSeverityValid(severity.getName())) continue;
            iterator.remove();
        }
        if (!severities.isEmpty()) {
            SeverityRegistrar oppositeRegister = ((SeverityProvider)selectedProfile.getProfileManager()).getSeverityRegistrar();
            for (HighlightSeverity severity : severities) {
                TextAttributesKey attributesKey = TextAttributesKey.find((String)severity.getName());
                TextAttributes textAttributes = oppositeRegister.getTextAttributesBySeverity(severity);
                LOG.assertTrue(textAttributes != null, (Object)severity);
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(severity, attributesKey);
                registrar.registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
            }
        }
    }

    private boolean descriptorsAreChanged() {
        for (Map.Entry<Descriptor, List<Descriptor>> entry : this.myDescriptors.entrySet()) {
            Descriptor desc = entry.getKey();
            Project project = this.myProjectProfileManager.getProject();
            if (this.mySelectedProfile.isToolEnabled(desc.getKey(), null, project) != desc.isEnabled()) {
                return true;
            }
            if (this.mySelectedProfile.getErrorLevel(desc.getKey(), desc.getScope(), project) != desc.getLevel()) {
                return true;
            }
            List<Descriptor> descriptors = entry.getValue();
            for (Descriptor descriptor : descriptors) {
                if (this.mySelectedProfile.isToolEnabled(descriptor.getKey(), descriptor.getScope(), project) != descriptor.isEnabled()) {
                    return true;
                }
                if (this.mySelectedProfile.getErrorLevel(descriptor.getKey(), descriptor.getScope(), project) == descriptor.getLevel()) continue;
                return true;
            }
            List<ScopeToolState> tools = this.mySelectedProfile.getNonDefaultTools(desc.getKey().toString(), project);
            if (tools.size() != descriptors.size()) {
                return true;
            }
            for (int i = 0; i < tools.size(); ++i) {
                ScopeToolState pair = tools.get(i);
                if (Comparing.equal((Object)pair.getScope(project), (Object)descriptors.get(i).getScope())) continue;
                return true;
            }
        }
        return false;
    }

    public Tree getTree() {
        return this.myTree;
    }

    public boolean isProfileShared() {
        return this.myShareProfile;
    }

    public void setProfileShared(boolean profileShared) {
        this.myShareProfile = profileShared;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.myInspectionProfilePanel == null) {
            this.initUI();
        }
        super.setVisible(aFlag);
    }

    private void setNewHighlightingLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "setNewHighlightingLevel"));
        }
        int[] rows = this.myTree.getSelectionRows();
        boolean showOptionsAndDescriptorPanels = rows != null && rows.length == 1;
        for (int i = 0; rows != null && i < rows.length; ++i) {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)this.myTree.getPathForRow(rows[i]).getLastPathComponent());
            InspectionConfigTreeNode parent = (InspectionConfigTreeNode)((Object)node.getParent());
            Object userObject = node.getUserObject();
            if (userObject instanceof Descriptor && (node.getScopeName() != null || node.isLeaf())) {
                this.updateErrorLevel(node, showOptionsAndDescriptorPanels, level);
                SingleInspectionProfilePanel.updateUpHierarchy(node, parent);
                continue;
            }
            this.updateErrorLevelUpInHierarchy(level, showOptionsAndDescriptorPanels, node);
            SingleInspectionProfilePanel.updateUpHierarchy(node, parent);
        }
        if (rows != null && rows.length == 1) {
            this.updateOptionsAndDescriptionPanel(this.myTree.getPathForRow(rows[0]));
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.repaintTableData();
    }

    private void updateErrorLevelUpInHierarchy(@NotNull HighlightDisplayLevel level, boolean showOptionsAndDescriptorPanels, InspectionConfigTreeNode node) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "updateErrorLevelUpInHierarchy"));
        }
        node.dropCache();
        for (int j = 0; j < node.getChildCount(); ++j) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)((Object)node.getChildAt(j));
            Object userObject = child.getUserObject();
            if (userObject instanceof Descriptor && (child.getScopeName() != null || child.isLeaf())) {
                this.updateErrorLevel(child, showOptionsAndDescriptorPanels, level);
                continue;
            }
            this.updateErrorLevelUpInHierarchy(level, showOptionsAndDescriptorPanels, child);
        }
    }

    private void updateErrorLevel(InspectionConfigTreeNode child, boolean showOptionsAndDescriptorPanels, @NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel", "updateErrorLevel"));
        }
        HighlightDisplayKey key = child.getDescriptor().getKey();
        this.mySelectedProfile.setErrorLevel(key, level, child.isInspectionNode() || child.isByDefault() ? -1 : child.getParent().getIndex((TreeNode)((Object)child)), this.myProjectProfileManager.getProject());
        child.dropCache();
        if (showOptionsAndDescriptorPanels) {
            this.updateOptionsAndDescriptionPanel(new TreePath(child.getPath()));
        }
    }

    private class MyDeleteScopeAction
    extends DeleteScopeAction {
        public MyDeleteScopeAction() {
            super(SingleInspectionProfilePanel.this.myTree);
        }

        @Override
        protected InspectionProfileImpl getSelectedProfile() {
            return SingleInspectionProfilePanel.this.mySelectedProfile;
        }
    }

    private class MyAddScopeAction
    extends AddScopeAction {
        public MyAddScopeAction() {
            super(SingleInspectionProfilePanel.this.myTree);
        }

        @Override
        protected InspectionProfileImpl getSelectedProfile() {
            return SingleInspectionProfilePanel.this.mySelectedProfile;
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            super.actionPerformed(e);
            TreePath[] paths = SingleInspectionProfilePanel.this.myTree.getSelectionPaths();
            if (paths != null && paths.length == 1) {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(SingleInspectionProfilePanel.this.myTree.getSelectionPath());
            } else {
                SingleInspectionProfilePanel.this.initOptionsAndDescriptionPanel();
            }
        }
    }

    private class MyFilterComponent
    extends FilterComponent {
        private MyFilterComponent() {
            super(SingleInspectionProfilePanel.INSPECTION_FILTER_HISTORY, 10);
            this.setHistory(Arrays.asList("\"New in 13\""));
        }

        public void filter() {
            SingleInspectionProfilePanel.this.filterTree(this.getFilter());
        }

        protected void onlineFilter() {
            if (SingleInspectionProfilePanel.this.mySelectedProfile == null) {
                return;
            }
            String filter = this.getFilter();
            SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.mySelectedProfile).saveVisibleState(SingleInspectionProfilePanel.this.myTree);
            SingleInspectionProfilePanel.this.fillTreeData(filter, true);
            SingleInspectionProfilePanel.this.reloadModel();
            if (filter == null || filter.isEmpty()) {
                SingleInspectionProfilePanel.this.restoreTreeState();
            } else {
                TreeUtil.expandAll((JTree)SingleInspectionProfilePanel.this.myTree);
            }
        }
    }
}

