/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SeverityUtil;
import com.intellij.codeInspection.ex.SeverityEditorDialog;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class LevelChooser
extends ComboboxWithBrowseButton {
    public LevelChooser(final SeverityRegistrar severityRegistrar) {
        JComboBox comboBox = this.getComboBox();
        final DefaultComboBoxModel model = new DefaultComboBoxModel();
        comboBox.setModel(model);
        LevelChooser.fillModel(model, severityRegistrar);
        this.getButton().setToolTipText("Edit severities (" + this.getButton().getToolTipText(null) + ")");
        comboBox.setRenderer(new ListCellRendererWrapper<HighlightSeverity>(){

            public void customize(JList list, HighlightSeverity value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(SingleInspectionProfilePanel.renderSeverity(value));
                    this.setIcon(HighlightDisplayLevel.find((HighlightSeverity)value).getIcon());
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeverityEditorDialog dlg = new SeverityEditorDialog((JComponent)((Object)LevelChooser.this), (HighlightSeverity)LevelChooser.this.getComboBox().getSelectedItem(), severityRegistrar);
                dlg.show();
                if (dlg.isOK()) {
                    Object item = LevelChooser.this.getComboBox().getSelectedItem();
                    LevelChooser.fillModel(model, severityRegistrar);
                    HighlightInfoType type = dlg.getSelectedType();
                    if (type != null) {
                        LevelChooser.this.getComboBox().setSelectedItem(type.getSeverity(null));
                    } else {
                        LevelChooser.this.getComboBox().setSelectedItem(item);
                    }
                }
            }
        });
    }

    private static void fillModel(DefaultComboBoxModel model, SeverityRegistrar severityRegistrar) {
        model.removeAllElements();
        TreeSet<HighlightSeverity> severities = new TreeSet<HighlightSeverity>(severityRegistrar);
        for (SeverityRegistrar.SeverityBasedTextAttributes type : SeverityUtil.getRegisteredHighlightingInfoTypes(severityRegistrar)) {
            severities.add(type.getSeverity());
        }
        severities.add(HighlightSeverity.ERROR);
        severities.add(HighlightSeverity.WARNING);
        severities.add(HighlightSeverity.WEAK_WARNING);
        severities.add(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        for (HighlightSeverity severity : severities) {
            model.addElement(severity);
        }
    }

    @NotNull
    public HighlightDisplayLevel getLevel() {
        HighlightSeverity severity = (HighlightSeverity)this.getComboBox().getSelectedItem();
        if (severity == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            if (highlightDisplayLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/LevelChooser", "getLevel"));
            }
            return highlightDisplayLevel;
        }
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.find((HighlightSeverity)severity);
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/LevelChooser", "getLevel"));
        }
        return highlightDisplayLevel;
    }

    public void setLevel(HighlightDisplayLevel level) {
        this.getComboBox().setSelectedItem(level.getSeverity());
    }
}

