/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

abstract class InspectionsConfigTreeRenderer
extends CheckboxTree.CheckboxTreeCellRenderer {
    private final Project myProject;

    public InspectionsConfigTreeRenderer(Project project) {
        this.myProject = project;
    }

    protected abstract String getFilter();

    public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text;
        if (!(value instanceof InspectionConfigTreeNode)) {
            return;
        }
        InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)value);
        Object object = node.getUserObject();
        Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
        UIUtil.changeBackGround((Component)((Object)this), (Color)background);
        Color foreground = selected ? UIUtil.getTreeSelectionForeground() : (node.isProperSetting() ? PlatformColors.BLUE : UIUtil.getTreeTextForeground());
        int style = 0;
        String hint = null;
        if (object instanceof String) {
            text = (String)object;
            style = 1;
        } else {
            Descriptor descriptor = node.getDescriptor();
            String scopeName = node.getScopeName();
            if (scopeName != null) {
                if (node.isByDefault()) {
                    text = "Everywhere else";
                } else {
                    text = "In scope '" + scopeName + "'";
                    if (node.getScope(this.myProject) == null) {
                        foreground = JBColor.RED;
                    }
                }
            } else {
                text = descriptor.getText();
            }
            hint = InspectionsConfigTreeRenderer.getHint(descriptor);
        }
        if (text != null) {
            SearchUtil.appendFragments(this.getFilter(), text, style, foreground, background, (SimpleColoredComponent)this.getTextRenderer());
        }
        if (hint != null) {
            this.getTextRenderer().append(" " + hint, selected ? new SimpleTextAttributes(0, foreground) : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        this.setForeground(foreground);
    }

    @Nullable
    private static String getHint(Descriptor descriptor) {
        InspectionToolWrapper toolWrapper = descriptor.getToolWrapper();
        if (toolWrapper == null) {
            return InspectionsBundle.message((String)"inspection.tool.availability.in.tree.node", (Object[])new Object[0]);
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper || toolWrapper instanceof GlobalInspectionToolWrapper && !((GlobalInspectionToolWrapper)toolWrapper).worksInBatchModeOnly()) {
            return null;
        }
        return InspectionsBundle.message((String)"inspection.tool.availability.in.tree.node1", (Object[])new Object[0]);
    }
}

