/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.CheckedTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionConfigTreeNode
extends CheckedTreeNode {
    private final ScopeToolState myState;
    private boolean myByDefault;
    private boolean myInspectionNode;
    private final ClearableLazyValue<Boolean> myProperSetting;

    public InspectionConfigTreeNode(@NotNull Object userObject, ScopeToolState state, boolean byDefault, boolean inspectionNode) {
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/ui/InspectionConfigTreeNode", "<init>"));
        }
        super(userObject);
        this.myProperSetting = new ClearableLazyValue<Boolean>(){

            @NotNull
            protected Boolean compute() {
                Descriptor descriptor = InspectionConfigTreeNode.this.getDescriptor();
                if (descriptor != null) {
                    Boolean bl = descriptor.getInspectionProfile().isProperSetting(descriptor.getToolWrapper().getShortName());
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/InspectionConfigTreeNode$1", "compute"));
                    }
                    return bl;
                }
                for (int i = 0; i < InspectionConfigTreeNode.this.getChildCount(); ++i) {
                    InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)InspectionConfigTreeNode.this.getChildAt(i));
                    if (!node.isProperSetting()) continue;
                    Boolean bl = true;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/InspectionConfigTreeNode$1", "compute"));
                    }
                    return bl;
                }
                Boolean bl = false;
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/InspectionConfigTreeNode$1", "compute"));
                }
                return bl;
            }
        };
        this.myState = state;
        this.myByDefault = byDefault;
        this.myInspectionNode = inspectionNode;
        if (state != null) {
            this.setChecked(state.isEnabled());
        }
    }

    public InspectionConfigTreeNode(@NotNull Descriptor descriptor, ScopeToolState state, boolean byDefault, boolean isEnabled, boolean inspectionNode) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/ui/InspectionConfigTreeNode", "<init>"));
        }
        this(descriptor, state, byDefault, inspectionNode);
        this.setChecked(isEnabled);
    }

    @Nullable
    public Descriptor getDescriptor() {
        if (this.userObject instanceof String) {
            return null;
        }
        return (Descriptor)this.userObject;
    }

    @Nullable
    public NamedScope getScope(Project project) {
        return this.myState == null ? null : this.myState.getScope(project);
    }

    public boolean isByDefault() {
        return this.myByDefault;
    }

    @Nullable
    public String getGroupName() {
        return this.userObject instanceof String ? (String)this.userObject : null;
    }

    public boolean isInspectionNode() {
        return this.myInspectionNode;
    }

    public void setInspectionNode(boolean inspectionNode) {
        this.myInspectionNode = inspectionNode;
    }

    public void setByDefault(boolean byDefault) {
        this.myByDefault = byDefault;
    }

    @Nullable
    public String getScopeName() {
        return this.myState != null ? this.myState.getScopeName() : null;
    }

    public boolean isProperSetting() {
        return (Boolean)this.myProperSetting.getValue();
    }

    public void dropCache() {
        this.myProperSetting.drop();
    }

    public String toString() {
        if (this.userObject instanceof Descriptor) {
            return ((Descriptor)this.userObject).getText();
        }
        return super.toString();
    }
}

