/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileLoadUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileManagerImpl
extends InspectionProfileManager
implements SeverityProvider,
ExportableComponent,
JDOMExternalizable,
NamedComponent {
    private final InspectionToolRegistrar myRegistrar;
    private final SchemesManager<Profile, InspectionProfileImpl> mySchemesManager;
    private final AtomicBoolean myProfilesAreInitialized = new AtomicBoolean(false);
    private final SeverityRegistrar mySeverityRegistrar = new SeverityRegistrar();
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProfileManager");
    private volatile boolean LOAD_PROFILES = !ApplicationManager.getApplication().isUnitTestMode();

    public static InspectionProfileManagerImpl getInstanceImpl() {
        return (InspectionProfileManagerImpl)ServiceManager.getService(InspectionProfileManager.class);
    }

    public InspectionProfileManagerImpl(InspectionToolRegistrar registrar, SchemesManagerFactory schemesManagerFactory) {
        this.myRegistrar = registrar;
        InspectionProfileManagerImpl.registerProvidedSeverities();
        BaseSchemeProcessor<InspectionProfileImpl> processor = new BaseSchemeProcessor<InspectionProfileImpl>(){

            public InspectionProfileImpl readScheme(@NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "readScheme"));
                }
                InspectionProfileImpl profile = new InspectionProfileImpl(InspectionProfileLoadUtil.getProfileName(document), InspectionProfileManagerImpl.this.myRegistrar, (ProfileManager)InspectionProfileManagerImpl.this);
                InspectionProfileManagerImpl.read(profile, document.getRootElement());
                return profile;
            }

            public boolean shouldBeSaved(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "shouldBeSaved"));
                }
                return scheme.wasInitialized();
            }

            public Document writeScheme(@NotNull InspectionProfileImpl scheme) throws WriteExternalException {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "writeScheme"));
                }
                return scheme.saveToDocument();
            }

            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "onSchemeAdded"));
                }
                InspectionProfileManagerImpl.updateProfileImpl(scheme);
                InspectionProfileManagerImpl.this.fireProfileChanged(scheme);
                InspectionProfileManagerImpl.onProfilesChanged();
            }

            public void onSchemeDeleted(@NotNull InspectionProfileImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl$1", "onSchemeDeleted"));
                }
                InspectionProfileManagerImpl.onProfilesChanged();
            }

            public void onCurrentSchemeChanged(Scheme oldCurrentScheme) {
                Profile current = (Profile)InspectionProfileManagerImpl.this.mySchemesManager.getCurrentScheme();
                if (current != null) {
                    InspectionProfileManagerImpl.this.fireProfileChanged((Profile)oldCurrentScheme, current, null);
                }
                InspectionProfileManagerImpl.onProfilesChanged();
            }
        };
        this.mySchemesManager = schemesManagerFactory.createSchemesManager("$ROOT_CONFIG$/inspection", (SchemeProcessor)processor, RoamingType.PER_USER);
    }

    private static void read(final @NotNull InspectionProfileImpl profile, @NotNull Element element) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "read"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "read"));
        }
        try {
            profile.readExternal(element);
        }
        catch (Exception e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, profile.getName()}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0]));
                }
            }, ModalityState.NON_MODAL);
        }
    }

    @NotNull
    private static InspectionProfileImpl createSampleProfile() {
        InspectionProfileImpl inspectionProfileImpl = new InspectionProfileImpl("Default");
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "createSampleProfile"));
        }
        return inspectionProfileImpl;
    }

    public static void registerProvidedSeverities() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(null);
                SeverityRegistrar.registerStandard(highlightInfoType, highlightSeverity);
                TextAttributesKey attributesKey = highlightInfoType.getAttributesKey();
                TextAttributes textAttributes = scheme.getAttributes(attributesKey);
                if (textAttributes == null) {
                    textAttributes = attributesKey.getDefaultAttributes();
                }
                HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (Color)provider.getTrafficRendererColor(textAttributes));
            }
        }
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{InspectionProfileManagerImpl.getProfileDirectory()};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = InspectionsBundle.message((String)"inspection.profiles.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public Collection<Profile> getProfiles() {
        this.initProfiles();
        List list = this.mySchemesManager.getAllSchemes();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getProfiles"));
        }
        return list;
    }

    public void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.myProfilesAreInitialized.set(false);
    }

    @Override
    public void initProfiles() {
        if (this.myProfilesAreInitialized.getAndSet(true)) {
            if (this.mySchemesManager.getAllSchemeNames().isEmpty()) {
                this.createDefaultProfile();
            }
            return;
        }
        if (!this.LOAD_PROFILES) {
            return;
        }
        this.mySchemesManager.loadSchemes();
        List profiles = this.mySchemesManager.getAllSchemes();
        if (profiles.isEmpty()) {
            this.createDefaultProfile();
        } else {
            for (Profile profile : profiles) {
                this.addProfile(profile);
            }
        }
    }

    private void createDefaultProfile() {
        InspectionProfileImpl defaultProfile = (InspectionProfileImpl)this.createProfile();
        defaultProfile.setBaseProfile(InspectionProfileImpl.getDefaultProfile());
        this.addProfile(defaultProfile);
    }

    @Override
    public Profile loadProfile(@NotNull String path) throws IOException, JDOMException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "loadProfile"));
        }
        final File file = new File(path);
        if (file.exists()) {
            try {
                return InspectionProfileLoadUtil.load(file, this.myRegistrar, (ProfileManager)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (JDOMException e) {
                throw e;
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.error.loading.message", (Object[])new Object[]{0, file}), (String)InspectionsBundle.message((String)"inspection.errors.occurred.dialog.title", (Object[])new Object[0]));
                    }
                }, ModalityState.NON_MODAL);
            }
        }
        return this.getProfile(path, false);
    }

    public void updateProfile(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "updateProfile"));
        }
        this.mySchemesManager.addNewScheme((Scheme)profile, true);
        InspectionProfileManagerImpl.updateProfileImpl(profile);
    }

    private static void updateProfileImpl(@NotNull Profile profile) {
        Project[] projects;
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "updateProfileImpl"));
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            InspectionProjectProfileManager.getInstance(project).initProfileWrapper(profile);
        }
    }

    @Override
    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getSeverityRegistrar"));
        }
        return severityRegistrar;
    }

    @Override
    @NotNull
    public SeverityRegistrar getOwnSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getOwnSeverityRegistrar"));
        }
        return severityRegistrar;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.mySeverityRegistrar.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.mySeverityRegistrar.writeExternal(element);
    }

    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    public Profile createProfile() {
        return InspectionProfileManagerImpl.createSampleProfile();
    }

    public void setRootProfile(String rootProfile) {
        Profile current = (Profile)this.mySchemesManager.getCurrentScheme();
        if (current != null && !Comparing.strEqual((String)rootProfile, (String)current.getName())) {
            this.fireProfileChanged(current, this.getProfile(rootProfile), null);
        }
        this.mySchemesManager.setCurrentSchemeName(rootProfile);
    }

    public Profile getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getProfile"));
        }
        Profile found = (Profile)this.mySchemesManager.findSchemeByName(name);
        if (found != null) {
            return found;
        }
        if (returnRootProfileIfNamedIsAbsent) {
            return this.getRootProfile();
        }
        return null;
    }

    @NotNull
    public Profile getRootProfile() {
        Profile current = (Profile)this.mySchemesManager.getCurrentScheme();
        if (current != null) {
            Profile profile = current;
            if (profile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getRootProfile"));
            }
            return profile;
        }
        Collection<Profile> profiles = this.getProfiles();
        if (profiles.isEmpty()) {
            InspectionProfileImpl inspectionProfileImpl = InspectionProfileManagerImpl.createSampleProfile();
            if (inspectionProfileImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getRootProfile"));
            }
            return inspectionProfileImpl;
        }
        Profile profile = profiles.iterator().next();
        if (profile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getRootProfile"));
        }
        return profile;
    }

    public void deleteProfile(String profile) {
        Profile found = (Profile)this.mySchemesManager.findSchemeByName(profile);
        if (found != null) {
            this.mySchemesManager.removeScheme((Scheme)found);
        }
    }

    public void addProfile(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "addProfile"));
        }
        this.mySchemesManager.addNewScheme((Scheme)profile, true);
    }

    @NotNull
    public String[] getAvailableProfileNames() {
        Collection names = this.mySchemesManager.getAllSchemeNames();
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getAvailableProfileNames"));
        }
        return stringArray;
    }

    @Override
    public Profile getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getProfile"));
        }
        return this.getProfile(name, true);
    }

    @NotNull
    public SchemesManager<Profile, InspectionProfileImpl> getSchemesManager() {
        SchemesManager<Profile, InspectionProfileImpl> schemesManager = this.mySchemesManager;
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProfileManagerImpl", "getSchemesManager"));
        }
        return schemesManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onProfilesChanged() {
        for (final Project project : ProjectManager.getInstance().getOpenProjects()) {
            HighlightingSettingsPerFile highlightingSettingsPerFile = HighlightingSettingsPerFile.getInstance(project);
            synchronized (highlightingSettingsPerFile) {
            }
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed()) {
                        DaemonListeners.getInstance(project).updateStatusBar();
                    }
                }
            });
        }
    }
}

