/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Outcome<V> {
    private final V myData;
    private final boolean myCancelled;
    private final Exception myException;

    private Outcome(V data, boolean cancelled, Exception exception) {
        this.myData = data;
        this.myCancelled = cancelled;
        this.myException = exception;
    }

    @Nullable
    public V get() {
        return this.myData;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }

    @Nullable
    public Exception getException() {
        return this.myException;
    }

    @NotNull
    public static <V> Outcome<V> createAsCancelled() {
        Outcome<Object> outcome = new Outcome<Object>(null, true, null);
        if (outcome == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/Outcome", "createAsCancelled"));
        }
        return outcome;
    }

    @NotNull
    public static <V> Outcome<V> createAsException(@NotNull Exception ex) {
        if (ex == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/platform/templates/github/Outcome", "createAsException"));
        }
        Outcome<Object> outcome = new Outcome<Object>(null, false, ex);
        if (outcome == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/Outcome", "createAsException"));
        }
        return outcome;
    }

    @NotNull
    public static <V> Outcome<V> createNormal(@NotNull V data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/platform/templates/github/Outcome", "createNormal"));
        }
        Outcome<V> outcome = new Outcome<V>(data, false, null);
        if (outcome == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/Outcome", "createNormal"));
        }
        return outcome;
    }
}

