/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates.github;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.Outcome;
import com.intellij.util.Producer;
import com.intellij.util.containers.Predicate;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadUtil {
    public static final String CONTENT_LENGTH_TEMPLATE = "${content-length}";
    private static final Logger LOG = Logger.getInstance(DownloadUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull File tempFile, @Nullable Predicate<String> contentChecker) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        if (tempFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        try {
            String content;
            DownloadUtil.downloadContentToFile(indicator, url, tempFile);
            if (contentChecker != null && !contentChecker.apply((Object)(content = FileUtil.loadFile((File)tempFile)))) {
                boolean bl = false;
                return bl;
            }
            FileUtil.rename((File)tempFile, (File)outputFile);
            boolean bl = true;
            return bl;
        }
        finally {
            FileUtil.delete((File)tempFile);
        }
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        File tempFile = FileUtil.createTempFile((String)"for-actual-downloading-", null);
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile, null);
    }

    public static void downloadAtomically(@Nullable ProgressIndicator indicator, @NotNull String url, @NotNull File outputFile, @NotNull File tempFile) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        if (tempFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/platform/templates/github/DownloadUtil", "downloadAtomically"));
        }
        DownloadUtil.downloadAtomically(indicator, url, outputFile, tempFile, null);
    }

    @NotNull
    public static <V> Outcome<V> provideDataWithProgressSynchronously(@Nullable Project project, @NotNull String progressTitle, final @NotNull String actionShortDescription, final @NotNull Callable<V> supplier, @Nullable Producer<Boolean> tryAgainProvider) {
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/platform/templates/github/DownloadUtil", "provideDataWithProgressSynchronously"));
        }
        if (actionShortDescription == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/platform/templates/github/DownloadUtil", "provideDataWithProgressSynchronously"));
        }
        if (supplier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/platform/templates/github/DownloadUtil", "provideDataWithProgressSynchronously"));
        }
        int attemptNumber = 1;
        while (true) {
            final Ref dataRef = Ref.create(null);
            final Ref innerExceptionRef = Ref.create(null);
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    indicator.setText(actionShortDescription);
                    try {
                        Object data = supplier.call();
                        dataRef.set(data);
                    }
                    catch (Exception ex) {
                        innerExceptionRef.set((Object)ex);
                    }
                }
            }, progressTitle, true, project);
            if (!completed) {
                Outcome outcome = Outcome.createAsCancelled();
                if (outcome == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/DownloadUtil", "provideDataWithProgressSynchronously"));
                }
                return outcome;
            }
            Exception latestInnerException = (Exception)innerExceptionRef.get();
            if (latestInnerException == null) {
                Outcome<Object> outcome = Outcome.createNormal(dataRef.get());
                if (outcome == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/DownloadUtil", "provideDataWithProgressSynchronously"));
                }
                return outcome;
            }
            LOG.warn("[attempt#" + attemptNumber + "] Can not '" + actionShortDescription + "'", (Throwable)latestInnerException);
            boolean onceMore = false;
            if (tryAgainProvider != null) {
                onceMore = Boolean.TRUE.equals(tryAgainProvider.produce());
            }
            if (!onceMore) {
                Outcome outcome = Outcome.createAsException(latestInnerException);
                if (outcome == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/github/DownloadUtil", "provideDataWithProgressSynchronously"));
                }
                return outcome;
            }
            ++attemptNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadContentToFile(@Nullable ProgressIndicator progress, @NotNull String url, @NotNull File outputFile) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/platform/templates/github/DownloadUtil", "downloadContentToFile"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/platform/templates/github/DownloadUtil", "downloadContentToFile"));
        }
        boolean parentDirExists = FileUtil.createParentDirs((File)outputFile);
        if (!parentDirExists) {
            throw new IOException("Parent dir of '" + outputFile.getAbsolutePath() + "' can not be created!");
        }
        FileOutputStream out = new FileOutputStream(outputFile);
        try {
            DownloadUtil.download(progress, url, out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static void download(@Nullable ProgressIndicator progress, @NotNull String location, @NotNull OutputStream output) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/platform/templates/github/DownloadUtil", "download"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/platform/templates/github/DownloadUtil", "download"));
        }
        String originalText = progress != null ? progress.getText() : null;
        DownloadUtil.substituteContentLength(progress, originalText, -1);
        if (progress != null) {
            progress.setText2("Downloading " + location);
        }
        HttpURLConnection urlConnection = HttpConfigurable.getInstance().openHttpConnection(location);
        try {
            int timeout = (int)TimeUnit.MINUTES.toMillis(2L);
            urlConnection.setConnectTimeout(timeout);
            urlConnection.setReadTimeout(timeout);
            urlConnection.connect();
            InputStream in = urlConnection.getInputStream();
            int contentLength = urlConnection.getContentLength();
            DownloadUtil.substituteContentLength(progress, originalText, contentLength);
            NetUtils.copyStreamContent((ProgressIndicator)progress, (InputStream)in, (OutputStream)output, (int)contentLength);
        }
        catch (IOException e) {
            throw new IOException("Can not download '" + location + "', response code: " + urlConnection.getResponseCode() + ", response message: " + urlConnection.getResponseMessage() + ", headers: " + urlConnection.getHeaderFields(), e);
        }
        finally {
            try {
                urlConnection.disconnect();
            }
            catch (Exception e) {
                LOG.warn("Exception at disconnect()", (Throwable)e);
            }
        }
    }

    private static void substituteContentLength(@Nullable ProgressIndicator progress, @Nullable String text, int contentLengthInBytes) {
        int ind;
        if (progress != null && text != null && (ind = text.indexOf(CONTENT_LENGTH_TEMPLATE)) != -1) {
            String mes = DownloadUtil.formatContentLength(contentLengthInBytes);
            String newText = text.substring(0, ind) + mes + text.substring(ind + CONTENT_LENGTH_TEMPLATE.length());
            progress.setText(newText);
        }
    }

    private static String formatContentLength(int contentLengthInBytes) {
        if (contentLengthInBytes < 0) {
            return "";
        }
        int kilo = 1024;
        if (contentLengthInBytes < 1024) {
            return ", " + contentLengthInBytes + " bytes";
        }
        if (contentLengthInBytes < 0x100000) {
            return String.format(Locale.US, ", %.1f kB", (double)contentLengthInBytes / 1024.0);
        }
        return String.format(Locale.US, ", %.1f MB", (double)contentLengthInBytes / 1048576.0);
    }
}

