/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.platform.OpenOrAttachDialog;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformProjectOpenProcessor
extends ProjectOpenProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.platform.PlatformProjectOpenProcessor");

    public static PlatformProjectOpenProcessor getInstance() {
        PlatformProjectOpenProcessor projectOpenProcessor = PlatformProjectOpenProcessor.getInstanceIfItExists();
        assert (projectOpenProcessor != null);
        return projectOpenProcessor;
    }

    @Nullable
    public static PlatformProjectOpenProcessor getInstanceIfItExists() {
        ProjectOpenProcessor[] processors;
        for (ProjectOpenProcessor processor : processors = (ProjectOpenProcessor[])Extensions.getExtensions((ExtensionPointName)EXTENSION_POINT_NAME)) {
            if (!(processor instanceof PlatformProjectOpenProcessor)) continue;
            return (PlatformProjectOpenProcessor)processor;
        }
        return null;
    }

    public boolean canOpenProject(VirtualFile file) {
        return file.isDirectory();
    }

    public boolean isProjectFile(VirtualFile file) {
        return false;
    }

    public boolean lookForProjectsInDirectory() {
        return false;
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/platform/PlatformProjectOpenProcessor", "doOpenProject"));
        }
        return PlatformProjectOpenProcessor.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame, -1, null, false);
    }

    @Nullable
    public static Project doOpenProject(@NotNull VirtualFile virtualFile, Project projectToClose, boolean forceOpenInNewFrame, int line, @Nullable ProjectOpenedCallback callback, boolean isReopen) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/platform/PlatformProjectOpenProcessor", "doOpenProject"));
        }
        VirtualFile baseDir = virtualFile;
        boolean dummyProject = false;
        String dummyProjectName = null;
        if (!baseDir.isDirectory()) {
            for (baseDir = virtualFile.getParent(); baseDir != null && !new File(FileUtil.toSystemDependentName((String)baseDir.getPath()), ".idea").exists(); baseDir = baseDir.getParent()) {
            }
            if (baseDir == null) {
                if (Registry.is((String)"ide.open.file.in.temp.project.dir")) {
                    try {
                        dummyProjectName = virtualFile.getName();
                        File directory = FileUtil.createTempDirectory((String)dummyProjectName, null, (boolean)true);
                        baseDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(directory);
                        dummyProject = true;
                    }
                    catch (IOException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
                if (baseDir == null) {
                    baseDir = virtualFile.getParent();
                }
            }
        }
        File projectDir = new File(FileUtil.toSystemDependentName((String)baseDir.getPath()), ".idea");
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            if (projectToClose == null) {
                projectToClose = openProjects[openProjects.length - 1];
            }
            if (ProjectAttachProcessor.canAttachToProject()) {
                OpenOrAttachDialog dialog = new OpenOrAttachDialog(projectToClose, isReopen, isReopen ? "Reopen Project" : "Open Project");
                dialog.show();
                if (dialog.getExitCode() != 0) {
                    return null;
                }
                if (dialog.isReplace() ? !ProjectUtil.closeAndDispose(projectToClose) : dialog.isAttach() && PlatformProjectOpenProcessor.attachToProject(projectToClose, projectDir, callback)) {
                    return null;
                }
            } else {
                int exitCode = ProjectUtil.confirmOpenNewProject(false);
                if (exitCode == 1 ? !ProjectUtil.closeAndDispose(projectToClose) : exitCode != 0) {
                    return null;
                }
            }
        }
        boolean runConfigurators = true;
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project = null;
        if (projectDir.exists()) {
            try {
                for (ProjectOpenProcessor processor : (ProjectOpenProcessor[])ProjectOpenProcessor.EXTENSION_POINT_NAME.getExtensions()) {
                    processor.refreshProjectFiles(projectDir);
                }
                project = projectManager.convertAndLoadProject(baseDir.getPath());
                if (project == null) {
                    WelcomeFrame.showIfNoProjectOpened();
                    return null;
                }
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                if (modules.length > 0) {
                    runConfigurators = false;
                }
            }
            catch (Exception e) {}
        } else {
            projectDir.mkdirs();
        }
        if (project == null) {
            String projectName = dummyProject ? dummyProjectName : projectDir.getParentFile().getName();
            project = projectManager.newProject(projectName, projectDir.getParent(), true, dummyProject);
        }
        if (project == null) {
            return null;
        }
        ProjectBaseDirectory.getInstance(project).setBaseDir(baseDir);
        Module module = runConfigurators ? PlatformProjectOpenProcessor.runDirectoryProjectConfigurators(baseDir, project) : ModuleManager.getInstance(project).getModules()[0];
        PlatformProjectOpenProcessor.openFileFromCommandLine(project, virtualFile, line);
        if (!projectManager.openProject(project)) {
            WelcomeFrame.showIfNoProjectOpened();
            final Project finalProject = project;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)finalProject);
                }
            });
            return project;
        }
        if (callback != null) {
            callback.projectOpened(project, module);
        }
        return project;
    }

    public static Module runDirectoryProjectConfigurators(VirtualFile baseDir, Project project) {
        Ref moduleRef = new Ref();
        for (DirectoryProjectConfigurator configurator : (DirectoryProjectConfigurator[])Extensions.getExtensions(DirectoryProjectConfigurator.EP_NAME)) {
            try {
                configurator.configureProject(project, baseDir, (Ref<Module>)moduleRef);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return (Module)moduleRef.get();
    }

    private static boolean attachToProject(Project project, File projectDir, ProjectOpenedCallback callback) {
        ProjectAttachProcessor[] extensions;
        for (ProjectAttachProcessor processor : extensions = (ProjectAttachProcessor[])Extensions.getExtensions((ExtensionPointName)ProjectAttachProcessor.EP_NAME)) {
            if (!processor.attachToProject(project, projectDir, callback)) continue;
            return true;
        }
        return false;
    }

    private static void openFileFromCommandLine(final Project project, final VirtualFile virtualFile, final int line) {
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!virtualFile.isDirectory()) {
                                    if (line > 0) {
                                        new OpenFileDescriptor(project, virtualFile, line - 1, 0).navigate(true);
                                    } else {
                                        new OpenFileDescriptor(project, virtualFile).navigate(true);
                                    }
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public String getName() {
        return "text editor";
    }
}

