/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactoryImpl;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FilesystemToolwindow {
    private final VirtualFile myRoot;
    private final Project myProject;
    private final ToolWindow myToolWindow;
    private final JPanel myContent;
    private final FileSystemTree myFsTree;

    public FilesystemToolwindow(VirtualFile root, Project project) {
        this.myRoot = root;
        this.myProject = project;
        this.myToolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow("File System", false, ToolWindowAnchor.LEFT);
        this.myContent = new MyContent();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, false, true, true);
        descriptor.setRoots(new VirtualFile[]{this.myRoot});
        this.myFsTree = new FileSystemTreeImpl(project, descriptor);
        this.myContent.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myFsTree.getTree()), "Center");
        EditSourceOnDoubleClickHandler.install((JTree)this.myFsTree.getTree());
        EditSourceOnEnterKeyHandler.install((JTree)this.myFsTree.getTree());
        ContentFactoryImpl contentFactory = new ContentFactoryImpl();
        Content content = contentFactory.createContent(this.myContent, null, false);
        this.myToolWindow.getContentManager().addContent(content);
    }

    private class MyContent
    extends JPanel
    implements DataProvider {
        public MyContent() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                VirtualFile file = FilesystemToolwindow.this.myFsTree.getSelectedFile();
                if (file != null) {
                    return new OpenFileDescriptor(FilesystemToolwindow.this.myProject, file);
                }
            } else if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return FilesystemToolwindow.this.myFsTree.getSelectedFile();
            }
            return null;
        }
    }
}

