/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.peer.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VcsContextFactoryImpl
implements VcsContextFactory {
    public VcsContext createCachedContextOn(AnActionEvent event) {
        return VcsContextWrapper.createCachedInstanceOn(event);
    }

    public VcsContext createContextOn(AnActionEvent event) {
        return new VcsContextWrapper(event.getDataContext(), event.getModifiers(), event.getPlace(), event.getPresentation().getText());
    }

    public FilePath createFilePathOn(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOn"));
        }
        return new FilePathImpl(virtualFile);
    }

    public FilePath createFilePathOn(File file) {
        return FilePathImpl.create(file);
    }

    public FilePath createFilePathOn(File file, NotNullFunction<File, Boolean> detector) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (virtualFile != null) {
            return FilePathImpl.create(file);
        }
        return FilePathImpl.create(file, (Boolean)detector.fun((Object)file));
    }

    public FilePath createFilePathOn(File file, boolean isDirectory) {
        return FilePathImpl.create(file, isDirectory);
    }

    @NotNull
    public FilePath createFilePathOnNonLocal(String path, boolean isDirectory) {
        FilePath filePath = FilePathImpl.createNonLocal(path, isDirectory);
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/peer/impl/VcsContextFactoryImpl", "createFilePathOnNonLocal"));
        }
        return filePath;
    }

    public FilePath createFilePathOnDeleted(File file, boolean isDirectory) {
        return FilePathImpl.createForDeletedFile(file, isDirectory);
    }

    public FilePath createFilePathOn(VirtualFile parent, String name) {
        return new FilePathImpl(parent, name, false);
    }

    public LocalChangeList createLocalChangeList(Project project, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/peer/impl/VcsContextFactoryImpl", "createLocalChangeList"));
        }
        return LocalChangeListImpl.createEmptyChangeListImpl(project, name);
    }
}

