/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElementBase;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.ui.DelegatedPackagingElementPresentation;
import com.intellij.packaging.impl.ui.ModuleElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class ProductionModuleOutputPackagingElement
extends ModuleOutputPackagingElementBase {
    public ProductionModuleOutputPackagingElement(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ProductionModuleOutputPackagingElement", "<init>"));
        }
        super(ProductionModuleOutputElementType.ELEMENT_TYPE, project);
    }

    public ProductionModuleOutputPackagingElement(@NotNull Project project, @NotNull ModulePointer modulePointer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ProductionModuleOutputPackagingElement", "<init>"));
        }
        if (modulePointer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/ProductionModuleOutputPackagingElement", "<init>"));
        }
        super(ProductionModuleOutputElementType.ELEMENT_TYPE, project, modulePointer);
    }

    @NonNls
    public String toString() {
        return "module:" + this.getModuleName();
    }

    @Override
    protected String getModuleOutputAntProperty(ArtifactAntGenerationContext generationContext) {
        return generationContext.getModuleOutputPath(this.myModulePointer.getModuleName());
    }

    @Override
    protected VirtualFile getModuleOutputPath(CompilerModuleExtension extension) {
        return extension.getCompilerOutputPath();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots(PackagingElementResolvingContext context) {
        Module module = this.findModule(context);
        if (module == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ProductionModuleOutputPackagingElement", "getSourceRoots"));
            }
            return list;
        }
        ModuleRootModel rootModel = context.getModulesProvider().getRootModel(module);
        List list = rootModel.getSourceRoots(JavaModuleSourceRootTypes.PRODUCTION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ProductionModuleOutputPackagingElement", "getSourceRoots"));
        }
        return list;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ProductionModuleOutputPackagingElement", "createPresentation"));
        }
        return new DelegatedPackagingElementPresentation(new ModuleElementPresentation(this.myModulePointer, context, false));
    }
}

