/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElementBase;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleOutputElementTypeBase<E extends ModuleOutputPackagingElementBase>
extends PackagingElementType<E> {
    public ModuleOutputElementTypeBase(String id, String presentableName) {
        super(id, presentableName);
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ModuleOutputElementTypeBase", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/ModuleOutputElementTypeBase", "canCreate"));
        }
        return !this.getSuitableModules(context).isEmpty();
    }

    @NotNull
    public List<? extends PackagingElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ModuleOutputElementTypeBase", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/ModuleOutputElementTypeBase", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/impl/elements/ModuleOutputElementTypeBase", "chooseAndCreate"));
        }
        List<Module> suitableModules = this.getSuitableModules(context);
        List selected = context.chooseModules(suitableModules, ProjectBundle.message((String)"dialog.title.packaging.choose.module", (Object[])new Object[0]));
        ArrayList<ModuleOutputPackagingElementBase> elements = new ArrayList<ModuleOutputPackagingElementBase>();
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)context.getProject());
        for (Module module : selected) {
            elements.add(this.createElement(context.getProject(), pointerManager.create(module)));
        }
        ArrayList<ModuleOutputPackagingElementBase> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ModuleOutputElementTypeBase", "chooseAndCreate"));
        }
        return arrayList;
    }

    protected abstract ModuleOutputPackagingElementBase createElement(@NotNull Project var1, @NotNull ModulePointer var2);

    private List<Module> getSuitableModules(ArtifactEditorContext context) {
        ModulesProvider modulesProvider = context.getModulesProvider();
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : modulesProvider.getModules()) {
            if (!this.isSuitableModule(modulesProvider, module)) continue;
            modules.add(module);
        }
        return modules;
    }

    public abstract boolean isSuitableModule(ModulesProvider var1, Module var2);
}

