/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.artifacts.ArchiveAntCopyInstructionCreator;
import com.intellij.compiler.ant.taskdefs.Jar;
import com.intellij.compiler.ant.taskdefs.Zip;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ArchiveElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArchivePackagingElement
extends CompositeElementWithManifest<ArchivePackagingElement> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    private String myArchiveFileName;

    public ArchivePackagingElement() {
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
    }

    public ArchivePackagingElement(@NotNull String archiveFileName) {
        if (archiveFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "<init>"));
        }
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
        this.myArchiveFileName = archiveFileName;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "createPresentation"));
        }
        return new ArchiveElementPresentation(this);
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeAntInstructions"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeAntInstructions"));
        }
        if (generationContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeAntInstructions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeAntInstructions"));
        }
        String tempJarProperty = generationContext.createNewTempFileProperty("temp.jar.path." + this.myArchiveFileName, this.myArchiveFileName);
        String jarPath = BuildProperties.propertyRef((String)tempJarProperty);
        Object jar = this.myArchiveFileName.endsWith(".jar") ? new Jar(jarPath, "preserve", true) : new Zip(jarPath);
        for (Generator generator : this.computeChildrenGenerators(resolvingContext, new ArchiveAntCopyInstructionCreator(""), generationContext, artifactType)) {
            jar.add(generator);
        }
        generationContext.runBeforeCurrentArtifact((Generator)jar);
        return Collections.singletonList(creator.createFileCopyInstruction(jarPath, this.myArchiveFileName));
    }

    public void computeIncrementalCompilerInstructions(@NotNull IncrementalCompilerInstructionCreator creator, @NotNull PackagingElementResolvingContext resolvingContext, @NotNull ArtifactIncrementalCompilerContext compilerContext, @NotNull ArtifactType artifactType) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeIncrementalCompilerInstructions"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeIncrementalCompilerInstructions"));
        }
        if (compilerContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeIncrementalCompilerInstructions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "computeIncrementalCompilerInstructions"));
        }
        this.computeChildrenInstructions(creator.archive(this.myArchiveFileName), resolvingContext, compilerContext, artifactType);
    }

    @Attribute(value="name")
    public String getArchiveFileName() {
        return this.myArchiveFileName;
    }

    @NonNls
    public String toString() {
        return "archive:" + this.myArchiveFileName;
    }

    public ArchivePackagingElement getState() {
        return this;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.myArchiveFileName = archiveFileName;
    }

    public String getName() {
        return this.myArchiveFileName;
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "rename"));
        }
        this.myArchiveFileName = newName;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/elements/ArchivePackagingElement", "isEqualTo"));
        }
        return element instanceof ArchivePackagingElement && ((ArchivePackagingElement)element).getArchiveFileName().equals(this.myArchiveFileName);
    }

    public void loadState(ArchivePackagingElement state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }
}

