/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingFileFilter;
import com.intellij.packaging.impl.compiler.ArtifactsProcessingItemsBuilderContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncrementalCompilerInstructionCreatorBase
implements IncrementalCompilerInstructionCreator {
    protected final ArtifactsProcessingItemsBuilderContext myContext;

    public IncrementalCompilerInstructionCreatorBase(ArtifactsProcessingItemsBuilderContext context) {
        this.myContext = context;
    }

    public void addDirectoryCopyInstructions(@NotNull VirtualFile directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/IncrementalCompilerInstructionCreatorBase", "addDirectoryCopyInstructions"));
        }
        this.addDirectoryCopyInstructions(directory, null);
    }

    public void addDirectoryCopyInstructions(@NotNull VirtualFile directory, @Nullable PackagingFileFilter filter) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/IncrementalCompilerInstructionCreatorBase", "addDirectoryCopyInstructions"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myContext.getCompileContext().getProject()).getFileIndex();
        boolean copyExcluded = index.isIgnored(directory);
        IncrementalCompilerInstructionCreatorBase.collectInstructionsRecursively(directory, this, filter, index, copyExcluded);
    }

    private static void collectInstructionsRecursively(VirtualFile directory, final IncrementalCompilerInstructionCreatorBase creator, final @Nullable PackagingFileFilter filter, final ProjectFileIndex index, final boolean copyExcluded) {
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)directory, (VirtualFileVisitor)new VirtualFileVisitor<IncrementalCompilerInstructionCreatorBase>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){
            {
                super(x0);
                this.setValueForChildren(creator);
            }

            public boolean visitFile(@NotNull VirtualFile child) {
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/IncrementalCompilerInstructionCreatorBase$1", "visitFile"));
                }
                if (copyExcluded ? fileTypeManager.isFileIgnored(child) : index.isIgnored(child)) {
                    return false;
                }
                IncrementalCompilerInstructionCreatorBase creator2 = (IncrementalCompilerInstructionCreatorBase)this.getCurrentValue();
                if (filter != null && !filter.accept(child, creator2.myContext.getCompileContext())) {
                    return false;
                }
                if (!child.isDirectory()) {
                    creator2.addFileCopyInstruction(child, child.getName());
                } else {
                    this.setValueForChildren(creator2.subFolder(child.getName()));
                }
                return true;
            }
        });
    }

    public abstract IncrementalCompilerInstructionCreatorBase subFolder(@NotNull String var1);

    public IncrementalCompilerInstructionCreator subFolderByRelativePath(@NotNull String relativeDirectoryPath) {
        if (relativeDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/IncrementalCompilerInstructionCreatorBase", "subFolderByRelativePath"));
        }
        List folders = StringUtil.split((String)relativeDirectoryPath, (String)"/");
        IncrementalCompilerInstructionCreatorBase current = this;
        for (String folder : folders) {
            current = current.subFolder(folder);
        }
        return current;
    }
}

