/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.openapi.compiler.generic.VirtualFileCompileItem;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.compiler.ArtifactPackagingItemExternalizer;
import com.intellij.packaging.impl.compiler.ArtifactPackagingItemOutputState;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactCompilerCompileItem
extends VirtualFileCompileItem<ArtifactPackagingItemOutputState> {
    public static final DataExternalizer<ArtifactPackagingItemOutputState> OUTPUT_EXTERNALIZER = new ArtifactPackagingItemExternalizer();
    private final List<DestinationInfo> myDestinations = new SmartList();

    public ArtifactCompilerCompileItem(VirtualFile file) {
        super(file);
    }

    public void addDestination(DestinationInfo info) {
        this.myDestinations.add(info);
    }

    public List<DestinationInfo> getDestinations() {
        return this.myDestinations;
    }

    @Override
    @NotNull
    public ArtifactPackagingItemOutputState computeOutputState() {
        SmartList pairs = new SmartList();
        for (DestinationInfo destination : this.myDestinations) {
            destination.update();
            VirtualFile outputFile = destination.getOutputFile();
            long timestamp = outputFile != null ? outputFile.getTimeStamp() : -1L;
            pairs.add((Object)Pair.create((Object)destination.getOutputPath(), (Object)timestamp));
        }
        ArtifactPackagingItemOutputState artifactPackagingItemOutputState = new ArtifactPackagingItemOutputState((SmartList<Pair<String, Long>>)pairs);
        if (artifactPackagingItemOutputState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactCompilerCompileItem", "computeOutputState"));
        }
        return artifactPackagingItemOutputState;
    }

    @Override
    public boolean isOutputUpToDate(@NotNull ArtifactPackagingItemOutputState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/compiler/ArtifactCompilerCompileItem", "isOutputUpToDate"));
        }
        SmartList<Pair<String, Long>> cachedDestinations = state.myDestinations;
        if (cachedDestinations.size() != this.myDestinations.size()) {
            return false;
        }
        for (DestinationInfo info : this.myDestinations) {
            VirtualFile outputFile = info.getOutputFile();
            long timestamp = outputFile != null ? outputFile.getTimeStamp() : -1L;
            String path = info.getOutputPath();
            boolean found = false;
            for (Pair cachedDestination : cachedDestinations) {
                if (!((String)cachedDestination.first).equals(path)) continue;
                if ((Long)cachedDestination.second != timestamp) {
                    return false;
                }
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

