/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultManifestFileProvider
implements ManifestFileProvider {
    private final PackagingElementResolvingContext myContext;

    public DefaultManifestFileProvider(PackagingElementResolvingContext context) {
        this.myContext = context;
    }

    public List<String> getClasspathFromManifest(@NotNull CompositePackagingElement<?> archiveRoot, @NotNull ArtifactType artifactType) {
        if (archiveRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/impl/artifacts/DefaultManifestFileProvider", "getClasspathFromManifest"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/impl/artifacts/DefaultManifestFileProvider", "getClasspathFromManifest"));
        }
        VirtualFile manifestFile = ManifestFileUtil.findManifestFile(archiveRoot, this.myContext, artifactType);
        if (manifestFile == null) {
            return null;
        }
        ManifestFileConfiguration configuration = ManifestFileUtil.createManifestFileConfiguration(manifestFile);
        return configuration.getClasspath();
    }
}

