/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import org.jetbrains.annotations.NotNull;

public class RefactoringScopeElementListenerProvider
implements RefactoringElementListenerProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + RefactoringScopeElementListenerProvider.class.getName()));

    public RefactoringElementListener getListener(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (!(element instanceof PsiQualifiedNamedElement)) {
            return null;
        }
        String oldName = ((PsiQualifiedNamedElement)element).getQualifiedName();
        RefactoringElementListenerComposite composite = null;
        for (NamedScopesHolder holder : NamedScopeManager.getAllNamedScopeHolders((Project)element.getProject())) {
            NamedScope[] scopes = holder.getEditableScopes();
            for (int i = 0; i < scopes.length; ++i) {
                NamedScope scope = scopes[i];
                PackageSet packageSet = scope.getValue();
                if (packageSet == null || containingFile != null && !packageSet.contains(containingFile, holder)) continue;
                composite = RefactoringScopeElementListenerProvider.traverse(new OldScopeDescriptor(oldName, scope, i, holder), composite, packageSet);
            }
        }
        return composite;
    }

    private static RefactoringElementListenerComposite traverse(OldScopeDescriptor scopeDescriptor, RefactoringElementListenerComposite composite, PackageSet packageSet) {
        if (packageSet instanceof PatternBasedPackageSet) {
            composite = RefactoringScopeElementListenerProvider.checkPatternPackageSet(scopeDescriptor, composite, (PatternBasedPackageSet)packageSet, scopeDescriptor.getScope().getValue().getText());
        } else if (packageSet instanceof ComplementPackageSet) {
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((ComplementPackageSet)packageSet).getComplementarySet());
        } else if (packageSet instanceof UnionPackageSet) {
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((UnionPackageSet)packageSet).getFirstSet());
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((UnionPackageSet)packageSet).getSecondSet());
        } else if (packageSet instanceof IntersectionPackageSet) {
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((IntersectionPackageSet)packageSet).getFirstSet());
            composite = RefactoringScopeElementListenerProvider.traverse(scopeDescriptor, composite, ((IntersectionPackageSet)packageSet).getSecondSet());
        }
        return composite;
    }

    private static RefactoringElementListenerComposite checkPatternPackageSet(final OldScopeDescriptor descriptor, RefactoringElementListenerComposite composite, PatternBasedPackageSet pattern, final String text) {
        if (pattern.isOn(descriptor.getOldQName())) {
            if (composite == null) {
                composite = new RefactoringElementListenerComposite();
            }
            composite.addListener((RefactoringElementListener)new RefactoringElementAdapter(){

                public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packageDependencies/ui/RefactoringScopeElementListenerProvider$1", "elementRenamedOrMoved"));
                    }
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement);
                    try {
                        String newPattern = text.replace(descriptor.getOldQName(), ((PsiQualifiedNamedElement)newElement).getQualifiedName());
                        PackageSet newSet = PackageSetFactory.getInstance().compile(newPattern);
                        NamedScope newScope = new NamedScope(descriptor.getScope().getName(), newSet);
                        NamedScope[] currentScopes = descriptor.getHolder().getEditableScopes();
                        currentScopes[descriptor.getIdx()] = newScope;
                        descriptor.getHolder().setScopes(currentScopes);
                    }
                    catch (ParsingException parsingException) {
                        // empty catch block
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packageDependencies/ui/RefactoringScopeElementListenerProvider$1", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packageDependencies/ui/RefactoringScopeElementListenerProvider$1", "undoElementMovedOrRenamed"));
                    }
                    LOG.assertTrue(newElement instanceof PsiQualifiedNamedElement);
                    try {
                        NamedScope newScope;
                        NamedScope[] currentScopes = descriptor.getHolder().getEditableScopes();
                        String oldPattern = ((PatternBasedPackageSet)currentScopes[descriptor.getIdx()].getValue()).getPattern().replace(((PsiQualifiedNamedElement)newElement).getQualifiedName(), oldQualifiedName);
                        PackageSet newSet = PackageSetFactory.getInstance().compile(oldPattern);
                        currentScopes[descriptor.getIdx()] = newScope = new NamedScope(descriptor.getScope().getName(), newSet);
                        descriptor.getHolder().setScopes(currentScopes);
                    }
                    catch (ParsingException parsingException) {
                        // empty catch block
                    }
                }
            });
        }
        return composite;
    }

    private static class OldScopeDescriptor {
        private final String myOldQName;
        private final NamedScopesHolder myHolder;
        private final int myIdx;
        private final NamedScope myScope;

        private OldScopeDescriptor(String oldQName, NamedScope scope, int idx, NamedScopesHolder holder) {
            this.myOldQName = oldQName;
            this.myHolder = holder;
            this.myIdx = idx;
            this.myScope = scope;
        }

        public String getOldQName() {
            return this.myOldQName;
        }

        public NamedScopesHolder getHolder() {
            return this.myHolder;
        }

        public int getIdx() {
            return this.myIdx;
        }

        public NamedScope getScope() {
            return this.myScope;
        }
    }
}

