/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPatternProvider
extends PatternDialectProvider {
    @NonNls
    public static final String FILE = "file";
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectPatternProvider.class.getName()));

    @Override
    public TreeModel createTreeModel(Project project, Marker marker) {
        return FileTreeModelBuilder.createTreeModel(project, false, marker);
    }

    @Override
    public TreeModel createTreeModel(Project project, Set<PsiFile> deps, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return FileTreeModelBuilder.createTreeModel(project, false, deps, marker, settings);
    }

    @Override
    public String getDisplayName() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getShortName() {
        if (FILE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/ProjectPatternProvider", "getShortName"));
        }
        return FILE;
    }

    @Override
    public AnAction[] createActions(Project project, Runnable update) {
        if (ProjectViewDirectoryHelper.getInstance(project).supportsHideEmptyMiddlePackages()) {
            return new AnAction[]{new CompactEmptyMiddlePackagesAction(update)};
        }
        return AnAction.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PackageSet createPackageSet(PackageDependenciesNode node, boolean recursively) {
        if (node instanceof ModuleGroupNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = "group:" + ((ModuleGroupNode)node).getModuleGroup().toString();
            return new FilePatternPackageSet(modulePattern, "*//*");
        }
        if (node instanceof ModuleNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = ((ModuleNode)node).getModuleName();
            return new FilePatternPackageSet(modulePattern, "*/");
        }
        if (node instanceof DirectoryNode) {
            String pattern = ((DirectoryNode)node).getFQName();
            if (pattern != null) {
                pattern = pattern.length() > 0 ? pattern + (recursively ? "//*" : "/*") : pattern + (recursively ? "*/" : "*");
            }
            return new FilePatternPackageSet(ProjectPatternProvider.getModulePattern(node), pattern);
        }
        if (node instanceof FileNode) {
            if (recursively) {
                return null;
            }
            FileNode fNode = (FileNode)node;
            PsiFile file = (PsiFile)fNode.getPsiElement();
            if (file == null) {
                return null;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            VirtualFile contentRoot = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex().getContentRootForFile(virtualFile);
            if (contentRoot == null) {
                return null;
            }
            String fqName = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRoot, (char)'/');
            if (fqName != null) {
                return new FilePatternPackageSet(ProjectPatternProvider.getModulePattern(node), fqName);
            }
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.ProjectTab;
    }

    private static final class CompactEmptyMiddlePackagesAction
    extends ToggleAction {
        private final Runnable myUpdate;

        CompactEmptyMiddlePackagesAction(Runnable update) {
            super(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), AllIcons.ObjectBrowser.CompactEmptyPackages);
            this.myUpdate = update;
        }

        public boolean isSelected(AnActionEvent event) {
            return DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES = flag;
            this.myUpdate.run();
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(DependencyUISettings.getInstance().SCOPE_TYPE == ProjectPatternProvider.FILE);
        }
    }
}

