/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.packageDependencies.actions.DependenciesHandlerBase;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnalyzeDependenciesOnSpecifiedTargetHandler
extends DependenciesHandlerBase {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Dependencies", (String)ToolWindowId.DEPENDENCIES, (boolean)true);
    private final GlobalSearchScope myTargetScope;

    public AnalyzeDependenciesOnSpecifiedTargetHandler(@NotNull Project project, @NotNull AnalysisScope scope, @NotNull GlobalSearchScope targetScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packageDependencies/actions/AnalyzeDependenciesOnSpecifiedTargetHandler", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packageDependencies/actions/AnalyzeDependenciesOnSpecifiedTargetHandler", "<init>"));
        }
        if (targetScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packageDependencies/actions/AnalyzeDependenciesOnSpecifiedTargetHandler", "<init>"));
        }
        super(project, Collections.singletonList(scope), Collections.<PsiFile>emptySet());
        this.myTargetScope = targetScope;
    }

    @Override
    protected String getProgressTitle() {
        return AnalysisScopeBundle.message((String)"package.dependencies.progress.title", (Object[])new Object[0]);
    }

    @Override
    protected String getPanelDisplayName(AnalysisScope scope) {
        return AnalysisScopeBundle.message((String)"package.dependencies.on.toolwindow.title", (Object[])new Object[]{scope.getDisplayName(), this.myTargetScope.getDisplayName()});
    }

    @Override
    protected boolean shouldShowDependenciesPanel(List<DependenciesBuilder> builders) {
        for (DependenciesBuilder builder : builders) {
            for (Set<PsiFile> files : builder.getDependencies().values()) {
                if (files.isEmpty()) continue;
                return true;
            }
        }
        String source = StringUtil.decapitalize((String)builders.get(0).getScope().getDisplayName());
        String target = StringUtil.decapitalize((String)this.myTargetScope.getDisplayName());
        String message = AnalysisScopeBundle.message((String)"no.dependencies.found.message", (Object[])new Object[]{source, target});
        NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).notify(this.myProject);
        return false;
    }

    @Override
    protected DependenciesBuilder createDependenciesBuilder(AnalysisScope scope) {
        return new ForwardDependenciesBuilder(this.myProject, scope){

            @Override
            public void analyze() {
                super.analyze();
                Map<PsiFile, Set<PsiFile>> dependencies = this.getDependencies();
                Iterator<PsiFile> leftTreeIterator = dependencies.keySet().iterator();
                while (leftTreeIterator.hasNext()) {
                    PsiFile leftTreeFile = leftTreeIterator.next();
                    Set<PsiFile> files = dependencies.get(leftTreeFile);
                    Iterator<PsiFile> iterator = files.iterator();
                    while (iterator.hasNext()) {
                        PsiFile next = iterator.next();
                        VirtualFile virtualFile = next.getVirtualFile();
                        if (virtualFile != null && AnalyzeDependenciesOnSpecifiedTargetHandler.this.myTargetScope.contains(virtualFile)) continue;
                        iterator.remove();
                    }
                    if (!files.isEmpty()) continue;
                    leftTreeIterator.remove();
                }
            }
        };
    }
}

