/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Alarm;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class ToolWindowsWidget
extends JLabel
implements CustomStatusBarWidget,
StatusBarWidget,
Disposable,
UISettingsListener,
PropertyChangeListener {
    private final Alarm myAlarm;
    private StatusBar myStatusBar;
    private JBPopup popup;
    private boolean wasExited = false;

    ToolWindowsWidget(Disposable parent) {
        new BaseButtonBehavior(this, TimedDeadzone.NULL){

            protected void execute(MouseEvent e) {
                ToolWindowsWidget.this.performAction();
            }
        }.setActionTrigger(501);
        IdeEventQueue.getInstance().addDispatcher(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent e) {
                if (e instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)e;
                    if (mouseEvent.getComponent() == null || !SwingUtilities.isDescendingFrom(mouseEvent.getComponent(), SwingUtilities.getWindowAncestor(ToolWindowsWidget.this))) {
                        return false;
                    }
                    if (e.getID() == 503 && ToolWindowsWidget.this.isShowing()) {
                        Point p = mouseEvent.getLocationOnScreen();
                        Point screen = ToolWindowsWidget.this.getLocationOnScreen();
                        if (new Rectangle(screen.x - 4, screen.y - 2, ToolWindowsWidget.this.getWidth() + 4, ToolWindowsWidget.this.getHeight() + 4).contains(p)) {
                            ToolWindowsWidget.this.mouseEntered();
                            ToolWindowsWidget.this.wasExited = false;
                        } else if (!ToolWindowsWidget.this.wasExited) {
                            ToolWindowsWidget.this.wasExited = ToolWindowsWidget.this.mouseExited(p);
                        }
                    } else if (e.getID() == 505) {
                        ToolWindowsWidget.this.mouseExited(mouseEvent.getLocationOnScreen());
                    }
                }
                return false;
            }
        }, parent);
        UISettings.getInstance().addUISettingsListener((UISettingsListener)this, (Disposable)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        this.myAlarm = new Alarm(parent);
    }

    public boolean mouseExited(Point currentLocationOnScreen) {
        this.myAlarm.cancelAllRequests();
        if (this.popup != null && this.popup.isVisible()) {
            Point screen = this.popup.getLocationOnScreen();
            Rectangle popupScreenRect = new Rectangle(screen.x, screen.y, this.popup.getSize().width, this.popup.getSize().height);
            if (!popupScreenRect.contains(currentLocationOnScreen)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (ToolWindowsWidget.this.popup != null && ToolWindowsWidget.this.popup.isVisible()) {
                            ToolWindowsWidget.this.popup.cancel();
                        }
                    }
                }, 300);
                return true;
            }
        }
        return false;
    }

    public void mouseEntered() {
        if (this.myAlarm.getActiveRequestCount() == 0) {
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    DefaultListModel<ToolWindow> model = new DefaultListModel<ToolWindow>();
                    IdeFrameImpl frame = (IdeFrameImpl)UIUtil.getParentOfType(IdeFrameImpl.class, (Component)ToolWindowsWidget.this);
                    if (frame == null) {
                        return;
                    }
                    ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)frame.getProject());
                    for (String id : toolWindowManager.getToolWindowIds()) {
                        ToolWindow tw = toolWindowManager.getToolWindow(id);
                        if (!tw.isAvailable()) continue;
                        model.addElement(tw);
                    }
                    final JBList list = new JBList(model);
                    list.setCellRenderer(new ListCellRenderer(){
                        final JBLabel label = new JBLabel();

                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            ToolWindow toolWindow = (ToolWindow)value;
                            this.label.setText(toolWindow instanceof ToolWindowImpl ? ((ToolWindowImpl)toolWindow).getId() : toolWindow.getTitle());
                            this.label.setIcon(toolWindow.getIcon());
                            this.label.setBorder(IdeBorderFactory.createEmptyBorder((int)4, (int)10, (int)4, (int)10));
                            this.label.setForeground(UIUtil.getListForeground((boolean)isSelected));
                            this.label.setBackground(UIUtil.getListBackground((boolean)isSelected));
                            JPanel panel = new JPanel(new BorderLayout());
                            panel.add((Component)this.label, "Center");
                            panel.setBackground(UIUtil.getListBackground((boolean)isSelected));
                            return panel;
                        }
                    });
                    Dimension size = list.getPreferredSize();
                    ToolWindowsWidget c = ToolWindowsWidget.this;
                    Insets padding = UIUtil.getListViewportPadding();
                    RelativePoint point = new RelativePoint((Component)c, new Point(-4, -padding.top - padding.bottom - 4 - size.height + (SystemInfo.isMac ? 2 : 0)));
                    if (ToolWindowsWidget.this.popup != null && ToolWindowsWidget.this.popup.isVisible()) {
                        return;
                    }
                    list.setSelectedIndex(list.getItemsCount() - 1);
                    PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list);
                    ToolWindowsWidget.this.popup = builder.setAutoselectOnMouseMove(true).setRequestFocus(false).setItemChoosenCallback(new Runnable(){

                        @Override
                        public void run() {
                            Object value;
                            if (ToolWindowsWidget.this.popup != null) {
                                ToolWindowsWidget.this.popup.closeOk(null);
                            }
                            if ((value = list.getSelectedValue()) instanceof ToolWindow) {
                                ((ToolWindow)value).activate(null, true, true);
                            }
                        }
                    }).createPopup();
                    ToolWindowsWidget.this.popup.show(point);
                }
            }, 300);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        String key = "toolwindow.stripes.buttons.info.shown";
        if (UISettings.getInstance().HIDE_TOOL_STRIPES && !PropertiesComponent.getInstance().isTrueValue("toolwindow.stripes.buttons.info.shown")) {
            PropertiesComponent.getInstance().setValue("toolwindow.stripes.buttons.info.shown", String.valueOf(true));
            final Alarm alarm = new Alarm();
            alarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    GotItMessage.createMessage(UIBundle.message((String)"tool.window.quick.access.title", (Object[])new Object[0]), UIBundle.message((String)"tool.window.quick.access.message", (Object[])new Object[0])).setDisposable(ToolWindowsWidget.this).show(new RelativePoint((Component)ToolWindowsWidget.this, new Point(10, 0)), Balloon.Position.above);
                    Disposer.dispose((Disposable)alarm);
                }
            }, 20000);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateIcon();
    }

    public void uiSettingsChanged(UISettings source) {
        this.updateIcon();
    }

    private void performAction() {
        if (this.isActive()) {
            UISettings.getInstance().HIDE_TOOL_STRIPES = !UISettings.getInstance().HIDE_TOOL_STRIPES;
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private void updateIcon() {
        this.setToolTipText(null);
        if (this.isActive()) {
            Icon icon;
            boolean changes = false;
            if (!this.isVisible()) {
                this.setVisible(true);
                changes = true;
            }
            Icon icon2 = icon = UISettings.getInstance().HIDE_TOOL_STRIPES ? AllIcons.General.TbShown : AllIcons.General.TbHidden;
            if (icon != this.getIcon()) {
                this.setIcon(icon);
                changes = true;
            }
            if (changes) {
                this.revalidate();
                this.repaint();
            }
        } else {
            this.setVisible(false);
            this.setToolTipText(null);
        }
    }

    private boolean isActive() {
        return this.myStatusBar != null && this.myStatusBar.getFrame() != null && this.myStatusBar.getFrame().getProject() != null && Registry.is((String)"ide.windowSystem.showTooWindowButtonsSwitcher");
    }

    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public String ID() {
        if ("ToolWindows Widget" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/ToolWindowsWidget", "ID"));
        }
        return "ToolWindows Widget";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/ToolWindowsWidget", "getPresentation"));
        }
        return null;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/ToolWindowsWidget", "install"));
        }
        this.myStatusBar = statusBar;
        this.updateIcon();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
        this.myStatusBar = null;
        this.popup = null;
    }
}

