/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TogglePopupHintsPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    private Icon myCurrentIcon;
    private String myToolTipText;

    public TogglePopupHintsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "<init>"));
        }
        super(project);
        this.myCurrentIcon = AllIcons.Ide.HectorNo;
        this.myConnection.subscribe(PowerSaveMode.TOPIC, (Object)new PowerSaveMode.Listener(){

            @Override
            public void powerSaveStateChanged() {
                TogglePopupHintsPanel.this.updateStatus();
            }
        });
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "selectionChanged"));
        }
        this.updateStatus();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "fileOpened"));
        }
        this.updateStatus();
    }

    public StatusBarWidget copy() {
        return new TogglePopupHintsPanel(this.getProject());
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myCurrentIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "getIcon"));
        }
        return icon;
    }

    public String getTooltipText() {
        return this.myToolTipText;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent e) {
                Point point = new Point(0, 0);
                PsiFile file = TogglePopupHintsPanel.this.getCurrentFile();
                if (file != null) {
                    if (!DaemonCodeAnalyzer.getInstance((Project)file.getProject()).isHighlightingAvailable(file)) {
                        return;
                    }
                    HectorComponent component = new HectorComponent(file);
                    Dimension dimension = component.getPreferredSize();
                    point = new Point(point.x - dimension.width, point.y - dimension.height);
                    component.showComponent(new RelativePoint(e.getComponent(), point));
                }
            }
        };
    }

    @NotNull
    public String ID() {
        if ("InspectionProfile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "ID"));
        }
        return "InspectionProfile";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel", "getPresentation"));
        }
        return this;
    }

    public void clear() {
        this.myCurrentIcon = AllIcons.Ide.HectorNo;
        this.myToolTipText = null;
        this.myStatusBar.updateWidget(this.ID());
    }

    public void updateStatus() {
        this.updateStatus(this.getCurrentFile());
    }

    private void updateStatus(PsiFile file) {
        if (TogglePopupHintsPanel.isStateChangeable(file)) {
            if (PowerSaveMode.isEnabled()) {
                this.myCurrentIcon = AllIcons.Ide.HectorNo;
                this.myToolTipText = "Code analysis is disabled in power save mode. ";
            } else if (HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)file)) {
                this.myCurrentIcon = AllIcons.Ide.HectorOn;
                this.myToolTipText = "Current inspection profile: " + InspectionProjectProfileManager.getInstance(file.getProject()).getInspectionProfile().getName() + ". ";
            } else if (HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)file)) {
                this.myCurrentIcon = AllIcons.Ide.HectorSyntax;
                this.myToolTipText = "Highlighting level is: Syntax. ";
            } else {
                this.myCurrentIcon = AllIcons.Ide.HectorOff;
                this.myToolTipText = "Inspections are off. ";
            }
            this.myToolTipText = this.myToolTipText + UIBundle.message((String)"popup.hints.panel.click.to.configure.highlighting.tooltip.text", (Object[])new Object[0]);
        } else {
            this.myCurrentIcon = AllIcons.Ide.HectorNo;
            this.myToolTipText = null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private static boolean isStateChangeable(PsiFile file) {
        return file != null && DaemonCodeAnalyzer.getInstance((Project)file.getProject()).isHighlightingAvailable(file);
    }

    @Nullable
    private PsiFile getCurrentFile() {
        VirtualFile virtualFile = this.getSelectedFile();
        if (virtualFile != null && virtualFile.isValid()) {
            return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
        }
        return null;
    }
}

