/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.FadeInFadeOut;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public final class ToolWindowsPane
extends JBLayeredPane
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowsPane");
    private final IdeFrameImpl myFrame;
    private final HashMap<String, StripeButton> myId2Button;
    private final HashMap<String, InternalDecorator> myId2Decorator;
    private final HashMap<StripeButton, WindowInfoImpl> myButton2Info;
    private final HashMap<InternalDecorator, WindowInfoImpl> myDecorator2Info;
    private final HashMap<String, Float> myId2SplitProportion;
    private final MyLayeredPane myLayeredPane;
    private final ThreeComponentsSplitter myVerticalSplitter;
    private final ThreeComponentsSplitter myHorizontalSplitter;
    private final Stripe myLeftStripe;
    private final Stripe myRightStripe;
    private final Stripe myBottomStripe;
    private final Stripe myTopStripe;
    private final ArrayList<Stripe> myStripes = new ArrayList();
    private final MyUISettingsListenerImpl myUISettingsListener;
    private final ToolWindowManagerImpl myManager;
    private boolean myStripesOverlayed;
    private final Disposable myDisposable = Disposer.newDisposable();
    private boolean myWidescreen = false;
    private boolean myLeftHorizontalSplit = false;
    private boolean myRightHorizontalSplit = false;

    ToolWindowsPane(IdeFrameImpl frame, ToolWindowManagerImpl manager) {
        this.myManager = manager;
        this.setOpaque(false);
        this.myFrame = frame;
        this.myId2Button = new HashMap();
        this.myId2Decorator = new HashMap();
        this.myButton2Info = new HashMap();
        this.myDecorator2Info = new HashMap();
        this.myUISettingsListener = new MyUISettingsListenerImpl();
        this.myId2SplitProportion = new HashMap();
        this.myVerticalSplitter = new ThreeComponentsSplitter(true);
        Disposer.register((Disposable)this, (Disposable)this.myVerticalSplitter);
        this.myVerticalSplitter.setDividerWidth(0);
        this.myVerticalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myVerticalSplitter.setBackground(Color.gray);
        this.myHorizontalSplitter = new ThreeComponentsSplitter(false);
        Disposer.register((Disposable)this, (Disposable)this.myHorizontalSplitter);
        this.myHorizontalSplitter.setDividerWidth(0);
        this.myHorizontalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myHorizontalSplitter.setBackground(Color.gray);
        this.myWidescreen = UISettings.getInstance().WIDESCREEN_SUPPORT;
        this.myLeftHorizontalSplit = UISettings.getInstance().LEFT_HORIZONTAL_SPLIT;
        this.myRightHorizontalSplit = UISettings.getInstance().RIGHT_HORIZONTAL_SPLIT;
        if (this.myWidescreen) {
            this.myHorizontalSplitter.setInnerComponent((JComponent)this.myVerticalSplitter);
        } else {
            this.myVerticalSplitter.setInnerComponent((JComponent)this.myHorizontalSplitter);
        }
        this.myTopStripe = new Stripe(1, manager);
        this.myStripes.add(this.myTopStripe);
        this.myLeftStripe = new Stripe(2, manager);
        this.myStripes.add(this.myLeftStripe);
        this.myBottomStripe = new Stripe(3, manager);
        this.myStripes.add(this.myBottomStripe);
        this.myRightStripe = new Stripe(4, manager);
        this.myStripes.add(this.myRightStripe);
        this.updateToolStripesVisibility();
        this.myLayeredPane = new MyLayeredPane((JComponent)(this.myWidescreen ? this.myHorizontalSplitter : this.myVerticalSplitter));
        this.add(this.myTopStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myLeftStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myBottomStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myRightStripe, JLayeredPane.POPUP_LAYER);
        this.add((Component)((Object)this.myLayeredPane), JLayeredPane.DEFAULT_LAYER);
    }

    public void doLayout() {
        Dimension size = this.getSize();
        if (!this.myTopStripe.isVisible()) {
            this.myTopStripe.setBounds(0, 0, 0, 0);
            this.myBottomStripe.setBounds(0, 0, 0, 0);
            this.myLeftStripe.setBounds(0, 0, 0, 0);
            this.myRightStripe.setBounds(0, 0, 0, 0);
            this.myLayeredPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        } else {
            Dimension topSize = this.myTopStripe.getPreferredSize();
            Dimension bottomSize = this.myBottomStripe.getPreferredSize();
            Dimension leftSize = this.myLeftStripe.getPreferredSize();
            Dimension rightSize = this.myRightStripe.getPreferredSize();
            this.myTopStripe.setBounds(0, 0, size.width, topSize.height);
            this.myLeftStripe.setBounds(0, topSize.height, leftSize.width, size.height - topSize.height - bottomSize.height);
            this.myRightStripe.setBounds(size.width - rightSize.width, topSize.height, rightSize.width, size.height - topSize.height - bottomSize.height);
            this.myBottomStripe.setBounds(0, size.height - bottomSize.height, size.width, bottomSize.height);
            if (UISettings.getInstance().HIDE_TOOL_STRIPES || UISettings.getInstance().PRESENTATION_MODE) {
                this.myLayeredPane.setBounds(0, 0, size.width, size.height);
            } else {
                this.myLayeredPane.setBounds(leftSize.width, topSize.height, size.width - leftSize.width - rightSize.width, size.height - topSize.height - bottomSize.height);
            }
        }
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public final void addNotify() {
        super.addNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
            UISettings.getInstance().addUISettingsListener((UISettingsListener)this.myUISettingsListener, this.myDisposable);
        }
    }

    public final void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
        super.removeNotify();
    }

    public Project getProject() {
        return this.myFrame.getProject();
    }

    final FinalizableCommand createAddButtonCmd(StripeButton button, WindowInfoImpl info, Comparator<StripeButton> comparator, Runnable finishCallBack) {
        WindowInfoImpl copiedInfo = info.copy();
        this.myId2Button.put((Object)copiedInfo.getId(), (Object)button);
        this.myButton2Info.put((Object)button, (Object)copiedInfo);
        return new AddToolStripeButtonCmd(button, copiedInfo, comparator, finishCallBack);
    }

    final FinalizableCommand createAddDecoratorCmd(InternalDecorator decorator, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
        WindowInfoImpl copiedInfo = info.copy();
        String id = copiedInfo.getId();
        this.myDecorator2Info.put((Object)decorator, (Object)copiedInfo);
        this.myId2Decorator.put((Object)id, (Object)decorator);
        if (info.isDocked()) {
            WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
            if (sideInfo == null) {
                return new AddDockedComponentCmd(decorator, info, dirtyMode, finishCallBack);
            }
            return new AddAndSplitDockedComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        if (info.isSliding()) {
            return new AddSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        throw new IllegalArgumentException("Unknown window type: " + info.getType());
    }

    final FinalizableCommand createRemoveButtonCmd(String id, Runnable finishCallBack) {
        StripeButton button = this.getButtonById(id);
        WindowInfoImpl info = this.getButtonInfoById(id);
        this.myButton2Info.remove((Object)button);
        this.myId2Button.remove((Object)id);
        return new RemoveToolStripeButtonCmd(button, info, finishCallBack);
    }

    final FinalizableCommand createRemoveDecoratorCmd(String id, boolean dirtyMode, Runnable finishCallBack) {
        Component decorator = this.getDecoratorById(id);
        WindowInfoImpl info = this.getDecoratorInfoById(id);
        this.myDecorator2Info.remove((Object)decorator);
        this.myId2Decorator.remove((Object)id);
        WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
        if (info.isDocked()) {
            if (sideInfo == null) {
                return new RemoveDockedComponentCmd(info, dirtyMode, finishCallBack);
            }
            return new RemoveSplitAndDockedComponentCmd(info, dirtyMode, finishCallBack);
        }
        if (info.isSliding()) {
            return new RemoveSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
        }
        throw new IllegalArgumentException("Unknown window type");
    }

    final FinalizableCommand createSetEditorComponentCmd(JComponent component, Runnable finishCallBack) {
        return new SetEditorComponentCmd(component, finishCallBack);
    }

    final FinalizableCommand createUpdateButtonPositionCmd(String id, Runnable finishCallback) {
        return new UpdateButtonPositionCmd(id, finishCallback);
    }

    final JComponent getMyLayeredPane() {
        return this.myLayeredPane;
    }

    private StripeButton getButtonById(String id) {
        return (StripeButton)this.myId2Button.get((Object)id);
    }

    private Component getDecoratorById(String id) {
        return (Component)this.myId2Decorator.get((Object)id);
    }

    private WindowInfoImpl getButtonInfoById(String id) {
        return (WindowInfoImpl)this.myButton2Info.get(this.myId2Button.get((Object)id));
    }

    private WindowInfoImpl getDecoratorInfoById(String id) {
        return (WindowInfoImpl)this.myDecorator2Info.get(this.myId2Decorator.get((Object)id));
    }

    private void setComponent(JComponent component, ToolWindowAnchor anchor, float weight) {
        if (ToolWindowAnchor.TOP == anchor) {
            this.myVerticalSplitter.setFirstComponent(component);
            this.myVerticalSplitter.setFirstSize((int)((float)this.myLayeredPane.getHeight() * weight));
        } else if (ToolWindowAnchor.LEFT == anchor) {
            this.myHorizontalSplitter.setFirstComponent(component);
            this.myHorizontalSplitter.setFirstSize((int)((float)this.myLayeredPane.getWidth() * weight));
        } else if (ToolWindowAnchor.BOTTOM == anchor) {
            this.myVerticalSplitter.setLastComponent(component);
            this.myVerticalSplitter.setLastSize((int)((float)this.myLayeredPane.getHeight() * weight));
        } else if (ToolWindowAnchor.RIGHT == anchor) {
            this.myHorizontalSplitter.setLastComponent(component);
            this.myHorizontalSplitter.setLastSize((int)((float)this.myLayeredPane.getWidth() * weight));
        } else {
            LOG.error("unknown anchor: " + anchor);
        }
    }

    private JComponent getComponentAt(ToolWindowAnchor anchor) {
        if (ToolWindowAnchor.TOP == anchor) {
            return this.myVerticalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.LEFT == anchor) {
            return this.myHorizontalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.BOTTOM == anchor) {
            return this.myVerticalSplitter.getLastComponent();
        }
        if (ToolWindowAnchor.RIGHT == anchor) {
            return this.myHorizontalSplitter.getLastComponent();
        }
        LOG.error("unknown anchor: " + anchor);
        return null;
    }

    private float getPreferredSplitProportion(String id, float defaultValue) {
        Float f = (Float)this.myId2SplitProportion.get((Object)id);
        return f == null ? defaultValue : f.floatValue();
    }

    private WindowInfoImpl getDockedInfoAt(ToolWindowAnchor anchor, boolean side) {
        for (WindowInfoImpl info : this.myDecorator2Info.values()) {
            if (!info.isVisible() || !info.isDocked() || info.getAnchor() != anchor || side != info.isSplit()) continue;
            return info;
        }
        return null;
    }

    public void setDocumentComponent(JComponent component) {
        (this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter).setInnerComponent(component);
    }

    private void updateToolStripesVisibility() {
        boolean oldVisible = this.myLeftStripe.isVisible();
        boolean showButtons = !UISettings.getInstance().HIDE_TOOL_STRIPES && !UISettings.getInstance().PRESENTATION_MODE;
        boolean visible = showButtons || this.myStripesOverlayed;
        this.myLeftStripe.setVisible(visible);
        this.myRightStripe.setVisible(visible);
        this.myTopStripe.setVisible(visible);
        this.myBottomStripe.setVisible(visible);
        boolean overlayed = !showButtons && this.myStripesOverlayed;
        this.myLeftStripe.setOverlayed(overlayed);
        this.myRightStripe.setOverlayed(overlayed);
        this.myTopStripe.setOverlayed(overlayed);
        this.myBottomStripe.setOverlayed(overlayed);
        if (oldVisible != visible) {
            this.revalidate();
            this.repaint();
        }
    }

    Stripe getStripeFor(String id) {
        ToolWindowAnchor anchor = this.myManager.getToolWindow(id).getAnchor();
        if (ToolWindowAnchor.TOP == anchor) {
            return this.myTopStripe;
        }
        if (ToolWindowAnchor.BOTTOM == anchor) {
            return this.myBottomStripe;
        }
        if (ToolWindowAnchor.LEFT == anchor) {
            return this.myLeftStripe;
        }
        if (ToolWindowAnchor.RIGHT == anchor) {
            return this.myRightStripe;
        }
        throw new IllegalArgumentException("Anchor=" + anchor);
    }

    Stripe getStripeFor(Rectangle screenRec, Stripe preferred) {
        if (preferred.containsScreen(screenRec)) {
            return this.myStripes.get(this.myStripes.indexOf(preferred));
        }
        for (Stripe each : this.myStripes) {
            if (!each.containsScreen(screenRec)) continue;
            return this.myStripes.get(this.myStripes.indexOf(each));
        }
        return null;
    }

    void startDrag() {
        for (Stripe each : this.myStripes) {
            each.startDrag();
        }
    }

    void stopDrag() {
        for (Stripe each : this.myStripes) {
            each.stopDrag();
        }
    }

    public void stretchWidth(ToolWindow wnd, int value) {
        this.stretch(wnd, value);
    }

    public void stretchHeight(ToolWindow wnd, int value) {
        this.stretch(wnd, value);
    }

    private void stretch(ToolWindow wnd, int value) {
        int maxValue;
        if (!wnd.isVisible()) {
            return;
        }
        Resizer resizer = null;
        Container cmp = null;
        if (wnd.getType() == ToolWindowType.DOCKED) {
            cmp = this.getComponentAt(wnd.getAnchor());
            if (cmp != null) {
                resizer = wnd.getAnchor().isHorizontal() ? (this.myVerticalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myVerticalSplitter) : new Resizer.Splitter.LastComponent(this.myVerticalSplitter)) : (this.myHorizontalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myHorizontalSplitter) : new Resizer.Splitter.LastComponent(this.myHorizontalSplitter));
            }
        } else if (wnd.getType() == ToolWindowType.SLIDING) {
            for (cmp = wnd.getComponent(); cmp != null && cmp.getParent() != this.myLayeredPane; cmp = cmp.getParent()) {
            }
            if (cmp != null) {
                if (wnd.getAnchor() == ToolWindowAnchor.TOP) {
                    resizer = new Resizer.LayeredPane.Top(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.BOTTOM) {
                    resizer = new Resizer.LayeredPane.Bottom(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.LEFT) {
                    resizer = new Resizer.LayeredPane.Left(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.RIGHT) {
                    resizer = new Resizer.LayeredPane.Right(cmp);
                }
            }
        }
        if (resizer == null) {
            return;
        }
        int currentValue = wnd.getAnchor().isHorizontal() ? ((Component)cmp).getHeight() : ((Component)cmp).getWidth();
        int actualSize = currentValue + value;
        int minValue = wnd.getAnchor().isHorizontal() ? ((ToolWindowEx)wnd).getDecorator().getHeaderHeight() : 16 + this.myHorizontalSplitter.getDividerWidth();
        int n = maxValue = wnd.getAnchor().isHorizontal() ? this.myLayeredPane.getHeight() : this.myLayeredPane.getWidth();
        if (actualSize < minValue) {
            actualSize = minValue;
        }
        if (actualSize > maxValue) {
            actualSize = maxValue;
        }
        resizer.setSize(actualSize);
    }

    private void updateLayout() {
        InternalDecorator second;
        InternalDecorator first;
        Splitter splitter;
        JComponent component;
        if (this.myWidescreen != UISettings.getInstance().WIDESCREEN_SUPPORT) {
            JComponent documentComponent = (this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter).getInnerComponent();
            this.myWidescreen = UISettings.getInstance().WIDESCREEN_SUPPORT;
            if (this.myWidescreen) {
                this.myVerticalSplitter.setInnerComponent(null);
                this.myHorizontalSplitter.setInnerComponent((JComponent)this.myVerticalSplitter);
            } else {
                this.myHorizontalSplitter.setInnerComponent(null);
                this.myVerticalSplitter.setInnerComponent((JComponent)this.myHorizontalSplitter);
            }
            this.myLayeredPane.remove((Component)(this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter));
            this.myLayeredPane.add((Component)(this.myWidescreen ? this.myHorizontalSplitter : this.myVerticalSplitter), DEFAULT_LAYER);
            this.setDocumentComponent(documentComponent);
        }
        if (this.myLeftHorizontalSplit != UISettings.getInstance().LEFT_HORIZONTAL_SPLIT) {
            component = this.getComponentAt(ToolWindowAnchor.LEFT);
            if (component instanceof Splitter) {
                splitter = (Splitter)component;
                first = (InternalDecorator)splitter.getFirstComponent();
                second = (InternalDecorator)splitter.getSecondComponent();
                this.setComponent((JComponent)splitter, ToolWindowAnchor.LEFT, ToolWindowAnchor.LEFT.isSplitVertically() ? first.getWindowInfo().getWeight() : first.getWindowInfo().getWeight() + second.getWindowInfo().getWeight());
            }
            this.myLeftHorizontalSplit = UISettings.getInstance().LEFT_HORIZONTAL_SPLIT;
        }
        if (this.myRightHorizontalSplit != UISettings.getInstance().RIGHT_HORIZONTAL_SPLIT) {
            component = this.getComponentAt(ToolWindowAnchor.RIGHT);
            if (component instanceof Splitter) {
                splitter = (Splitter)component;
                first = (InternalDecorator)splitter.getFirstComponent();
                second = (InternalDecorator)splitter.getSecondComponent();
                this.setComponent((JComponent)splitter, ToolWindowAnchor.RIGHT, ToolWindowAnchor.RIGHT.isSplitVertically() ? first.getWindowInfo().getWeight() : first.getWindowInfo().getWeight() + second.getWindowInfo().getWeight());
            }
            this.myRightHorizontalSplit = UISettings.getInstance().RIGHT_HORIZONTAL_SPLIT;
        }
    }

    public void setStripesOverlayed(boolean stripesOverlayed) {
        this.myStripesOverlayed = stripesOverlayed;
        this.updateToolStripesVisibility();
    }

    public void dispose() {
    }

    private static float normalizeWeigh(float weight) {
        if (weight <= 0.0f) {
            return 0.33f;
        }
        if (weight >= 1.0f) {
            return 0.66999996f;
        }
        return weight;
    }

    private final class MyLayeredPane
    extends JBLayeredPane {
        public MyLayeredPane(JComponent splitter) {
            this.setOpaque(false);
            this.add(splitter, JLayeredPane.DEFAULT_LAYER);
        }

        public void doLayout() {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width < 0 || height < 0) {
                return;
            }
            Component[] components = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            LOG.assertTrue(components.length <= 1);
            for (Component component : components) {
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            for (Component component : components = this.getComponentsInLayer(JLayeredPane.PALETTE_LAYER)) {
                WindowInfoImpl info;
                if (!(component instanceof InternalDecorator) || (info = (WindowInfoImpl)ToolWindowsPane.this.myDecorator2Info.get((Object)component)) == null) continue;
                float weight = info.getAnchor().isHorizontal() ? (float)component.getHeight() / (float)this.getHeight() : (float)component.getWidth() / (float)this.getWidth();
                this.setBoundsInPaletteLayer(component, info.getAnchor(), weight);
            }
        }

        public final void setBoundsInPaletteLayer(Component component, ToolWindowAnchor anchor, float weight) {
            if (weight < 0.0f) {
                weight = 0.33f;
            } else if (weight > 1.0f) {
                weight = 1.0f;
            }
            if (ToolWindowAnchor.TOP == anchor) {
                component.setBounds(0, 0, this.getWidth(), (int)((float)this.getHeight() * weight + 0.5f));
            } else if (ToolWindowAnchor.LEFT == anchor) {
                component.setBounds(0, 0, (int)((float)this.getWidth() * weight + 0.5f), this.getHeight());
            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                int height = (int)((float)this.getHeight() * weight + 0.5f);
                component.setBounds(0, this.getHeight() - height, this.getWidth(), height);
            } else if (ToolWindowAnchor.RIGHT == anchor) {
                int width = (int)((float)this.getWidth() * weight + 0.5f);
                component.setBounds(this.getWidth() - width, 0, width, this.getHeight());
            } else {
                LOG.error("unknown anchor " + anchor);
            }
        }
    }

    private final class MyUISettingsListenerImpl
    implements UISettingsListener {
        private MyUISettingsListenerImpl() {
        }

        public final void uiSettingsChanged(UISettings source) {
            ToolWindowsPane.this.updateToolStripesVisibility();
            ToolWindowsPane.this.updateLayout();
        }
    }

    private final class UpdateButtonPositionCmd
    extends FinalizableCommand {
        private final String myId;

        private UpdateButtonPositionCmd(String id, Runnable finishCallBack) {
            super(finishCallBack);
            this.myId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WindowInfoImpl info = ToolWindowsPane.this.getButtonById(this.myId).getWindowInfo();
                ToolWindowAnchor anchor = info.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.revalidate();
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.revalidate();
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.revalidate();
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.revalidate();
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class SetEditorComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;

        public SetEditorComponentCmd(JComponent component, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ToolWindowsPane.this.setDocumentComponent(this.myComponent);
                ToolWindowsPane.this.myLayeredPane.validate();
                ToolWindowsPane.this.myLayeredPane.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public RemoveSlidingComponentCmd(Component component, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        @Override
        public final void run() {
            UISettings uiSettings = UISettings.getInstance();
            if (!this.myDirtyMode && uiSettings.ANIMATE_WINDOWS && !UISettings.isRemoteDesktopConnected()) {
                final FadeInFadeOut fadeOut = new FadeInFadeOut(this.myComponent, 450, false, (Component)ToolWindowsPane.this.getButtonById(this.myInfo.getId()));
                ToolWindowsPane.this.add((Component)fadeOut, FadeInFadeOut.LAYER);
                fadeOut.setBounds(0, 0, ToolWindowsPane.this.getWidth(), ToolWindowsPane.this.getHeight());
                ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                fadeOut.doAnimation(new Runnable(){

                    @Override
                    public void run() {
                        ToolWindowsPane.this.remove((Component)fadeOut);
                        ToolWindowsPane.this.repaint();
                        RemoveSlidingComponentCmd.this.finish();
                    }
                });
            } else {
                ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.revalidate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
                this.finish();
            }
        }
    }

    private final class RemoveSplitAndDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        private RemoveSplitAndDockedComponentCmd(WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Splitter splitter = (Splitter)ToolWindowsPane.this.getComponentAt(this.myInfo.getAnchor());
                if (this.myInfo.isSplit()) {
                    InternalDecorator component = (InternalDecorator)splitter.getFirstComponent();
                    ToolWindowsPane.this.myId2SplitProportion.put((Object)component.getWindowInfo().getId(), (Object)Float.valueOf(splitter.getProportion()));
                    ToolWindowsPane.this.setComponent(component, this.myInfo.getAnchor(), component.getWindowInfo().getWeight());
                } else {
                    InternalDecorator component = (InternalDecorator)splitter.getSecondComponent();
                    ToolWindowsPane.this.setComponent(component, this.myInfo.getAnchor(), component.getWindowInfo().getWeight());
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public RemoveDockedComponentCmd(WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ToolWindowsPane.this.setComponent(null, this.myInfo.getAnchor(), 0.0f);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;

        public RemoveToolStripeButtonCmd(StripeButton button, WindowInfoImpl info, Runnable finishCallBack) {
            super(finishCallBack);
            this.myButton = button;
            this.myInfo = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.removeButton(this.myButton);
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;
        private final Comparator<StripeButton> myComparator;

        public AddToolStripeButtonCmd(StripeButton button, WindowInfoImpl info, Comparator<StripeButton> comparator, Runnable finishCallBack) {
            super(finishCallBack);
            this.myButton = button;
            this.myInfo = info;
            this.myComparator = comparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.addButton(this.myButton, this.myComparator);
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public AddSlidingComponentCmd(Component component, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        @Override
        public final void run() {
            UISettings uiSettings = UISettings.getInstance();
            if (!this.myDirtyMode && uiSettings.ANIMATE_WINDOWS && !UISettings.isRemoteDesktopConnected()) {
                ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                ToolWindowsPane.this.myLayeredPane.moveToFront(this.myComponent);
                ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                final FadeInFadeOut fadeIn = new FadeInFadeOut(this.myComponent, 250, true, (Component)ToolWindowsPane.this.myId2Button.get((Object)this.myInfo.getId()));
                ToolWindowsPane.this.add((Component)fadeIn, FadeInFadeOut.LAYER);
                fadeIn.setBounds(0, 0, ToolWindowsPane.this.getWidth(), ToolWindowsPane.this.getHeight());
                ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                fadeIn.doAnimation(new Runnable(){

                    @Override
                    public void run() {
                        ToolWindowsPane.this.remove((Component)fadeIn);
                        ToolWindowsPane.this.myLayeredPane.add(AddSlidingComponentCmd.this.myComponent, JLayeredPane.PALETTE_LAYER);
                        ToolWindowsPane.this.repaint();
                        AddSlidingComponentCmd.this.finish();
                    }
                });
            } else {
                ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.revalidate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
                this.finish();
            }
        }
    }

    private final class AddAndSplitDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myNewComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        private AddAndSplitDockedComponentCmd(JComponent newComponent, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myNewComponent = newComponent;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                float newWeight;
                final ToolWindowAnchor anchor = this.myInfo.getAnchor();
                final Disposable splitterDisposable = new Disposable(){

                    public void dispose() {
                    }
                };
                Disposer.register((Disposable)ToolWindowsPane.this.myDisposable, (Disposable)splitterDisposable);
                final Splitter splitter = new Splitter(anchor.isSplitVertically()){

                    public void removeNotify() {
                        super.removeNotify();
                        Disposer.dispose((Disposable)splitterDisposable);
                    }
                };
                if (!anchor.isHorizontal()) {
                    UISettings.getInstance().addUISettingsListener(new UISettingsListener(){

                        public void uiSettingsChanged(UISettings source) {
                            if (anchor == ToolWindowAnchor.LEFT) {
                                splitter.setOrientation(!source.LEFT_HORIZONTAL_SPLIT);
                            }
                            if (anchor == ToolWindowAnchor.RIGHT) {
                                splitter.setOrientation(!source.RIGHT_HORIZONTAL_SPLIT);
                            }
                        }
                    }, splitterDisposable);
                    splitter.setAllowSwitchOrientationByMouseClick(true);
                    splitter.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (!"orientation".equals(evt.getPropertyName())) {
                                return;
                            }
                            boolean isSplitterHorizontalNow = !splitter.isVertical();
                            UISettings settings = UISettings.getInstance();
                            if (anchor == ToolWindowAnchor.LEFT && settings.LEFT_HORIZONTAL_SPLIT != isSplitterHorizontalNow) {
                                settings.LEFT_HORIZONTAL_SPLIT = isSplitterHorizontalNow;
                                settings.fireUISettingsChanged();
                            }
                            if (anchor == ToolWindowAnchor.RIGHT && settings.RIGHT_HORIZONTAL_SPLIT != isSplitterHorizontalNow) {
                                settings.RIGHT_HORIZONTAL_SPLIT = isSplitterHorizontalNow;
                                settings.fireUISettingsChanged();
                            }
                        }
                    });
                }
                InternalDecorator oldComponent = (InternalDecorator)ToolWindowsPane.this.getComponentAt(anchor);
                if (this.myInfo.isSplit()) {
                    splitter.setFirstComponent((JComponent)oldComponent);
                    splitter.setSecondComponent(this.myNewComponent);
                    float proportion = ToolWindowsPane.this.getPreferredSplitProportion(oldComponent.getWindowInfo().getId(), ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getSideWeight() / (oldComponent.getWindowInfo().getSideWeight() + this.myInfo.getSideWeight())));
                    splitter.setProportion(proportion);
                    newWeight = !anchor.isHorizontal() && !anchor.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getWeight() + this.myInfo.getWeight()) : ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getWeight());
                } else {
                    splitter.setFirstComponent(this.myNewComponent);
                    splitter.setSecondComponent((JComponent)oldComponent);
                    splitter.setProportion(ToolWindowsPane.normalizeWeigh(this.myInfo.getSideWeight()));
                    newWeight = !anchor.isHorizontal() && !anchor.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getWeight() + this.myInfo.getWeight()) : ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight());
                }
                ToolWindowsPane.this.setComponent((JComponent)splitter, anchor, newWeight);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    private final class AddDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public AddDockedComponentCmd(JComponent component, WindowInfoImpl info, boolean dirtyMode, Runnable finishCallBack) {
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                ToolWindowsPane.this.setComponent(this.myComponent, anchor, ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight()));
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }
    }

    static interface Resizer {
        public void setSize(int var1);

        public static abstract class LayeredPane
        implements Resizer {
            Component myComponent;

            protected LayeredPane(Component component) {
                this.myComponent = component;
            }

            @Override
            public final void setSize(int size) {
                this._setSize(size);
                if (this.myComponent.getParent() instanceof JComponent) {
                    JComponent parent = (JComponent)this.myComponent;
                    parent.revalidate();
                    parent.repaint();
                }
            }

            abstract void _setSize(int var1);

            static class Bottom
            extends LayeredPane {
                Bottom(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds = this.myComponent.getBounds();
                    int delta = size - bounds.height;
                    bounds.y -= delta;
                    bounds.height += delta;
                    this.myComponent.setBounds(bounds);
                }
            }

            static class Top
            extends LayeredPane {
                Top(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(this.myComponent.getWidth(), size);
                }
            }

            static class Right
            extends LayeredPane {
                Right(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds = this.myComponent.getBounds();
                    int delta = size - bounds.width;
                    bounds.x -= delta;
                    bounds.width += delta;
                    this.myComponent.setBounds(bounds);
                }
            }

            static class Left
            extends LayeredPane {
                Left(Component component) {
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(size, this.myComponent.getHeight());
                }
            }
        }

        public static abstract class Splitter
        implements Resizer {
            ThreeComponentsSplitter mySplitter;

            Splitter(ThreeComponentsSplitter splitter) {
                this.mySplitter = splitter;
            }

            static class LastComponent
            extends Splitter {
                LastComponent(ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setLastSize(size);
                }
            }

            static class FirstComponent
            extends Splitter {
                FirstComponent(ThreeComponentsSplitter splitter) {
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setFirstSize(size);
                }
            }
        }
    }
}

