/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.platform.ProjectBaseDirectory;
import org.jetbrains.annotations.NotNull;

public class PlatformFrameTitleBuilder
extends FrameTitleBuilder {
    @Override
    public String getProjectTitle(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/PlatformFrameTitleBuilder", "getProjectTitle"));
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return project.getName();
        }
        if (basePath.equals(project.getName())) {
            return "[" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
        }
        return project.getName() + " - [" + FileUtil.getLocationRelativeToUserHome((String)basePath) + "]";
    }

    @Override
    public String getFileTitle(@NotNull Project project, @NotNull VirtualFile file) {
        String projectHomeUrl;
        VirtualFile baseDir;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/PlatformFrameTitleBuilder", "getFileTitle"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/PlatformFrameTitleBuilder", "getFileTitle"));
        }
        if (SystemInfo.isMac) {
            return UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file);
        }
        if (file instanceof VirtualFilePathWrapper) {
            return ((VirtualFilePathWrapper)file).getPresentablePath();
        }
        String url = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (url == null) {
            url = file.getPresentableUrl();
        }
        if ((baseDir = ProjectBaseDirectory.getInstance(project).getBaseDir()) == null) {
            baseDir = project.getBaseDir();
        }
        if (baseDir != null && (projectHomeUrl = FileUtil.getLocationRelativeToUserHome((String)baseDir.getPresentableUrl())) != null && url.startsWith(projectHomeUrl)) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        return url;
    }
}

