/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.actions.ResizeToolWindowAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalDecorator
extends JPanel
implements Queryable,
TypeSafeDataProvider {
    private static final int DIVIDER_WIDTH = UIUtil.isUnderDarcula() ? 2 : 5;
    private Project myProject;
    private WindowInfoImpl myInfo;
    private final ToolWindowImpl myToolWindow;
    private final MyDivider myDivider;
    private final EventListenerList myListenerList;
    private final TogglePinnedModeAction myToggleAutoHideModeAction;
    private final ToggleDockModeAction myToggleDockModeAction;
    private final ToggleFloatingModeAction myToggleFloatingModeAction;
    private final ToggleSideModeAction myToggleSideModeAction;
    private final ToggleContentUiTypeAction myToggleContentUiTypeAction;
    private ActionGroup myAdditionalGearActions;
    private final ToolWindowHandler myToolWindowHandler;
    private final MyKeymapManagerListener myWeakKeymapManagerListener;
    @NonNls
    private static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";
    @NonNls
    public static final String TOGGLE_PINNED_MODE_ACTION_ID = "TogglePinnedMode";
    @NonNls
    public static final String TOGGLE_DOCK_MODE_ACTION_ID = "ToggleDockMode";
    @NonNls
    public static final String TOGGLE_FLOATING_MODE_ACTION_ID = "ToggleFloatingMode";
    @NonNls
    public static final String TOGGLE_SIDE_MODE_ACTION_ID = "ToggleSideMode";
    @NonNls
    private static final String TOGGLE_CONTENT_UI_TYPE_ACTION_ID = "ToggleContentUiTypeMode";
    private ToolWindowHeader myHeader;

    InternalDecorator(Project project, @NotNull WindowInfoImpl info, ToolWindowImpl toolWindow) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/InternalDecorator", "<init>"));
        }
        super(new BorderLayout());
        this.myProject = project;
        this.myToolWindow = toolWindow;
        this.myToolWindow.setDecorator(this);
        this.myDivider = new MyDivider();
        this.myToggleFloatingModeAction = new ToggleFloatingModeAction();
        this.myToggleSideModeAction = new ToggleSideModeAction();
        this.myToggleDockModeAction = new ToggleDockModeAction();
        this.myToggleAutoHideModeAction = new TogglePinnedModeAction();
        this.myToggleContentUiTypeAction = new ToggleContentUiTypeAction();
        this.myListenerList = new EventListenerList();
        this.myHeader = new ToolWindowHeader(toolWindow, info, (Producer)new Producer<ActionGroup>(){

            public ActionGroup produce() {
                return InternalDecorator.this.createGearPopupGroup();
            }
        }){

            @Override
            protected boolean isActive() {
                return InternalDecorator.this.isFocused();
            }

            @Override
            protected void hideToolWindow() {
                InternalDecorator.this.fireHidden();
            }

            @Override
            protected void toolWindowTypeChanged(ToolWindowType type) {
                InternalDecorator.this.fireTypeChanged(type);
            }

            @Override
            protected void sideHidden() {
                InternalDecorator.this.fireHiddenSide();
            }
        };
        MyKeymapManagerListener keymapManagerListener = new MyKeymapManagerListener();
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        this.myWeakKeymapManagerListener = keymapManagerListener;
        keymapManager.addWeakListener(keymapManagerListener);
        this.init();
        this.myToolWindowHandler = new ToolWindowHandler();
        this.myToolWindow.addPropertyChangeListener(this.myToolWindowHandler);
        this.apply(info);
    }

    public boolean isFocused() {
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component component = fm.getFocusedDescendantFor((Component)this.myToolWindow.getComponent());
        if (component != null) {
            return true;
        }
        Component owner = fm.getLastFocusedFor(WindowManager.getInstance().getIdeFrame(this.myProject));
        return owner != null && SwingUtilities.isDescendingFrom(owner, this.myToolWindow.getComponent());
    }

    public final void apply(@NotNull WindowInfoImpl info) {
        FloatingDecorator floatingDecorator;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/InternalDecorator", "apply"));
        }
        if (Comparing.equal((Object)this.myInfo, (Object)info) || this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        this.myInfo = info;
        ToolWindowAnchor anchor = this.myInfo.getAnchor();
        if (info.isSliding()) {
            this.myDivider.invalidate();
            if (ToolWindowAnchor.TOP == anchor) {
                this.add((Component)this.myDivider, "South");
            } else if (ToolWindowAnchor.LEFT == anchor) {
                this.add((Component)this.myDivider, "East");
            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                this.add((Component)this.myDivider, "North");
            } else if (ToolWindowAnchor.RIGHT == anchor) {
                this.add((Component)this.myDivider, "West");
            }
            this.myDivider.setPreferredSize(new Dimension(DIVIDER_WIDTH, DIVIDER_WIDTH));
        } else {
            this.remove(this.myDivider);
        }
        this.validate();
        this.repaint();
        this.updateTitle();
        if (this.myInfo.isFloating() && this.myInfo.isVisible() && (floatingDecorator = (FloatingDecorator)SwingUtilities.getAncestorOfClass(FloatingDecorator.class, this)) != null) {
            floatingDecorator.apply(this.myInfo);
        }
        this.myToolWindow.getContentUI().setType(this.myInfo.getContentUiType());
        this.setBorder(new InnerPanelBorder(this.myToolWindow));
    }

    public void calcData(DataKey key, DataSink sink) {
        if (PlatformDataKeys.TOOL_WINDOW.equals(key)) {
            sink.put(PlatformDataKeys.TOOL_WINDOW, (Object)this.myToolWindow);
        }
    }

    final void addInternalDecoratorListener(InternalDecoratorListener l) {
        this.myListenerList.add(InternalDecoratorListener.class, l);
    }

    final void removeInternalDecoratorListener(InternalDecoratorListener l) {
        this.myListenerList.remove(InternalDecoratorListener.class, l);
    }

    final void dispose() {
        this.removeAll();
        this.myToolWindow.removePropertyChangeListener(this.myToolWindowHandler);
        KeymapManagerEx.getInstanceEx().removeWeakListener(this.myWeakKeymapManagerListener);
        Disposer.dispose((Disposable)this.myHeader);
        this.myHeader = null;
        this.myProject = null;
    }

    private void fireAnchorChanged(ToolWindowAnchor anchor) {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.anchorChanged(this, anchor);
        }
    }

    private void fireAutoHideChanged(boolean autoHide) {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.autoHideChanged(this, autoHide);
        }
    }

    final void fireHidden() {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.hidden(this);
        }
    }

    final void fireHiddenSide() {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.hiddenSide(this);
        }
    }

    final void fireActivated() {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.activated(this);
        }
    }

    private void fireTypeChanged(ToolWindowType type) {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.typeChanged(this, type);
        }
    }

    final void fireResized() {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.resized(this);
        }
    }

    private void fireSideStatusChanged(boolean isSide) {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.sideStatusChanged(this, isSide);
        }
    }

    private void fireContentUiTypeChanges(ToolWindowContentUiType type) {
        InternalDecoratorListener[] listeners;
        for (InternalDecoratorListener listener : listeners = (InternalDecoratorListener[])this.myListenerList.getListeners(InternalDecoratorListener.class)) {
            listener.contentUiTypeChanges(this, type);
        }
    }

    private void init() {
        this.enableEvents(1L);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.myHeader, "North");
        JPanel innerPanel = new JPanel(new BorderLayout());
        JComponent toolWindowComponent = this.myToolWindow.getComponent();
        innerPanel.add((Component)toolWindowComponent, "Center");
        NonOpaquePanel inner = new NonOpaquePanel((JComponent)innerPanel);
        inner.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        contentPane.add((Component)inner, "Center");
        this.add((Component)contentPane, "Center");
        if (SystemInfo.isMac) {
            this.setBackground((Color)new JBColor((Color)Gray._200, (Color)Gray._90));
        }
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolWindowManager.getInstance((Project)InternalDecorator.this.myProject).activateEditorComponent();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public void setTitleActions(AnAction[] actions) {
        this.myHeader.setAdditionalTitleActions(actions);
    }

    public final ActionGroup createPopupGroup() {
        DefaultActionGroup group = this.createGearPopupGroup();
        group.add((AnAction)this.myToggleContentUiTypeAction);
        DefaultActionGroup moveGroup = new DefaultActionGroup(UIBundle.message((String)"tool.window.move.to.action.group.name", (Object[])new Object[0]), true);
        ToolWindowAnchor anchor = this.myInfo.getAnchor();
        if (anchor != ToolWindowAnchor.TOP) {
            ChangeAnchorAction topAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.top.action.name", (Object[])new Object[0]), ToolWindowAnchor.TOP);
            moveGroup.add((AnAction)topAction);
        }
        if (anchor != ToolWindowAnchor.LEFT) {
            ChangeAnchorAction leftAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.left.action.name", (Object[])new Object[0]), ToolWindowAnchor.LEFT);
            moveGroup.add((AnAction)leftAction);
        }
        if (anchor != ToolWindowAnchor.BOTTOM) {
            ChangeAnchorAction bottomAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.bottom.action.name", (Object[])new Object[0]), ToolWindowAnchor.BOTTOM);
            moveGroup.add((AnAction)bottomAction);
        }
        if (anchor != ToolWindowAnchor.RIGHT) {
            ChangeAnchorAction rightAction = new ChangeAnchorAction(UIBundle.message((String)"tool.window.move.to.right.action.name", (Object[])new Object[0]), ToolWindowAnchor.RIGHT);
            moveGroup.add((AnAction)rightAction);
        }
        group.add((AnAction)moveGroup);
        DefaultActionGroup resize = new DefaultActionGroup(ActionsBundle.groupText((String)"ResizeToolWindowGroup"), true);
        resize.add((AnAction)new ResizeToolWindowAction.Left(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Right(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Up(this.myToolWindow, this));
        resize.add((AnAction)new ResizeToolWindowAction.Down(this.myToolWindow, this));
        group.add((AnAction)resize);
        group.addSeparator();
        group.add((AnAction)new HideAction());
        return group;
    }

    private DefaultActionGroup createGearPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.myAdditionalGearActions != null) {
            InternalDecorator.addSorted(group, this.myAdditionalGearActions);
            group.addSeparator();
        }
        if (this.myInfo.isDocked()) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleDockModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleSideModeAction);
        } else if (this.myInfo.isFloating()) {
            group.add((AnAction)this.myToggleAutoHideModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
        } else if (this.myInfo.isSliding()) {
            group.add((AnAction)this.myToggleDockModeAction);
            group.add((AnAction)this.myToggleFloatingModeAction);
            group.add((AnAction)this.myToggleSideModeAction);
        }
        return group;
    }

    private static void addSorted(DefaultActionGroup main, ActionGroup group) {
        AnAction[] children = group.getChildren(null);
        boolean hadSecondary = false;
        for (AnAction action : children) {
            if (group.isPrimary(action)) {
                main.add(action);
                continue;
            }
            hadSecondary = true;
        }
        if (hadSecondary) {
            main.addSeparator();
            for (AnAction action : children) {
                if (group.isPrimary(action)) continue;
                main.addAction(action).setAsSecondary(true);
            }
        }
    }

    final ToolWindowImpl getToolWindow() {
        return this.myToolWindow;
    }

    @NotNull
    final WindowInfoImpl getWindowInfo() {
        WindowInfoImpl windowInfoImpl = this.myInfo;
        if (windowInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/InternalDecorator", "getWindowInfo"));
        }
        return windowInfoImpl;
    }

    public int getHeaderHeight() {
        return this.myHeader.getPreferredSize().height;
    }

    @Override
    protected final void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if (101 == e.getID()) {
            this.fireResized();
        }
    }

    private void updateTitle() {
        StringBuffer fullTitle = new StringBuffer();
        if (SystemInfo.isWindows || !this.myInfo.isFloating()) {
            fullTitle.append(this.myInfo.getId());
            String title = this.myToolWindow.getTitle();
            if (title != null && title.length() > 0) {
                fullTitle.append(" - ").append(title);
            }
        } else {
            String title = this.myToolWindow.getTitle();
            if (title != null && title.length() > 0) {
                fullTitle.append(title);
            }
        }
    }

    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/impl/InternalDecorator", "putInfo"));
        }
        info.put("toolWindowTitle", this.myToolWindow.getTitle());
        Content selection = this.myToolWindow.getContentManager().getSelectedContent();
        if (selection != null) {
            info.put("toolWindowTab", selection.getTabName());
        }
    }

    public void setAdditionalGearActions(@Nullable ActionGroup additionalGearActions) {
        this.myAdditionalGearActions = additionalGearActions;
    }

    private final class ToolWindowHandler
    implements PropertyChangeListener {
        private ToolWindowHandler() {
        }

        @Override
        public final void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("title".equals(name)) {
                InternalDecorator.this.updateTitle();
                if (InternalDecorator.this.myHeader != null) {
                    InternalDecorator.this.myHeader.repaint();
                }
            }
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public final void activeKeymapChanged(Keymap keymap) {
            if (InternalDecorator.this.myHeader != null) {
                InternalDecorator.this.myHeader.updateTooltips();
            }
        }
    }

    private final class MyDivider
    extends JPanel {
        private boolean myDragging = false;
        private Point myLastPoint;

        private MyDivider() {
            this.enableEvents(48L);
            this.setBorder(new DividerBorder());
        }

        @Override
        protected final void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (506 == e.getID()) {
                this.myDragging = true;
                ToolWindowAnchor anchor = InternalDecorator.this.myInfo.getAnchor();
                boolean isVerticalCursor = InternalDecorator.this.myInfo.isDocked() ? anchor.isSplitVertically() : anchor.isHorizontal();
                this.setCursor(isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                Point point = e.getPoint();
                Container windowPane = InternalDecorator.this.getParent();
                this.myLastPoint = SwingUtilities.convertPoint(this, point, windowPane);
                this.myLastPoint.x = Math.min(Math.max(this.myLastPoint.x, 0), windowPane.getWidth());
                this.myLastPoint.y = Math.min(Math.max(this.myLastPoint.y, 0), windowPane.getHeight());
                Rectangle bounds = InternalDecorator.this.getBounds();
                if (anchor == ToolWindowAnchor.TOP) {
                    if (this.myLastPoint.y < DIVIDER_WIDTH) {
                        this.myLastPoint.y = DIVIDER_WIDTH;
                    }
                    InternalDecorator.this.setBounds(0, 0, bounds.width, this.myLastPoint.y);
                } else if (anchor == ToolWindowAnchor.LEFT) {
                    if (this.myLastPoint.x < DIVIDER_WIDTH) {
                        this.myLastPoint.x = DIVIDER_WIDTH;
                    }
                    InternalDecorator.this.setBounds(0, 0, this.myLastPoint.x, bounds.height);
                } else if (anchor == ToolWindowAnchor.BOTTOM) {
                    if (this.myLastPoint.y > windowPane.getHeight() - DIVIDER_WIDTH) {
                        this.myLastPoint.y = windowPane.getHeight() - DIVIDER_WIDTH;
                    }
                    InternalDecorator.this.setBounds(0, this.myLastPoint.y, bounds.width, windowPane.getHeight() - this.myLastPoint.y);
                } else if (anchor == ToolWindowAnchor.RIGHT) {
                    if (this.myLastPoint.x > windowPane.getWidth() - DIVIDER_WIDTH) {
                        this.myLastPoint.x = windowPane.getWidth() - DIVIDER_WIDTH;
                    }
                    InternalDecorator.this.setBounds(this.myLastPoint.x, 0, windowPane.getWidth() - this.myLastPoint.x, bounds.height);
                }
                InternalDecorator.this.validate();
            }
        }

        @Override
        protected final void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            boolean isVerticalCursor = InternalDecorator.this.myInfo.isDocked() ? InternalDecorator.this.myInfo.getAnchor().isSplitVertically() : InternalDecorator.this.myInfo.getAnchor().isHorizontal();
            switch (e.getID()) {
                default: {
                    break;
                }
                case 504: {
                    this.setCursor(isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    this.setCursor(isVerticalCursor ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 502: {
                    this.myDragging = false;
                    this.myLastPoint = null;
                }
                case 500: 
            }
        }

        private final class DividerBorder
        implements Border {
            private DividerBorder() {
            }

            @Override
            public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                ToolWindowAnchor anchor = InternalDecorator.this.myInfo.getAnchor();
                boolean isVertical = !anchor.isSplitVertically();
                JBColor outer = new JBColor(Color.white, Color.darkGray);
                if (isVertical) {
                    if (anchor == ToolWindowAnchor.TOP) {
                        g.setColor((Color)outer);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)y);
                        g.setColor(Color.darkGray);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width - 1), (int)(y + height - 1));
                    } else {
                        g.setColor(Color.darkGray);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)y);
                        g.setColor((Color)outer);
                        UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width - 1), (int)(y + height - 1));
                    }
                } else if (anchor == ToolWindowAnchor.LEFT) {
                    g.setColor((Color)outer);
                    UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height - 1));
                    g.setColor(Color.darkGray);
                    UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)y, (int)(x + width - 1), (int)(y + height - 1));
                } else {
                    g.setColor(Color.darkGray);
                    UIUtil.drawLine((Graphics)g, (int)x, (int)y, (int)x, (int)(y + height - 1));
                    g.setColor((Color)outer);
                    UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)y, (int)(x + width - 1), (int)(y + height - 1));
                }
            }

            @Override
            public final Insets getBorderInsets(Component c) {
                if (c instanceof MyDivider) {
                    return new Insets(1, 1, 1, 1);
                }
                return new Insets(0, 0, 0, 0);
            }

            @Override
            public final boolean isBorderOpaque() {
                return true;
            }
        }
    }

    private final class ToggleContentUiTypeAction
    extends ToggleAction
    implements DumbAware {
        private ToggleContentUiTypeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_CONTENT_UI_TYPE_ACTION_ID));
        }

        public boolean isSelected(AnActionEvent e) {
            return InternalDecorator.this.myInfo.getContentUiType() == ToolWindowContentUiType.TABBED;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            InternalDecorator.this.fireContentUiTypeChanges(state ? ToolWindowContentUiType.TABBED : ToolWindowContentUiType.COMBO);
        }
    }

    private final class HideAction
    extends AnAction
    implements DumbAware {
        @NonNls
        public static final String HIDE_ACTIVE_WINDOW_ACTION_ID = "HideActiveWindow";

        public HideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideActiveWindow"));
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
        }

        public final void actionPerformed(AnActionEvent e) {
            InternalDecorator.this.fireHidden();
        }

        public final void update(AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(InternalDecorator.this.myInfo.isVisible());
        }
    }

    private final class ToggleSideModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleSideModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_SIDE_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isSplit();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            InternalDecorator.this.fireSideStatusChanged(flag);
        }

        public void update(AnActionEvent e) {
            super.update(e);
        }
    }

    private final class ToggleFloatingModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleFloatingModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_FLOATING_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isFloating();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (InternalDecorator.this.myInfo.isFloating()) {
                InternalDecorator.this.fireTypeChanged(InternalDecorator.this.myInfo.getInternalType());
            } else {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.FLOATING);
            }
        }
    }

    private final class ToggleDockModeAction
    extends ToggleAction
    implements DumbAware {
        public ToggleDockModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_DOCK_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return InternalDecorator.this.myInfo.isDocked();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (InternalDecorator.this.myInfo.isDocked()) {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.SLIDING);
            } else if (InternalDecorator.this.myInfo.isSliding()) {
                InternalDecorator.this.fireTypeChanged(ToolWindowType.DOCKED);
            }
        }
    }

    private final class TogglePinnedModeAction
    extends ToggleAction
    implements DumbAware {
        public TogglePinnedModeAction() {
            this.copyFrom(ActionManager.getInstance().getAction(InternalDecorator.TOGGLE_PINNED_MODE_ACTION_ID));
        }

        public final boolean isSelected(AnActionEvent event) {
            return !InternalDecorator.this.myInfo.isAutoHide();
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            InternalDecorator.this.fireAutoHideChanged(!InternalDecorator.this.myInfo.isAutoHide());
        }
    }

    private final class ChangeAnchorAction
    extends AnAction
    implements DumbAware {
        private final ToolWindowAnchor myAnchor;

        public ChangeAnchorAction(String title, ToolWindowAnchor anchor) {
            super(title);
            this.myAnchor = anchor;
        }

        public final void actionPerformed(AnActionEvent e) {
            InternalDecorator.this.fireAnchorChanged(this.myAnchor);
        }
    }

    private class InnerPanelBorder
    implements Border {
        private final ToolWindow myWindow;

        private InnerPanelBorder(ToolWindow window) {
            this.myWindow = window;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UIUtil.getPanelBackground());
            this.doPaintBorder(c, g, x, y, width, height);
            g.setColor(new Color(0, 0, 0, 90));
            this.doPaintBorder(c, g, x, y, width, height);
        }

        private void doPaintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Insets insets = this.getBorderInsets(c);
            if (insets.top > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + insets.top - 1), (int)(x + width - 1), (int)(y + insets.top - 1));
            }
            if (insets.left > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + insets.top), (int)x, (int)(y + height - 1));
            }
            if (insets.right > 0) {
                UIUtil.drawLine((Graphics)g, (int)(x + width - 1), (int)(y + insets.top), (int)(x + width - 1), (int)(y + height - 1));
            }
            if (insets.bottom > 0) {
                UIUtil.drawLine((Graphics)g, (int)x, (int)(y + height - 1), (int)(x + width - 1), (int)(y + height - 1));
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (InternalDecorator.this.myProject == null) {
                return new Insets(0, 0, 0, 0);
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)InternalDecorator.this.myProject);
            if (!(toolWindowManager instanceof ToolWindowManagerImpl) || !((ToolWindowManagerImpl)toolWindowManager).isToolWindowRegistered(InternalDecorator.this.myInfo.getId()) || this.myWindow.getType() == ToolWindowType.FLOATING) {
                return new Insets(0, 0, 0, 0);
            }
            ToolWindowAnchor anchor = this.myWindow.getAnchor();
            Container component = this.myWindow.getComponent();
            Container parent = component.getParent();
            while (parent != null) {
                if (parent instanceof Splitter) {
                    Splitter splitter = (Splitter)parent;
                    boolean isFirst = splitter.getFirstComponent() == component;
                    boolean isVertical = splitter.isVertical();
                    return new Insets(0, anchor == ToolWindowAnchor.RIGHT || !isVertical && !isFirst ? 1 : 0, isVertical && isFirst ? 1 : 0, anchor == ToolWindowAnchor.LEFT || !isVertical && isFirst ? 1 : 0);
                }
                component = parent;
                parent = component.getParent();
            }
            return new Insets(0, anchor == ToolWindowAnchor.RIGHT ? 1 : 0, 0, anchor == ToolWindowAnchor.LEFT ? 1 : 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

