/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.dnd.DnDAware;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;

public class IdeGlassPaneImpl
extends JPanel
implements IdeGlassPaneEx,
IdeEventQueue.EventDispatcher,
Painter.Listener {
    private final Set<EventListener> myMouseListeners = new LinkedHashSet<EventListener>();
    private final JRootPane myRootPane;
    private final Set<Painter> myPainters = new LinkedHashSet<Painter>();
    private final Map<Painter, Component> myPainter2Component = new LinkedHashMap<Painter, Component>();
    private boolean myPaintingActive;
    private boolean myPreprocessorActive;
    private final Map<Object, Cursor> myListener2Cursor = new LinkedHashMap<Object, Cursor>();
    private Component myLastCursorComponent;
    private Cursor myLastOriginalCursor;
    private MouseEvent myPrevPressEvent;
    private JPanel myFocusProxy = new JPanel(){

        @Override
        public String toString() {
            return "FocusProxy";
        }
    };
    private MouseEvent myLastRedispatchedEvent = null;

    public IdeGlassPaneImpl(JRootPane rootPane) {
        this.myRootPane = rootPane;
        this.setOpaque(false);
        this.setVisible(false);
        this.setLayout(null);
        this.myFocusProxy.setOpaque(false);
        this.myFocusProxy.setPreferredSize(new Dimension(0, 0));
        this.myFocusProxy.setFocusable(true);
        UIUtil.setFocusProxy((JComponent)this.myFocusProxy, (boolean)true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myFocusProxy.getParent() != null) {
            this.myFocusProxy.getParent().remove(this.myFocusProxy);
        }
        if (this.myFocusProxy.getParent() != this.getParent()) {
            this.getParent().add(this.myFocusProxy);
            this.myFocusProxy.setBounds(0, 0, 0, 0);
        }
    }

    @Override
    public boolean dispatch(AWTEvent e) {
        boolean dispatched;
        JRootPane eventRootPane = this.myRootPane;
        if (e instanceof MouseEvent) {
            Container parentWindow;
            Window eventWindow;
            MouseEvent me = (MouseEvent)e;
            Window window = eventWindow = me.getComponent() instanceof Window ? (Window)me.getComponent() : SwingUtilities.getWindowAncestor(me.getComponent());
            if (IdeGlassPaneImpl.isContextMenu(eventWindow)) {
                return false;
            }
            Window thisGlassWindow = SwingUtilities.getWindowAncestor(this.myRootPane);
            if (eventWindow instanceof JWindow && (eventRootPane = ((JWindow)eventWindow).getRootPane()) != null && !(eventRootPane.getGlassPane() instanceof IdeGlassPane) && (parentWindow = eventWindow.getParent()) instanceof Window) {
                eventWindow = (Window)parentWindow;
            }
            if (eventWindow != thisGlassWindow) {
                return false;
            }
        }
        if (e.getID() == 506 && ApplicationManager.getApplication() != null) {
            IdeTooltipManager.getInstance().hideCurrent((MouseEvent)e, null, null);
        }
        if (e.getID() == 501 || e.getID() == 502 || e.getID() == 500) {
            dispatched = this.preprocess((MouseEvent)e, false, eventRootPane);
        } else if (e.getID() == 503 || e.getID() == 506) {
            dispatched = this.preprocess((MouseEvent)e, true, eventRootPane);
        } else if (e.getID() == 505 || e.getID() == 504) {
            dispatched = this.preprocess((MouseEvent)e, false, eventRootPane);
        } else {
            return false;
        }
        MouseEvent me = (MouseEvent)e;
        Component meComponent = me.getComponent();
        if (!dispatched && meComponent != null) {
            boolean pureMouse1Event;
            Window eventWindow;
            Window window = eventWindow = meComponent instanceof Window ? (Window)meComponent : SwingUtilities.getWindowAncestor(meComponent);
            if (eventWindow != SwingUtilities.getWindowAncestor(this.myRootPane)) {
                return false;
            }
            int button1 = 1040;
            boolean bl = pureMouse1Event = (me.getModifiersEx() | button1) == button1;
            if (pureMouse1Event && me.getClickCount() <= 1 && !me.isPopupTrigger()) {
                Point targetPoint;
                boolean overSelection;
                Point point = SwingUtilities.convertPoint(meComponent, me.getPoint(), this.myRootPane.getContentPane());
                JMenuBar menuBar = this.myRootPane.getJMenuBar();
                point.y = point.y + (menuBar != null ? menuBar.getHeight() : 0);
                Component target = SwingUtilities.getDeepestComponentAt(this.myRootPane.getContentPane().getParent(), point.x, point.y);
                if (target instanceof DnDAware && (overSelection = ((DnDAware)target).isOverSelection(targetPoint = SwingUtilities.convertPoint(this.myRootPane.getContentPane().getParent(), point.x, point.y, target)))) {
                    MouseListener[] listeners = (MouseListener[])target.getListeners(MouseListener.class);
                    MouseEvent mouseEvent = IdeGlassPaneImpl.convertEvent(me, target);
                    switch (me.getID()) {
                        case 501: {
                            AWTEventListener[] eventListeners;
                            boolean consumed = false;
                            if (target.isFocusable()) {
                                target.requestFocus();
                            }
                            for (MouseListener listener : listeners) {
                                String className = listener.getClass().getName();
                                if (className.indexOf("BasicTreeUI$") >= 0 || className.indexOf("MacTreeUI$") >= 0) continue;
                                IdeGlassPaneImpl.fireMouseEvent(listener, mouseEvent);
                                if (!mouseEvent.isConsumed()) continue;
                                consumed = true;
                                break;
                            }
                            if (!mouseEvent.isConsumed() && (eventListeners = Toolkit.getDefaultToolkit().getAWTEventListeners(16L)) != null && eventListeners.length > 0) {
                                for (AWTEventListener eventListener : eventListeners) {
                                    eventListener.eventDispatched(me);
                                    if (me.isConsumed()) break;
                                }
                                if (me.isConsumed()) {
                                    consumed = true;
                                    break;
                                }
                            }
                            if (!consumed) {
                                this.myPrevPressEvent = mouseEvent;
                            } else {
                                me.consume();
                            }
                            dispatched = true;
                            break;
                        }
                        case 502: {
                            if (this.myPrevPressEvent == null || this.myPrevPressEvent.getComponent() != target) break;
                            for (MouseListener listener : listeners) {
                                String className = listener.getClass().getName();
                                if (className.indexOf("BasicTreeUI$") >= 0 || className.indexOf("MacTreeUI$") >= 0) {
                                    IdeGlassPaneImpl.fireMouseEvent(listener, this.myPrevPressEvent);
                                    IdeGlassPaneImpl.fireMouseEvent(listener, mouseEvent);
                                    if (mouseEvent.isConsumed()) break;
                                }
                                IdeGlassPaneImpl.fireMouseEvent(listener, mouseEvent);
                                if (mouseEvent.isConsumed()) break;
                            }
                            if (mouseEvent.isConsumed()) {
                                me.consume();
                            }
                            this.myPrevPressEvent = null;
                            dispatched = true;
                            break;
                        }
                        default: {
                            this.myPrevPressEvent = null;
                        }
                    }
                }
            }
        }
        if (this.isVisible() && this.getComponentCount() == 0) {
            boolean cursorSet = false;
            if (meComponent != null) {
                Component target;
                Point point = SwingUtilities.convertPoint(meComponent, me.getPoint(), this.myRootPane.getContentPane());
                if (this.myRootPane.getMenuBar() != null && this.myRootPane.getMenuBar().isVisible()) {
                    point.y += this.myRootPane.getMenuBar().getHeight();
                }
                if ((target = SwingUtilities.getDeepestComponentAt(this.myRootPane.getContentPane().getParent(), point.x, point.y)) != null) {
                    this.setCursor(target.getCursor());
                    cursorSet = true;
                }
            }
            if (!cursorSet) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        return dispatched;
    }

    private static boolean isContextMenu(Window window) {
        if (window != null) {
            for (Component component : window.getComponents()) {
                if (!(component instanceof JComponent) || UIUtil.findComponentOfType((JComponent)((JComponent)component), JPopupMenu.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean preprocess(MouseEvent e, boolean motion, JRootPane eventRootPane) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean canProcessCursorFor(Component target) {
        return !(target instanceof JMenu) && !(target instanceof JMenuItem) && !(target instanceof Splitter.Divider) && !(target instanceof JSeparator) && (!(target instanceof JEditorPane) || !(((JEditorPane)target).getEditorKit() instanceof HTMLEditorKit));
    }

    private Component getCompWithCursor(Component c) {
        for (Component eachParentWithCursor = c; eachParentWithCursor != null; eachParentWithCursor = eachParentWithCursor.getParent()) {
            if (!eachParentWithCursor.isCursorSet()) continue;
            return eachParentWithCursor;
        }
        return null;
    }

    private void restoreLastComponent(Component newC) {
        if (this.myLastCursorComponent != null && this.myLastCursorComponent != newC) {
            this.myLastCursorComponent.setCursor(this.myLastOriginalCursor);
        }
    }

    public void setCursor(Cursor cursor, @NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/wm/impl/IdeGlassPaneImpl", "setCursor"));
        }
        if (cursor == null) {
            this.myListener2Cursor.remove(requestor);
        } else {
            this.myListener2Cursor.put(requestor, cursor);
        }
    }

    private static MouseEvent convertEvent(MouseEvent e, Component target) {
        Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), target);
        if (e instanceof MouseWheelEvent) {
            MouseWheelEvent mwe = (MouseWheelEvent)e;
            return new MouseWheelEvent(target, mwe.getID(), mwe.getWhen(), mwe.getModifiersEx(), point.x, point.y, mwe.getClickCount(), mwe.isPopupTrigger(), mwe.getScrollType(), mwe.getScrollAmount(), mwe.getWheelRotation());
        }
        if (e instanceof MenuDragMouseEvent) {
            MenuDragMouseEvent de = (MenuDragMouseEvent)e;
            return new MenuDragMouseEvent(target, de.getID(), de.getWhen(), de.getModifiersEx(), point.x, point.y, e.getClickCount(), e.isPopupTrigger(), de.getPath(), de.getMenuSelectionManager());
        }
        return new MouseEvent(target, e.getID(), e.getWhen(), e.getModifiersEx(), point.x, point.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    private static void fireMouseEvent(MouseListener listener, MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                listener.mousePressed(event);
                break;
            }
            case 502: {
                listener.mouseReleased(event);
                break;
            }
            case 504: {
                listener.mouseEntered(event);
                break;
            }
            case 505: {
                listener.mouseExited(event);
                break;
            }
            case 500: {
                listener.mouseClicked(event);
            }
        }
    }

    private static void fireMouseMotion(MouseMotionListener listener, MouseEvent event) {
        switch (event.getID()) {
            case 506: {
                listener.mouseDragged(event);
            }
            case 503: {
                listener.mouseMoved(event);
            }
        }
    }

    public void addMousePreprocessor(MouseListener listener, Disposable parent) {
        this._addListener(listener, parent);
    }

    public void addMouseMotionPreprocessor(MouseMotionListener listener, Disposable parent) {
        this._addListener(listener, parent);
    }

    private void _addListener(final EventListener listener, Disposable parent) {
        this.myMouseListeners.add(listener);
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IdeGlassPaneImpl.this.removeListener(listener);
                    }
                });
            }
        });
    }

    public void removeMousePreprocessor(MouseListener listener) {
        this.removeListener(listener);
    }

    public void removeMouseMotionPreprocessor(MouseMotionListener listener) {
        this.removeListener(listener);
    }

    private void removeListener(EventListener listener) {
        this.myMouseListeners.remove(listener);
        this.deactivateIfNeeded();
    }

    private void deactivateIfNeeded() {
        if (this.myPaintingActive && this.myPainters.isEmpty() && this.getComponentCount() == 0) {
            this.myPaintingActive = false;
        }
        if (this.myPreprocessorActive && this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = false;
        }
        this.applyActivationState();
    }

    private void activateIfNeeded() {
        if (!(this.myPaintingActive || this.myPainters.isEmpty() && this.getComponentCount() <= 0)) {
            this.myPaintingActive = true;
        }
        if (!this.myPreprocessorActive && !this.myMouseListeners.isEmpty()) {
            this.myPreprocessorActive = true;
        }
        this.applyActivationState();
    }

    private void applyActivationState() {
        IdeEventQueue queue;
        boolean wasVisible = this.isVisible();
        if (wasVisible != this.myPaintingActive) {
            this.setVisible(this.myPaintingActive);
        }
        if (!(queue = IdeEventQueue.getInstance()).containsDispatcher(this) && (this.myPreprocessorActive || this.isVisible())) {
            queue.addDispatcher(this, null);
        } else if (queue.containsDispatcher(this) && !this.myPreprocessorActive && !this.isVisible()) {
            queue.removeDispatcher(this);
        }
        if (wasVisible != this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addPainter(Component component, final Painter painter, Disposable parent) {
        this.myPainters.add(painter);
        this.myPainter2Component.put(painter, component == null ? this : component);
        painter.addListener((Painter.Listener)this);
        this.activateIfNeeded();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IdeGlassPaneImpl.this.removePainter(painter);
                    }
                });
            }
        });
    }

    public void removePainter(Painter painter) {
        this.myPainters.remove(painter);
        this.myPainter2Component.remove(painter);
        painter.removeListener((Painter.Listener)this);
        this.deactivateIfNeeded();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeGlassPaneImpl.this.activateIfNeeded();
            }
        });
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeGlassPaneImpl.this.deactivateIfNeeded();
            }
        });
    }

    @Override
    public boolean isInModalContext() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof GlassPaneDialogWrapperPeer.TransparentLayeredPane)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.myPainters.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        for (Painter painter : this.myPainters) {
            Rectangle clip = g.getClipBounds();
            Component component = this.myPainter2Component.get(painter);
            if (component.getParent() == null) continue;
            Rectangle componentBounds = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), this);
            if (!painter.needsRepaint() || !clip.contains(componentBounds) && !clip.intersects(componentBounds)) continue;
            Point targetPoint = SwingUtilities.convertPoint(this, 0, 0, component);
            Rectangle targetRect = new Rectangle(targetPoint, component.getSize());
            g2d.translate(-targetRect.x, -targetRect.y);
            painter.paint(component, g2d);
            g2d.translate(targetRect.x, targetRect.y);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public boolean hasPainters() {
        return !this.myPainters.isEmpty();
    }

    public void onNeedsRepaint(Painter painter, JComponent dirtyComponent) {
        Rectangle rec;
        if (dirtyComponent != null && dirtyComponent.isShowing() && (rec = SwingUtilities.convertRectangle(dirtyComponent, dirtyComponent.getBounds(), this)) != null) {
            this.repaint(rec);
            return;
        }
        this.repaint();
    }

    public Component getTargetComponentFor(MouseEvent e) {
        Component candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getLayeredPane());
        if (candidate != null) {
            return candidate;
        }
        candidate = IdeGlassPaneImpl.findComponent(e, this.myRootPane.getContentPane());
        if (candidate != null) {
            return candidate;
        }
        return e.getComponent();
    }

    private static Component findComponent(MouseEvent e, Container container) {
        Point lpPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), container);
        return SwingUtilities.getDeepestComponentAt(container, lpPoint.x, lpPoint.y);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.hasPainters() && super.isOptimizedDrawingEnabled();
    }

    @Override
    public JComponent getProxyComponent() {
        return this.myFocusProxy;
    }
}

