/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.lang.reflect.Field;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IdeFocusTraversalPolicy
extends LayoutFocusTraversalPolicyExt {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy");
    @NonNls
    private static final String FOCUS_TRAVERSAL_POLICY_FIELD = "focusTraversalPolicy";

    @Override
    protected Component getDefaultComponentImpl(Container focusCycleRoot) {
        if (!(focusCycleRoot instanceof JComponent)) {
            return super.getDefaultComponent(focusCycleRoot);
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)focusCycleRoot, this);
    }

    public static JComponent getPreferredFocusedComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/ex/IdeFocusTraversalPolicy", "getPreferredFocusedComponent"));
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component, null);
    }

    public static JComponent getPreferredFocusedComponent(final @NotNull JComponent component, FocusTraversalPolicy policyToIgnore) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/ex/IdeFocusTraversalPolicy", "getPreferredFocusedComponent"));
        }
        if (!component.isVisible()) {
            return null;
        }
        FocusTraversalPolicy focusTraversalPolicy = IdeFocusTraversalPolicy.getFocusTraversalPolicyAwtImpl(component);
        if (focusTraversalPolicy != null && focusTraversalPolicy != policyToIgnore) {
            Component defaultComponent;
            if (focusTraversalPolicy.getClass().getName().indexOf("LegacyGlueFocusTraversalPolicy") >= 0) {
                return component;
            }
            if (focusTraversalPolicy instanceof LayoutFocusTraversalPolicyExt) {
                final LayoutFocusTraversalPolicyExt extPolicy = (LayoutFocusTraversalPolicyExt)focusTraversalPolicy;
                defaultComponent = extPolicy.queryImpl(new Computable<Component>(){

                    public Component compute() {
                        return extPolicy.getDefaultComponent(component);
                    }
                });
            } else {
                defaultComponent = focusTraversalPolicy.getDefaultComponent(component);
            }
            if (defaultComponent instanceof JComponent) {
                return (JComponent)defaultComponent;
            }
        }
        if (component instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)component;
            Component selectedComponent = tabbedPane.getSelectedComponent();
            if (selectedComponent instanceof JComponent) {
                return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)selectedComponent);
            }
            return null;
        }
        if (IdeFocusTraversalPolicy._accept(component)) {
            return component;
        }
        for (Component ca : component.getComponents()) {
            JComponent c;
            if (!(ca instanceof JComponent) || (c = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)ca)) == null) continue;
            return c;
        }
        return null;
    }

    private static FocusTraversalPolicy getFocusTraversalPolicyAwtImpl(JComponent component) {
        try {
            Field field = Container.class.getDeclaredField(FOCUS_TRAVERSAL_POLICY_FIELD);
            field.setAccessible(true);
            return (FocusTraversalPolicy)field.get(component);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    protected final boolean accept(Component aComponent) {
        if (aComponent instanceof JComponent) {
            return IdeFocusTraversalPolicy._accept((JComponent)aComponent);
        }
        return super.accept(aComponent);
    }

    private static boolean _accept(JComponent component) {
        if (!(component.isEnabled() && component.isVisible() && component.isFocusable())) {
            return false;
        }
        if (component instanceof EditorComponentImpl || component instanceof EditorWindowHolder) {
            return true;
        }
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).isEditable();
        }
        return component instanceof AbstractButton || component instanceof JList || component instanceof JTree || component instanceof JTable || component instanceof JComboBox;
    }
}

