/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileImpl
extends VirtualFileSystemEntry {
    private Charset myCharset;

    VirtualFileImpl(int nameId, VirtualDirectoryImpl parent, int id, @PersistentFS.Attributes int attributes) {
        super(nameId, parent, id, attributes);
    }

    protected void storeCharset(Charset charset) {
        this.myCharset = charset;
    }

    protected Charset getStoredCharset() {
        return this.myCharset;
    }

    @Nullable
    public NewVirtualFile findChild(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "findChild"));
        }
        return null;
    }

    @NotNull
    public Collection<VirtualFile> getCachedChildren() {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getCachedChildren"));
        }
        return list;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        Iterable iterable = ContainerUtil.emptyIterable();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "iterInDbChildren"));
        }
        return iterable;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        VirtualFileSystemEntry parent = this.getParent();
        assert (parent != null);
        NewVirtualFileSystem newVirtualFileSystem = parent.getFileSystem();
        if (newVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getFileSystem"));
        }
        return newVirtualFileSystem;
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "refreshAndFindChild"));
        }
        return null;
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "findChildIfCached"));
        }
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public boolean isDirectory() {
        return false;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM((InputStream)ourPersistence.getInputStream((VirtualFile)this), (VirtualFile)this);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getInputStream"));
        }
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = this.contentsToByteArray(true);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    public byte[] contentsToByteArray(boolean cacheContent) throws IOException {
        byte[] byArray = ourPersistence.contentsToByteArray((VirtualFile)this, cacheContent);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long modStamp, long timeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)ourPersistence.getOutputStream((VirtualFile)this, requestor, modStamp, timeStamp), (VirtualFile)this);
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getOutputStream"));
        }
        return outputStream;
    }

    public String getDetectedLineSeparator() {
        if (this.getFlagInt(0x8000000)) {
            return LineSeparator.getSystemLineSeparator().getSeparatorString();
        }
        return super.getDetectedLineSeparator();
    }

    public void setDetectedLineSeparator(String separator) {
        boolean hasSystemSeparator = LineSeparator.getSystemLineSeparator().getSeparatorString().equals(separator);
        this.setFlagInt(0x8000000, hasSystemSeparator);
        super.setDetectedLineSeparator(hasSystemSeparator ? null : separator);
    }
}

