/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.util.ArrayUtil;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;

class SubList<E>
extends AbstractList<E>
implements RandomAccess {
    private final E[] a;
    private final int start;
    private final int end;

    SubList(@NotNull E[] array, int start, int end) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/SubList", "<init>"));
        }
        this.a = array;
        this.start = start;
        this.end = end;
        assert (start <= this.a.length);
        assert (end <= this.a.length);
        assert (start <= end && start >= 0);
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = Arrays.copyOfRange(this.a, this.start, this.end);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/SubList", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/impl/SubList", "toArray"));
        }
        int size = this.size();
        if (a.length < size) {
            T[] TArray = Arrays.copyOfRange(this.a, this.start, this.end, a.getClass());
            if (TArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/SubList", "toArray"));
            }
            return TArray;
        }
        System.arraycopy(this.a, this.start, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/SubList", "toArray"));
        }
        return a;
    }

    @Override
    public E get(int index) {
        return this.a[index + this.start];
    }

    @Override
    public int indexOf(Object o) {
        return ArrayUtil.indexOf((Object[])this.a, (Object)o, (int)this.start, (int)this.end);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }
}

