/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimedReference;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.jar.JarHandlerBase");
    private static final long DEFAULT_LENGTH = 0L;
    private static final long DEFAULT_TIMESTAMP = -1L;
    private final TimedReference<JarFile> myJarFile;
    private Reference<Map<String, EntryInfo>> myRelPathsToEntries;
    private final Object lock;
    protected final String myBasePath;

    public JarHandlerBase(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "<init>"));
        }
        this.myJarFile = new TimedReference(null);
        this.myRelPathsToEntries = new SoftReference(null);
        this.lock = new Object();
        this.myBasePath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.myRelPathsToEntries = null;
            this.myJarFile.set(null);
        }
    }

    public File getMirrorFile(@NotNull File originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getMirrorFile"));
        }
        return originalFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JarFile getJar() {
        JarFile jar = (JarFile)this.myJarFile.get();
        if (jar == null) {
            Object object = this.lock;
            synchronized (object) {
                jar = (JarFile)this.myJarFile.get();
                if (jar == null && (jar = this.createJarFile()) != null) {
                    this.myJarFile.set((Object)jar);
                }
            }
        }
        return jar;
    }

    @Nullable
    protected JarFile createJarFile() {
        File originalFile = this.getOriginalFile();
        try {
            final ZipFile zipFile = new ZipFile(this.getMirrorFile(originalFile));
            return new JarFile(){

                public JarFile.JarEntry getEntry(String name) {
                    try {
                        ZipEntry entry = zipFile.getEntry(name);
                        if (entry != null) {
                            class MyJarEntry
                            implements JarFile.JarEntry {
                                private final ZipEntry myEntry;

                                MyJarEntry(ZipEntry entry) {
                                    this.myEntry = entry;
                                }

                                public ZipEntry getEntry() {
                                    return this.myEntry;
                                }

                                public String getName() {
                                    return this.myEntry.getName();
                                }

                                public long getSize() {
                                    return this.myEntry.getSize();
                                }

                                public long getTime() {
                                    return this.myEntry.getTime();
                                }

                                public boolean isDirectory() {
                                    return this.myEntry.isDirectory();
                                }
                            }
                            return new MyJarEntry(entry);
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.warn("corrupted: " + zipFile.getName(), (Throwable)e);
                    }
                    return null;
                }

                public InputStream getInputStream(JarFile.JarEntry entry) throws IOException {
                    return zipFile.getInputStream(((MyJarEntry)entry).myEntry);
                }

                public Enumeration<? extends JarFile.JarEntry> entries() {
                    return new Enumeration<JarFile.JarEntry>(){
                        private final Enumeration<? extends ZipEntry> entries;
                        {
                            this.entries = zipFile.entries();
                        }

                        @Override
                        public boolean hasMoreElements() {
                            return this.entries.hasMoreElements();
                        }

                        @Override
                        public JarFile.JarEntry nextElement() {
                            try {
                                ZipEntry entry = this.entries.nextElement();
                                if (entry != null) {
                                    return new MyJarEntry(entry);
                                }
                            }
                            catch (RuntimeException e) {
                                LOG.warn("corrupted: " + zipFile.getName(), (Throwable)e);
                            }
                            return null;
                        }
                    };
                }

                public ZipFile getZipFile() {
                    return zipFile;
                }
            };
        }
        catch (IOException e) {
            LOG.warn(e.getMessage() + ": " + originalFile.getPath(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    protected File getOriginalFile() {
        File file = new File(this.myBasePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOriginalFile"));
        }
        return file;
    }

    @NotNull
    private static EntryInfo getOrCreate(@NotNull String entryName, boolean isDirectory, @NotNull Map<String, EntryInfo> map) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
        }
        EntryInfo info = map.get(entryName);
        if (info == null) {
            String shortName;
            int idx = entryName.lastIndexOf(47);
            String parentEntryName = idx > 0 ? entryName.substring(0, idx) : "";
            String string = shortName = idx > 0 ? entryName.substring(idx + 1) : entryName;
            if (".".equals(shortName)) {
                EntryInfo entryInfo = JarHandlerBase.getOrCreate(parentEntryName, true, map);
                if (entryInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
                }
                return entryInfo;
            }
            info = new EntryInfo(shortName, JarHandlerBase.getOrCreate(parentEntryName, true, map), isDirectory);
            map.put(entryName, info);
        }
        EntryInfo entryInfo = info;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getOrCreate"));
        }
        return entryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "list"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        EntryInfo parentEntry = this.getEntryInfo(file);
        HashSet<String> names = new HashSet<String>();
        Iterator<EntryInfo> i$ = this.getEntriesMap().values().iterator();
        while (true) {
            if (!i$.hasNext()) {
                String[] stringArray = ArrayUtil.toStringArray(names);
                // MONITOREXIT : object
                if (stringArray != null) return stringArray;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "list"));
            }
            EntryInfo info = i$.next();
            if (info.parent != parentEntry) continue;
            names.add(info.shortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntryInfo getEntryInfo(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntryInfo"));
        }
        Object object = this.lock;
        synchronized (object) {
            String parentPath = this.getRelativePath(file);
            return this.getEntryInfo(parentPath);
        }
    }

    public EntryInfo getEntryInfo(@NotNull String parentPath) {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntryInfo"));
        }
        return this.getEntriesMap().get(parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Object object = this.lock;
        // MONITORENTER : object
        THashMap map = (THashMap)SoftReference.dereference(this.myRelPathsToEntries);
        if (map == null) {
            JarFile zip = this.getJar();
            if (zip == null) {
                map = Collections.emptyMap();
            } else {
                LogUtil.debug((Logger)LOG, (String)"mapping %s", (Object[])new Object[]{this.myBasePath});
                map = new THashMap();
                map.put("", new EntryInfo("", null, true));
                Enumeration entries = zip.entries();
                while (entries.hasMoreElements()) {
                    JarFile.JarEntry entry = (JarFile.JarEntry)entries.nextElement();
                    String name = entry.getName();
                    boolean isDirectory = StringUtil.endsWithChar((CharSequence)name, (char)'/');
                    JarHandlerBase.getOrCreate(isDirectory ? name.substring(0, name.length() - 1) : name, isDirectory, (Map<String, EntryInfo>)map);
                }
                this.myRelPathsToEntries = new SoftReference((Object)map);
            }
        }
        THashMap tHashMap = map;
        // MONITOREXIT : object
        if (tHashMap != null) return tHashMap;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getEntriesMap"));
    }

    @NotNull
    private String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getRelativePath"));
        }
        String path = file.getPath().substring(this.myBasePath.length() + 1);
        String string = StringUtil.startsWithChar((CharSequence)path, (char)'/') ? path.substring(1) : path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getRelativePath"));
        }
        return string;
    }

    @Nullable
    private JarFile.JarEntry convertToEntry(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "convertToEntry"));
        }
        String path = this.getRelativePath(file);
        JarFile jar = this.getJar();
        return jar == null ? null : jar.getEntry(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getLength"));
        }
        JarFile.JarEntry entry = this.convertToEntry(file);
        Object object = this.lock;
        synchronized (object) {
            return entry == null ? 0L : entry.getSize();
        }
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getInputStream"));
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
        if (bufferExposingByteArrayInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getInputStream"));
        }
        return bufferExposingByteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        byte[] byArray;
        InputStream stream;
        block11: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
            }
            JarFile.JarEntry entry = this.convertToEntry(file);
            if (entry == null) {
                if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
                }
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            Object object = this.lock;
            synchronized (object) {
                JarFile jar = this.getJar();
                assert (jar != null) : file;
                stream = jar.getInputStream(entry);
                assert (stream != null) : file;
                byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)entry.getSize()));
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (byArray != null) break block11;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "contentsToByteArray"));
        }
        return byArray;
        {
            finally {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getTimeStamp"));
        }
        if (file.getParent() == null) {
            return this.getOriginalFile().lastModified();
        }
        JarFile.JarEntry entry = this.convertToEntry(file);
        Object object = this.lock;
        synchronized (object) {
            return entry == null ? -1L : entry.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "isDirectory"));
        }
        if (file.getParent() == null) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            String path = this.getRelativePath(file);
            EntryInfo info = this.getEntryInfo(path);
            return info == null || info.isDirectory;
        }
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "exists"));
        }
        if (fileOrDirectory.getParent() == null) {
            return this.myJarFile.get() != null || this.getOriginalFile().exists();
        }
        return this.getEntryInfo(fileOrDirectory) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase", "getAttributes"));
        }
        JarFile.JarEntry entry = this.convertToEntry(file);
        Object object = this.lock;
        synchronized (object) {
            EntryInfo entryInfo = this.getEntryInfo(this.getRelativePath(file));
            if (entryInfo == null) {
                return null;
            }
            long length = entry != null ? entry.getSize() : 0L;
            long timeStamp = entry != null ? entry.getTime() : -1L;
            return new FileAttributes(entryInfo.isDirectory, false, false, false, length, timeStamp, false);
        }
    }

    protected static class EntryInfo {
        protected final boolean isDirectory;
        @NotNull
        protected final String shortName;
        protected final EntryInfo parent;

        public EntryInfo(@NotNull String shortName, EntryInfo parent, boolean directory) {
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandlerBase$EntryInfo", "<init>"));
            }
            this.shortName = shortName;
            this.parent = parent;
            this.isDirectory = directory;
        }
    }
}

