/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.jar.JarHandlerBase;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandler
extends JarHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.jar.JarHandler");
    @NonNls
    private static final String JARS_FOLDER = "jars";
    private static final int FS_TIME_RESOLUTION = 2000;
    private final JarFileSystemImpl myFileSystem;
    private static final NotNullLazyValue<NotificationGroup> ERROR_COPY_NOTIFICATION = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = NotificationGroup.balloonGroup((String)VfsBundle.message((String)"jar.copy.error.title", (Object[])new Object[0]));
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler$1", "compute"));
            }
            return notificationGroup;
        }
    };

    public JarHandler(@NotNull JarFileSystemImpl fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandler", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarHandler", "<init>"));
        }
        super(path);
        this.myFileSystem = fileSystem;
    }

    public void refreshLocalFileForJar() {
        NewVirtualFile localJarFile = (NewVirtualFile)LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myBasePath);
        if (localJarFile != null) {
            localJarFile.markDirty();
        }
    }

    @Nullable
    public VirtualFile markDirty() {
        this.clear();
        VirtualFile root = JarFileSystem.getInstance().findFileByPath(this.myBasePath + "!/");
        if (root instanceof NewVirtualFile) {
            ((NewVirtualFile)root).markDirty();
        }
        return root;
    }

    @Override
    public File getMirrorFile(@NotNull File originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandler", "getMirrorFile"));
        }
        if (!this.myFileSystem.isMakeCopyOfJar(originalFile)) {
            return originalFile;
        }
        FileAttributes originalAttributes = FileSystemUtil.getAttributes((File)originalFile);
        if (originalAttributes == null) {
            return originalFile;
        }
        String folderPath = JarHandler.getJarsDir();
        if (!new File(folderPath).exists() && !new File(folderPath).mkdirs()) {
            return originalFile;
        }
        if (FSRecords.weHaveContentHashes) {
            return this.getMirrorWithContentHash(originalFile, originalAttributes);
        }
        String mirrorName = originalFile.getName() + "." + Integer.toHexString(originalFile.getPath().hashCode());
        File mirrorFile = new File(folderPath, mirrorName);
        FileAttributes mirrorAttributes = FileSystemUtil.getAttributes((File)mirrorFile);
        if (mirrorAttributes == null || originalAttributes.length != mirrorAttributes.length || Math.abs(originalAttributes.lastModified - mirrorAttributes.lastModified) > 2000L) {
            return this.copyToMirror(originalFile, mirrorFile);
        }
        return mirrorFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getMirrorWithContentHash(File originalFile, FileAttributes originalAttributes) {
        File mirrorFile = null;
        String jarDir = JarHandler.getJarsDir();
        try {
            FileAttributes mirrorFileAttributes;
            String path = originalFile.getPath();
            CacheLibraryInfo info = (CacheLibraryInfo)CacheLibraryInfo.ourCachedLibraryInfo.get((Object)path);
            if (info != null && originalAttributes.length == info.myFileLength && Math.abs(originalAttributes.lastModified - info.myModificationTime) <= 2000L && (mirrorFileAttributes = FileSystemUtil.getAttributes((File)(mirrorFile = new File(new File(jarDir), info.mySnapshotPath)))) != null && mirrorFileAttributes.length == originalAttributes.length && mirrorFileAttributes.lastModified - originalAttributes.lastModified <= 2000L) {
                return mirrorFile;
            }
            FilterOutputStream os = null;
            FileInputStream is = null;
            MessageDigest sha1 = null;
            File tempJarFile = null;
            try {
                int read;
                tempJarFile = FileUtil.createTempFile((File)new File(jarDir), (String)originalFile.getName(), (String)"", (boolean)true, (boolean)false);
                os = new DataOutputStream(new FileOutputStream(tempJarFile));
                is = new FileInputStream(originalFile);
                byte[] buffer = new byte[20480];
                sha1 = MessageDigest.getInstance("SHA1");
                sha1.update(String.valueOf(originalAttributes.length).getBytes(Charset.defaultCharset()));
                sha1.update("\u0000".getBytes(Charset.defaultCharset()));
                while ((read = is.read(buffer)) != -1) {
                    sha1.update(buffer, 0, read);
                    ((DataOutputStream)os).write(buffer, 0, read);
                }
            }
            catch (IOException ex) {
                File target = mirrorFile != null ? mirrorFile : (tempJarFile != null ? tempJarFile : new File(jarDir));
                this.reportIOErrorWithJars(originalFile, target, ex);
                File file = originalFile;
                return file;
            }
            catch (NoSuchAlgorithmException ex) {
                assert (false);
                File target = originalFile;
                return target;
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ignored) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            byte[] digest = sha1.digest();
            mirrorFile = new File(new File(jarDir), this.getSnapshotName(originalFile.getName(), digest));
            mirrorFileAttributes = FileSystemUtil.getAttributes((File)mirrorFile);
            if (mirrorFileAttributes == null || originalAttributes.length != mirrorFileAttributes.length || mirrorFileAttributes.lastModified - originalAttributes.lastModified > 2000L) {
                try {
                    if (mirrorFileAttributes != null) {
                        FileUtil.delete((File)mirrorFile);
                    }
                    FileUtil.rename((File)tempJarFile, (File)mirrorFile);
                    mirrorFile.setLastModified(originalAttributes.lastModified);
                }
                catch (IOException ex) {
                    this.reportIOErrorWithJars(originalFile, mirrorFile, ex);
                    return originalFile;
                }
            } else {
                FileUtil.delete((File)tempJarFile);
            }
            info = new CacheLibraryInfo(mirrorFile.getName(), originalAttributes.lastModified, originalAttributes.length);
            CacheLibraryInfo.ourCachedLibraryInfo.put((Object)path, (Object)info);
            CacheLibraryInfo.ourCachedLibraryInfo.force();
            return mirrorFile;
        }
        catch (IOException ex) {
            this.reportIOErrorWithJars(originalFile, mirrorFile != null ? mirrorFile : new File(jarDir, originalFile.getName()), ex);
            return originalFile;
        }
    }

    private String getSnapshotName(String name, byte[] digest) {
        StringBuilder builder = new StringBuilder(name.length() + 1 + 2 * digest.length);
        builder.append(name).append('.');
        for (byte b : digest) {
            builder.append(Character.forDigit((b & 0xF0) >> 4, 16));
            builder.append(Character.forDigit(b & 0xF, 16));
        }
        return builder.toString();
    }

    @NotNull
    private static String getJarsDir() {
        String dir = System.getProperty("jars_dir");
        String string = dir == null ? PathManager.getSystemPath() + File.separatorChar + JARS_FOLDER : dir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler", "getJarsDir"));
        }
        return string;
    }

    @NotNull
    private File copyToMirror(@NotNull File original, @NotNull File mirror) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
        }
        if (mirror == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.pushState();
            progress.setText(VfsBundle.message((String)"jar.copy.progress", (Object[])new Object[]{original.getPath()}));
            progress.setFraction(0.0);
        }
        try {
            FileUtil.copy((File)original, (File)mirror);
        }
        catch (IOException e) {
            this.reportIOErrorWithJars(original, mirror, e);
            File file = original;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
            }
            return file;
        }
        if (progress != null) {
            progress.popState();
        }
        File file = mirror;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
        }
        return file;
    }

    private void reportIOErrorWithJars(File original, File target, IOException e) {
        LOG.warn((Throwable)e);
        String path = original.getPath();
        this.myFileSystem.setNoCopyJarForPath(path);
        String message = VfsBundle.message((String)"jar.copy.error.message", (Object[])new Object[]{path, target.getPath(), e.getMessage()});
        ((NotificationGroup)ERROR_COPY_NOTIFICATION.getValue()).createNotification(message, NotificationType.ERROR).notify(null);
    }

    private static class CacheLibraryInfo {
        private final String mySnapshotPath;
        private final long myModificationTime;
        private final long myFileLength;
        private static final PersistentHashMap<String, CacheLibraryInfo> ourCachedLibraryInfo;

        /*
         * WARNING - void declaration
         */
        private CacheLibraryInfo(@NotNull String path, long time, long l) {
            void length;
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo", "<init>"));
            }
            this.mySnapshotPath = path;
            this.myModificationTime = time;
            this.myFileLength = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheLibraryInfo info = (CacheLibraryInfo)o;
            if (this.myFileLength != info.myFileLength) {
                return false;
            }
            if (this.myModificationTime != info.myModificationTime) {
                return false;
            }
            return this.mySnapshotPath.equals(info.mySnapshotPath);
        }

        public int hashCode() {
            int result = this.mySnapshotPath.hashCode();
            result = 31 * result + (int)(this.myModificationTime ^ this.myModificationTime >>> 32);
            result = 31 * result + (int)(this.myFileLength ^ this.myFileLength >>> 32);
            return result;
        }

        static {
            File file = new File(new File(JarHandler.getJarsDir()), "snapshots_info");
            PersistentHashMap info = null;
            for (int i = 0; i < 2; ++i) {
                try {
                    info = new PersistentHashMap(file, (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new DataExternalizer<CacheLibraryInfo>(){
                        private final byte[] myBuffer = IOUtil.allocReadWriteUTFBuffer();

                        public void save(@NotNull DataOutput out, CacheLibraryInfo value) throws IOException {
                            if (out == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo$1", "save"));
                            }
                            IOUtil.writeUTFFast((byte[])this.myBuffer, (DataOutput)out, (String)value.mySnapshotPath);
                            out.writeLong(value.myModificationTime);
                            out.writeLong(value.myFileLength);
                        }

                        public CacheLibraryInfo read(@NotNull DataInput in) throws IOException {
                            if (in == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo$1", "read"));
                            }
                            return new CacheLibraryInfo(IOUtil.readUTFFast((byte[])this.myBuffer, (DataInput)in), in.readLong(), in.readLong());
                        }
                    });
                    break;
                }
                catch (IOException ex) {
                    PersistentHashMap.deleteFilesStartingWith((File)file);
                    continue;
                }
            }
            assert (info != null);
            ourCachedLibraryInfo = info;
        }
    }
}

