/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemBase;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.UriUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualFileImpl
extends HttpVirtualFile {
    private final HttpFileSystemBase myFileSystem;
    @Nullable
    private final RemoteFileInfoImpl myFileInfo;
    private FileType myInitialFileType;
    private final String myPath;
    private final String myParentPath;
    private final String myName;

    VirtualFileImpl(HttpFileSystemBase fileSystem, String path, @Nullable RemoteFileInfoImpl fileInfo) {
        this.myFileSystem = fileSystem;
        this.myPath = path;
        this.myFileInfo = fileInfo;
        if (this.myFileInfo != null) {
            this.myFileInfo.addDownloadingListener(new FileDownloadingAdapter(){

                @Override
                public void fileDownloaded(final VirtualFile localFile) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            VirtualFileImpl file = VirtualFileImpl.this;
                            FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{file});
                            if (!localFile.getFileType().equals(VirtualFileImpl.this.myInitialFileType)) {
                                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
                            }
                        }
                    });
                }
            });
            path = UriUtil.trimTrailingSlashes(UriUtil.trimParameters(path));
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == -1) {
                this.myParentPath = null;
                this.myName = path;
            } else {
                this.myParentPath = path.substring(0, lastSlash);
                this.myName = path.substring(lastSlash + 1);
            }
        } else {
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == path.length() - 1) {
                this.myParentPath = null;
                this.myName = path;
            } else {
                int prevSlash = path.lastIndexOf(47, lastSlash - 1);
                if (prevSlash < 0) {
                    this.myParentPath = path.substring(0, lastSlash + 1);
                    this.myName = path.substring(lastSlash + 1);
                } else {
                    this.myParentPath = path.substring(0, lastSlash);
                    this.myName = path.substring(lastSlash + 1);
                }
            }
        }
    }

    @Override
    @Nullable
    public RemoteFileInfoImpl getFileInfo() {
        return this.myFileInfo;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        HttpFileSystemBase httpFileSystemBase = this.myFileSystem;
        if (httpFileSystemBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "getFileSystem"));
        }
        return httpFileSystemBase;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "getName"));
        }
        return string;
    }

    public String toString() {
        return "HttpVirtualFile:" + this.myPath + ", info=" + this.myFileInfo;
    }

    public VirtualFile getParent() {
        if (this.myParentPath == null) {
            return null;
        }
        return this.myFileSystem.findFileByPath(this.myParentPath, true);
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isDirectory() {
        return this.myFileInfo == null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public FileType getFileType() {
        if (this.myFileInfo == null) {
            FileType fileType = super.getFileType();
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "getFileType"));
            }
            return fileType;
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            FileType fileType = localFile.getFileType();
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "getFileType"));
            }
            return fileType;
        }
        FileType fileType = super.getFileType();
        if (this.myInitialFileType == null) {
            this.myInitialFileType = fileType;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "getFileType"));
        }
        return fileType2;
    }

    public InputStream getInputStream() throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            return localFile.getInputStream();
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        VirtualFile localFile;
        if (this.myFileInfo != null && (localFile = this.myFileInfo.getLocalFile()) != null) {
            OutputStream outputStream = localFile.getOutputStream(requestor, newModificationStamp, newTimeStamp);
            if (outputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "getOutputStream"));
            }
            return outputStream;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myFileInfo == null) {
            throw new UnsupportedOperationException();
        }
        VirtualFile localFile = this.myFileInfo.getLocalFile();
        if (localFile != null) {
            byte[] byArray = localFile.contentsToByteArray();
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "contentsToByteArray"));
            }
            return byArray;
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/VirtualFileImpl", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getLength() {
        return -1L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (this.myFileInfo != null) {
            this.myFileInfo.refresh(postRunnable);
        } else if (postRunnable != null) {
            postRunnable.run();
        }
    }
}

